/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class LocationMappedReachedSet
extends PartitionedReachedSet {
    public LocationMappedReachedSet(ConfigurableProgramAnalysis pCpa, Waitlist.WaitlistFactory waitlistFactory) {
        super(pCpa, waitlistFactory);
    }

    @Override
    public Collection<AbstractState> getReached(CFANode location) {
        Preconditions.checkNotNull((Object)location);
        return this.getReachedForKey(location);
    }

    @Override
    protected Object getPartitionKey(AbstractState pState) {
        CFANode location = AbstractStates.extractLocation(pState);
        Preconditions.checkNotNull((Object)location, (Object)"Location information necessary for LocationMappedReachedSet");
        return location;
    }

    public Set<CFANode> getLocations() {
        return super.getKeySet();
    }
}

