/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.DefaultReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

public class PartitionedReachedSet
extends DefaultReachedSet {
    private final Multimap<Object, AbstractState> partitionedReached = LinkedHashMultimap.create((int)100, (int)1);

    public PartitionedReachedSet(ConfigurableProgramAnalysis pCpa, Waitlist.WaitlistFactory waitlistFactory) {
        super(pCpa, waitlistFactory);
    }

    @Override
    public void add(AbstractState pState, Precision pPrecision) {
        super.add(pState, pPrecision);
        this.partitionedReached.put(this.getPartitionKey(pState), (Object)pState);
    }

    @Override
    public void remove(AbstractState pState) {
        super.remove(pState);
        this.partitionedReached.remove(this.getPartitionKey(pState), (Object)pState);
    }

    @Override
    public void clear() {
        super.clear();
        this.partitionedReached.clear();
    }

    @Override
    public Collection<AbstractState> getReached(AbstractState pState) {
        return this.getReachedForKey(this.getPartitionKey(pState));
    }

    public int getNumberOfPartitions() {
        return this.partitionedReached.keySet().size();
    }

    public Map.Entry<Object, Collection<AbstractState>> getMaxPartition() {
        int max = 0;
        Map.Entry maxPartition = null;
        for (Map.Entry partition : this.partitionedReached.asMap().entrySet()) {
            int size = ((Collection)partition.getValue()).size();
            if (size <= max) continue;
            max = ((Collection)partition.getValue()).size();
            maxPartition = partition;
        }
        return maxPartition;
    }

    protected Object getPartitionKey(AbstractState pState) {
        Preconditions.checkNotNull((Object)pState);
        assert (pState instanceof Partitionable) : "Partitionable states necessary for PartitionedReachedSet";
        return ((Partitionable)((Object)pState)).getPartitionKey();
    }

    protected Collection<AbstractState> getReachedForKey(@Nullable Object key) {
        return Collections.unmodifiableCollection(this.partitionedReached.get(key));
    }

    protected Set<?> getKeySet() {
        return Collections.unmodifiableSet(this.partitionedReached.keySet());
    }
}

