/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PseudoPartitionable;
import org.sosy_lab.cpachecker.core.reachedset.DefaultReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

public class PseudoPartitionedReachedSet
extends DefaultReachedSet {
    private final HashBasedTable<Optional<Object>, Comparable<?>, SetMultimap<Object, AbstractState>> partitionedReached = HashBasedTable.create((int)1, (int)1);

    public PseudoPartitionedReachedSet(ConfigurableProgramAnalysis pCpa, Waitlist.WaitlistFactory waitlistFactory) {
        super(pCpa, waitlistFactory);
    }

    @Override
    public void add(AbstractState pState, Precision pPrecision) {
        super.add(pState, pPrecision);
        Optional<Object> key = PseudoPartitionedReachedSet.getPartitionKey(pState);
        Comparable<?> pseudoKey = PseudoPartitionedReachedSet.getPseudoPartitionKey(pState);
        Object pseudoHash = PseudoPartitionedReachedSet.getPseudoHashCode(pState);
        SetMultimap states = (SetMultimap)this.partitionedReached.get(key, pseudoKey);
        if (states == null) {
            states = HashMultimap.create();
            this.partitionedReached.put(key, pseudoKey, (Object)states);
        }
        states.put(pseudoHash, (Object)pState);
    }

    @Override
    public void remove(AbstractState pState) {
        super.remove(pState);
        Optional<Object> key = PseudoPartitionedReachedSet.getPartitionKey(pState);
        Comparable<?> pseudoKey = PseudoPartitionedReachedSet.getPseudoPartitionKey(pState);
        Object pseudoHash = PseudoPartitionedReachedSet.getPseudoHashCode(pState);
        SetMultimap states = (SetMultimap)this.partitionedReached.get(key, pseudoKey);
        if (states != null) {
            states.remove(pseudoHash, (Object)pState);
            if (states.isEmpty()) {
                this.partitionedReached.remove(key, pseudoKey);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.partitionedReached.clear();
    }

    public Set<AbstractState> getReached(AbstractState pState) {
        Optional<Object> key = PseudoPartitionedReachedSet.getPartitionKey(pState);
        Comparable<?> pseudoKey = PseudoPartitionedReachedSet.getPseudoPartitionKey(pState);
        Object pseudoHash = PseudoPartitionedReachedSet.getPseudoHashCode(pState);
        Map partition = this.partitionedReached.row(key);
        if (partition == null) {
            return ImmutableSet.of();
        }
        Object states = partition.containsKey(pseudoKey) ? ((SetMultimap)partition.get(pseudoKey)).get(pseudoHash) : ImmutableSet.of();
        for (Map.Entry entry : partition.entrySet()) {
            if (pseudoKey.compareTo(entry.getKey()) <= 0) continue;
            SetMultimap m = (SetMultimap)entry.getValue();
            for (Object mKey : m.keySet()) {
                states = Sets.union((Set)states, (Set)m.get(mKey));
            }
        }
        return Collections.unmodifiableSet(states);
    }

    private static Comparable<?> getPseudoPartitionKey(AbstractState pState) {
        Preconditions.checkNotNull((Object)pState);
        assert (pState instanceof PseudoPartitionable) : "PseudoPartitionable states necessary for PseudoPartitionedReachedSet";
        return ((PseudoPartitionable)((Object)pState)).getPseudoPartitionKey();
    }

    private static Object getPseudoHashCode(AbstractState pState) {
        Preconditions.checkNotNull((Object)pState);
        assert (pState instanceof PseudoPartitionable) : "PseudoPartitionable states necessary for PseudoPartitionedReachedSet";
        return ((PseudoPartitionable)((Object)pState)).getPseudoHashCode();
    }

    private static Optional<Object> getPartitionKey(AbstractState pState) {
        Preconditions.checkNotNull((Object)pState);
        assert (pState instanceof Partitionable) : "Partitionable states necessary for PartitionedReachedSet";
        return Optional.ofNullable(((Partitionable)((Object)pState)).getPartitionKey());
    }
}

