/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.DefaultReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.PseudoPartitionedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.StatisticsReachedSet;
import org.sosy_lab.cpachecker.core.waitlist.AutomatonFailedMatchesWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.AutomatonMatchesWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.BlockConfiguration;
import org.sosy_lab.cpachecker.core.waitlist.BlockWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.BranchBasedWeightedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.CallstackSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.DepthBasedWeightedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.ExplicitSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.LoopIterationSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.LoopstackSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.PostorderSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.ReversePostorderSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.SMGSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.ThreadingSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.core.waitlist.WeightedRandomWaitlist;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariableWaitlist;
import org.sosy_lab.cpachecker.cpa.usage.UsageReachedSet;
import org.sosy_lab.cpachecker.cpa.usage.storage.UsageConfiguration;

@Options(prefix="analysis")
public class ReachedSetFactory {
    @Option(secure=true, name="traversal.order", description="which strategy to adopt for visiting states?")
    private Waitlist.TraversalMethod traversalMethod = Waitlist.TraversalMethod.DFS;
    @Option(secure=true, name="traversal.useCallstack", description="handle states with a deeper callstack first\nThis needs the CallstackCPA instance to have any effect.")
    private boolean useCallstack = false;
    @Option(secure=true, name="traversal.useLoopIterationCount", description="handle states with more loop iterations first.")
    private boolean useLoopIterationCount = false;
    @Option(secure=true, name="traversal.useReverseLoopIterationCount", description="handle states with fewer loop iterations first.")
    private boolean useReverseLoopIterationCount = false;
    @Option(secure=true, name="traversal.useLoopstack", description="handle states with a deeper loopstack first.")
    private boolean useLoopstack = false;
    @Option(secure=true, name="traversal.useReverseLoopstack", description="handle states with a more shallow loopstack first.")
    private boolean useReverseLoopstack = false;
    @Option(secure=true, name="traversal.useReversePostorder", description="Use an implementation of reverse postorder strategy that allows to select a secondary strategy that is used if there are two states with the same reverse postorder id. The secondary strategy is selected with 'analysis.traversal.order'.")
    private boolean useReversePostorder = false;
    @Option(secure=true, name="traversal.usePostorder", description="Use an implementation of postorder strategy that allows to select a secondary strategy that is used if there are two states with the same postorder id. The secondary strategy is selected with 'analysis.traversal.order'.")
    private boolean usePostorder = false;
    @Option(secure=true, name="traversal.useExplicitInformation", description="handle more abstract states (with less information) first? (only for ExplicitCPA)")
    private boolean useExplicitInformation = false;
    @Option(secure=true, name="traversal.useAutomatonInformation", description="handle abstract states with more automaton matches first? (only if AutomatonCPA enabled)")
    private boolean useAutomatonInformation = false;
    @Option(secure=true, name="traversal.byAutomatonVariable", description="traverse in the order defined by the values of an automaton variable")
    private @Nullable String byAutomatonVariable = null;
    @Option(secure=true, name="traversal.useNumberOfThreads", description="handle abstract states with fewer running threads first? (needs ThreadingCPA)")
    private boolean useNumberOfThreads = false;
    @Option(secure=true, name="traversal.useNumberOfHeapObjects", description="handle abstract states with fewer heap objects first? (needs SMGCPA)")
    private boolean useNumberOfHeapObjects = false;
    @Option(secure=true, name="traversal.weightedDepth", description="perform a weighted random selection based on the depth in the ARG")
    private boolean useWeightedDepthOrder = false;
    @Option(secure=true, name="traversal.weightedBranches", description="perform a weighted random selection based on the branching depth")
    private boolean useWeightedBranchOrder = false;
    @Option(secure=true, name="traversal.useBlocks", description="use blocks and set resource limits for its traversal, blocks are handled in DFS order")
    private boolean useBlocks = false;
    @Option(secure=true, name="reachedSet", description="which reached set implementation to use?\nNORMAL: just a simple set\nLOCATIONMAPPED: a different set per location (faster, states with different locations cannot be merged)\nPARTITIONED: partitioning depending on CPAs (e.g Location, Callstack etc.)\nPSEUDOPARTITIONED: based on PARTITIONED, uses additional info about the states' lattice (maybe faster for some special analyses which use merge_sep and stop_sep")
    private ReachedSetType reachedSet = ReachedSetType.PARTITIONED;
    @Option(secure=true, name="reachedSet.withStatistics", description="track more statistics about the reachedset")
    private boolean withStatistics = false;
    private @Nullable BlockConfiguration blockConfig;
    private @Nullable UsageConfiguration usageConfig;
    private  @Nullable WeightedRandomWaitlist.WaitlistOptions weightedWaitlistOptions;
    private final LogManager logger;

    public ReachedSetFactory(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.blockConfig = this.useBlocks ? new BlockConfiguration(pConfig) : null;
        this.usageConfig = this.reachedSet == ReachedSetType.USAGE ? new UsageConfiguration(pConfig) : null;
        this.weightedWaitlistOptions = this.useWeightedDepthOrder || this.useWeightedBranchOrder ? new WeightedRandomWaitlist.WaitlistOptions(pConfig) : null;
    }

    public ReachedSet create(ConfigurableProgramAnalysis cpa) {
        ReachedSet reached;
        Preconditions.checkNotNull((Object)cpa);
        Waitlist.WaitlistFactory waitlistFactory = this.traversalMethod;
        if (this.useWeightedDepthOrder) {
            waitlistFactory = DepthBasedWeightedWaitlist.factory(waitlistFactory, this.weightedWaitlistOptions);
        }
        if (this.useWeightedBranchOrder) {
            waitlistFactory = BranchBasedWeightedWaitlist.factory(waitlistFactory, this.weightedWaitlistOptions);
        }
        if (this.useAutomatonInformation) {
            waitlistFactory = AutomatonMatchesWaitlist.factory(waitlistFactory);
            waitlistFactory = AutomatonFailedMatchesWaitlist.factory(waitlistFactory);
        }
        if (this.useReversePostorder) {
            waitlistFactory = ReversePostorderSortedWaitlist.factory(waitlistFactory);
        }
        if (this.usePostorder) {
            waitlistFactory = PostorderSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useLoopIterationCount) {
            waitlistFactory = LoopIterationSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useReverseLoopIterationCount) {
            waitlistFactory = LoopIterationSortedWaitlist.reversedFactory(waitlistFactory);
        }
        if (this.useLoopstack) {
            waitlistFactory = LoopstackSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useReverseLoopstack) {
            waitlistFactory = LoopstackSortedWaitlist.reversedFactory(waitlistFactory);
        }
        if (this.useCallstack) {
            waitlistFactory = CallstackSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useExplicitInformation) {
            waitlistFactory = ExplicitSortedWaitlist.factory(waitlistFactory);
        }
        if (this.byAutomatonVariable != null) {
            waitlistFactory = AutomatonVariableWaitlist.factory(waitlistFactory, this.byAutomatonVariable);
        }
        if (this.useNumberOfThreads) {
            waitlistFactory = ThreadingSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useNumberOfHeapObjects) {
            waitlistFactory = SMGSortedWaitlist.factory(waitlistFactory);
        }
        if (this.useBlocks) {
            waitlistFactory = BlockWaitlist.factory(waitlistFactory, this.blockConfig, this.logger);
        }
        switch (this.reachedSet) {
            case PARTITIONED: {
                reached = new PartitionedReachedSet(cpa, waitlistFactory);
                break;
            }
            case PSEUDOPARTITIONED: {
                reached = new PseudoPartitionedReachedSet(cpa, waitlistFactory);
                break;
            }
            case LOCATIONMAPPED: {
                reached = new LocationMappedReachedSet(cpa, waitlistFactory);
                break;
            }
            case USAGE: {
                reached = new UsageReachedSet(cpa, waitlistFactory, this.usageConfig, this.logger);
                break;
            }
            default: {
                reached = new DefaultReachedSet(cpa, waitlistFactory);
            }
        }
        if (this.withStatistics) {
            reached = new StatisticsReachedSet(reached);
        }
        return reached;
    }

    public ReachedSet createAndInitialize(ConfigurableProgramAnalysis cpa, CFANode node, StateSpacePartition partition) throws InterruptedException {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)partition);
        ReachedSet reached = this.create(cpa);
        reached.add(cpa.getInitialState(node, partition), cpa.getInitialPrecision(node, partition));
        return reached;
    }

    private static enum ReachedSetType {
        NORMAL,
        LOCATIONMAPPED,
        PARTITIONED,
        PSEUDOPARTITIONED,
        USAGE;

    }
}

