/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatHist;

class StatisticsReachedSet
extends ForwardingReachedSet {
    private final StatCounter numPopFromWaitlist = new StatCounter("Number of calls to 'popFromWaitlist'");
    private final StatCounter numRemoveOnlyFromWaitlist = new StatCounter("Number of calls to 'removeOnlyFromWaitlist'");
    private final StatCounter numContains = new StatCounter("Number of calls to 'contains'");
    private final StatHist numAdd = new StatHist2("Average size of states for 'add'");
    private final StatHist numRemove = new StatHist2("Average size of states for 'remove'");
    private final StatCounter numReAdd = new StatCounter("Number of calls to 'reAdd'");
    private final StatCounter numUpdatePrecision = new StatCounter("Number of calls to 'updatePrecision'");
    private final StatHist sizeOfGetReached = new StatHist2("Average size of states from 'getReached'");

    public StatisticsReachedSet(ReachedSet pDelegate) {
        super(pDelegate);
    }

    @Override
    public Collection<AbstractState> getReached(AbstractState pState) throws UnsupportedOperationException {
        Collection<AbstractState> reached = super.getReached(pState);
        this.sizeOfGetReached.insertValue(reached.size());
        return reached;
    }

    @Override
    public Collection<AbstractState> getReached(CFANode pLocation) {
        Collection<AbstractState> reached = super.getReached(pLocation);
        this.sizeOfGetReached.insertValue(reached.size());
        return reached;
    }

    @Override
    public boolean contains(AbstractState pState) {
        this.numContains.inc();
        return super.contains(pState);
    }

    @Override
    public void add(AbstractState pState, Precision pPrecision) throws IllegalArgumentException {
        this.numAdd.insertValue(1L);
        super.add(pState, pPrecision);
    }

    @Override
    public void addAll(Iterable<Pair<AbstractState, Precision>> pToAdd) {
        this.numAdd.insertValue(Iterables.size(pToAdd));
        super.addAll(pToAdd);
    }

    @Override
    public void reAddToWaitlist(AbstractState pState) {
        this.numReAdd.inc();
        super.reAddToWaitlist(pState);
    }

    @Override
    public void updatePrecision(AbstractState pState, Precision pNewPrecision) {
        this.numUpdatePrecision.inc();
        super.updatePrecision(pState, pNewPrecision);
    }

    @Override
    public void remove(AbstractState pState) {
        this.numRemove.insertValue(1L);
        super.remove(pState);
    }

    @Override
    public void removeAll(Iterable<? extends AbstractState> pToRemove) {
        this.numRemove.insertValue(Iterables.size(pToRemove));
        super.removeAll(pToRemove);
    }

    @Override
    public void removeOnlyFromWaitlist(AbstractState pState) {
        this.numRemoveOnlyFromWaitlist.inc();
        super.removeOnlyFromWaitlist(pState);
    }

    @Override
    public AbstractState popFromWaitlist() {
        this.numPopFromWaitlist.inc();
        return super.popFromWaitlist();
    }

    @Override
    public ImmutableMap<String, AbstractStatValue> getStatistics() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.getStatistics());
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.sizeOfGetReached);
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.numPopFromWaitlist);
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.numRemoveOnlyFromWaitlist);
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.numContains);
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.numAdd);
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.numReAdd);
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.numRemove);
        StatisticsReachedSet.put((ImmutableMap.Builder<String, AbstractStatValue>)builder, this.numUpdatePrecision);
        return builder.buildOrThrow();
    }

    private static void put(ImmutableMap.Builder<String, AbstractStatValue> builder, AbstractStatValue s) {
        builder.put((Object)s.getTitle(), (Object)s);
    }

    private static class StatHist2
    extends StatHist {
        public StatHist2(String pTitle) {
            super(pTitle);
        }

        @Override
        public String toString() {
            return String.format("%.2f (count=%d, dev=%.2f, min=%s, max=%s)", this.getAvg(), this.getUpdateCount(), this.getStdDeviation(), this.getMin(), this.getMax());
        }
    }
}

