/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;

public class UnmodifiableReachedSetView
implements UnmodifiableReachedSet {
    private final UnmodifiableReachedSet underlying;
    private final Function<? super AbstractState, AbstractState> mapStateFunction;
    private final Function<? super Precision, Precision> mapPrecisionFunction;

    public UnmodifiableReachedSetView(UnmodifiableReachedSet pUnderlyingSet, Function<? super AbstractState, AbstractState> pMapStateFunction, Function<? super Precision, Precision> pMapPrecisionFunction) {
        Preconditions.checkNotNull((Object)pUnderlyingSet);
        Preconditions.checkNotNull(pMapStateFunction);
        Preconditions.checkNotNull(pMapPrecisionFunction);
        this.underlying = pUnderlyingSet;
        this.mapStateFunction = pMapStateFunction;
        this.mapPrecisionFunction = pMapPrecisionFunction;
    }

    @Override
    public @Nullable AbstractState getFirstState() {
        return (AbstractState)Preconditions.checkNotNull((Object)((AbstractState)this.mapStateFunction.apply((Object)this.underlying.getFirstState())));
    }

    @Override
    public AbstractState getLastState() {
        return (AbstractState)this.mapStateFunction.apply((Object)this.underlying.getLastState());
    }

    @Override
    public Precision getPrecision(AbstractState pState) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unwrapping prevents reverse mapping");
    }

    @Override
    public Collection<AbstractState> asCollection() {
        return Collections2.transform(this.underlying.asCollection(), this.mapStateFunction);
    }

    @Override
    public Collection<AbstractState> getReached(AbstractState pState) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Unwrapping prevents knowing the partition");
    }

    @Override
    public Collection<AbstractState> getReached(CFANode pLocation) {
        return Collections2.transform(this.underlying.getReached(pLocation), this.mapStateFunction);
    }

    @Override
    public Collection<Precision> getPrecisions() {
        return Collections2.transform(this.underlying.getPrecisions(), this.mapPrecisionFunction);
    }

    @Override
    public Collection<AbstractState> getWaitlist() {
        return Collections2.transform(this.underlying.getWaitlist(), this.mapStateFunction);
    }

    @Override
    public boolean hasWaitingState() {
        return this.underlying.hasWaitingState();
    }

    @Override
    public Iterator<AbstractState> iterator() {
        return Iterators.transform(this.underlying.iterator(), this.mapStateFunction);
    }

    @Override
    public Stream<AbstractState> stream() {
        return this.underlying.stream().map(this.mapStateFunction);
    }

    @Override
    public void forEach(BiConsumer<? super AbstractState, ? super Precision> pAction) {
        Preconditions.checkNotNull(pAction);
        this.underlying.forEach((? super AbstractState state, ? super Precision precision) -> pAction.accept((AbstractState)this.mapStateFunction.apply(state), (Precision)this.mapPrecisionFunction.apply(precision)));
    }

    @Override
    public boolean contains(AbstractState pState) {
        throw new UnsupportedOperationException("Unwrapping may prevent to check contains");
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean wasTargetReached() {
        return this.underlying.wasTargetReached();
    }

    @Override
    public Collection<Targetable.TargetInformation> getTargetInformation() {
        return this.underlying.getTargetInformation();
    }
}

