/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.reachedset;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;

public class UnmodifiableSubgraphReachedSetView
implements UnmodifiableReachedSet {
    private final ARGPath path;
    protected final Function<AbstractState, Precision> precisionGetter;
    private ImmutableSet<AbstractState> subgraph;

    public UnmodifiableSubgraphReachedSetView(ARGPath pPath, Function<AbstractState, Precision> pPrecisionGetter) {
        this.path = (ARGPath)((Object)Preconditions.checkNotNull((Object)((Object)pPath)));
        this.precisionGetter = (Function)Preconditions.checkNotNull(pPrecisionGetter);
    }

    @Override
    public Collection<AbstractState> asCollection() {
        if (this.subgraph == null) {
            this.subgraph = ImmutableSet.copyOf(this.path.getFirstState().getSubgraph());
            assert (this.subgraph.containsAll(this.path.asStatesList()));
        }
        return this.subgraph;
    }

    @Override
    public Iterator<AbstractState> iterator() {
        return this.asCollection().iterator();
    }

    @Override
    public Stream<AbstractState> stream() {
        return this.asCollection().stream();
    }

    @Override
    public Collection<Precision> getPrecisions() {
        return Collections2.transform(this.asCollection(), this.precisionGetter);
    }

    @Override
    public Collection<AbstractState> getReached(AbstractState state) {
        throw new UnsupportedOperationException("should not be needed");
    }

    @Override
    public Collection<AbstractState> getReached(CFANode location) {
        throw new UnsupportedOperationException("should not be needed");
    }

    @Override
    public AbstractState getFirstState() {
        return this.path.getFirstState();
    }

    @Override
    public AbstractState getLastState() {
        return this.path.getLastState();
    }

    @Override
    public boolean hasWaitingState() {
        return false;
    }

    @Override
    public Collection<AbstractState> getWaitlist() {
        return ImmutableSet.of();
    }

    @Override
    public Precision getPrecision(AbstractState state) {
        return (Precision)Preconditions.checkNotNull((Object)((Precision)this.precisionGetter.apply((Object)((AbstractState)Preconditions.checkNotNull((Object)state)))));
    }

    @Override
    public void forEach(BiConsumer<? super AbstractState, ? super Precision> pAction) {
        this.asCollection().forEach((? super T state) -> pAction.accept((AbstractState)state, (Precision)this.precisionGetter.apply(state)));
    }

    @Override
    public boolean contains(AbstractState state) {
        return this.asCollection().contains(Preconditions.checkNotNull((Object)state));
    }

    @Override
    public boolean isEmpty() {
        return this.asCollection().isEmpty();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("should not be needed");
    }
}

