/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.specification;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.cpachecker.cfa.CFA;

public interface Property {
    public boolean isCoverage();

    public boolean isVerification();

    public String toString();

    public String toFullString(String var1);

    default public String toFullString(CFA cfa) {
        return this.toFullString(cfa.getMainFunction().getFunctionDefinition().getOrigName());
    }

    public static class CoverFunctionCallProperty
    implements Property {
        private static final Pattern COVERAGE_FUNCTION_PATTERN = Pattern.compile("COVER\\( init\\(([_a-zA-Z][_a-zA-Z0-9]*)\\(\\)\\), FQL\\(COVER EDGES\\(@CALL\\((.+)\\)\\)\\) \\)");
        private final String funName;

        CoverFunctionCallProperty(String pFunctionName) {
            this.funName = (String)Preconditions.checkNotNull((Object)pFunctionName);
        }

        @Override
        public boolean isCoverage() {
            return true;
        }

        @Override
        public boolean isVerification() {
            return false;
        }

        public String getCoverFunction() {
            return this.funName;
        }

        @Override
        public String toString() {
            return "COVER EDGES(@CALL(" + this.funName + "))";
        }

        @Override
        public String toFullString(String pEntryPoint) {
            return String.format("COVER( init(%s()), FQL(%s) )", pEntryPoint, this.toString());
        }

        public boolean equals(Object pObj) {
            if (!(pObj instanceof CoverFunctionCallProperty)) {
                return false;
            }
            CoverFunctionCallProperty other = (CoverFunctionCallProperty)pObj;
            return this.funName.equals(other.funName);
        }

        public int hashCode() {
            return this.funName.hashCode();
        }

        static Property getProperty(String pRawProperty) {
            Matcher matcher = COVERAGE_FUNCTION_PATTERN.matcher(pRawProperty);
            if (matcher.matches() && matcher.groupCount() == 2) {
                return new CoverFunctionCallProperty(matcher.group(2).trim());
            }
            return null;
        }
    }

    public static enum CommonCoverageProperty implements Property
    {
        COVERAGE_BRANCH("COVER EDGES(@DECISIONEDGE)"),
        COVERAGE_CONDITION("COVER EDGES(@CONDITIONEDGE)"),
        COVERAGE_STATEMENT("COVER EDGES(@BASICBLOCKENTRY)"),
        COVERAGE_ERROR("COVER EDGES(@CALL(__VERIFIER_error))");

        private final String representation;

        private CommonCoverageProperty(String pRepresentation) {
            this.representation = pRepresentation;
        }

        @Override
        public boolean isCoverage() {
            return true;
        }

        @Override
        public boolean isVerification() {
            return false;
        }

        @Override
        public String toString() {
            return this.representation;
        }

        @Override
        public String toFullString(String pEntryPoint) {
            return String.format("COVER( init(%s()), FQL(%s) )", pEntryPoint, this.representation);
        }
    }

    public static enum CommonVerificationProperty implements Property
    {
        REACHABILITY_LABEL("G ! label(ERROR)"),
        REACHABILITY("G ! call(__VERIFIER_error())"),
        REACHABILITY_ERROR("G ! call(reach_error())"),
        VALID_FREE("G valid-free"),
        VALID_DEREF("G valid-deref"),
        VALID_MEMTRACK("G valid-memtrack"),
        VALID_MEMCLEANUP("G valid-memcleanup"),
        OVERFLOW("G ! overflow"),
        DATA_RACE("G ! data-race"),
        DEADLOCK("G ! deadlock"),
        TERMINATION("F end"),
        ASSERT("G assert");

        private final String representation;

        private CommonVerificationProperty(String pRepresentation) {
            this.representation = pRepresentation;
        }

        @Override
        public boolean isCoverage() {
            return false;
        }

        @Override
        public boolean isVerification() {
            return true;
        }

        @Override
        public String toString() {
            return this.representation;
        }

        @Override
        public String toFullString(String pEntryPoint) {
            return String.format("CHECK( init(%s()), LTL(%s) )", pEntryPoint, this.representation);
        }
    }

    public static class OtherLtlProperty
    implements Property {
        private final String representation;

        OtherLtlProperty(String pRepresentation) {
            this.representation = (String)Preconditions.checkNotNull((Object)pRepresentation);
        }

        @Override
        public boolean isCoverage() {
            return false;
        }

        @Override
        public boolean isVerification() {
            return true;
        }

        @Override
        public String toString() {
            return this.representation;
        }

        @Override
        public String toFullString(String pEntryPoint) {
            return String.format("CHECK( init(%s()), LTL(%s) )", pEntryPoint, this.representation);
        }

        public boolean equals(Object pObj) {
            if (!(pObj instanceof OtherLtlProperty)) {
                return false;
            }
            OtherLtlProperty other = (OtherLtlProperty)pObj;
            return this.representation.equals(other.representation);
        }

        public int hashCode() {
            return this.representation.hashCode();
        }
    }
}

