/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.specification;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.MoreFiles;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.specification.Property;

public class PropertyFileParser {
    private final CharSource propertyFile;
    private @Nullable String entryFunction;
    private @Nullable ImmutableSet<Property> properties;
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("CHECK\\( init\\(([_a-zA-Z][_a-zA-Z0-9]*|.*)\\(\\)\\), LTL\\((.+)\\) \\)");
    private static final Pattern COVERAGE_PATTERN = Pattern.compile("COVER\\( init\\(([_a-zA-Z][_a-zA-Z0-9]*|.*)\\(\\)\\), FQL\\((.+)\\) \\)");
    private static final ImmutableMap<String, ? extends Property> AVAILABLE_VERIFICATION_PROPERTIES = Maps.uniqueIndex(EnumSet.allOf(Property.CommonVerificationProperty.class), Property::toString);
    private static final ImmutableMap<String, ? extends Property> AVAILABLE_COVERAGE_PROPERTIES = Maps.uniqueIndex(EnumSet.allOf(Property.CommonCoverageProperty.class), Property::toString);

    public PropertyFileParser(CharSource pPropertyFile) {
        this.propertyFile = (CharSource)Preconditions.checkNotNull((Object)pPropertyFile);
    }

    public PropertyFileParser(Path pPropertyFile) {
        this.propertyFile = MoreFiles.asCharSource((Path)pPropertyFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
    }

    public void parse() throws InvalidPropertyFileException, IOException {
        Preconditions.checkState((this.properties == null ? 1 : 0) != 0, (Object)"single-use only");
        ImmutableSet.Builder propertiesBuilder = ImmutableSet.builder();
        String rawProperty = null;
        try (BufferedReader br = this.propertyFile.openBufferedStream();){
            while ((rawProperty = br.readLine()) != null) {
                if (rawProperty.isEmpty()) continue;
                propertiesBuilder.add((Object)this.parsePropertyLine(rawProperty));
            }
        }
        this.properties = propertiesBuilder.build();
        if (this.properties.isEmpty()) {
            throw new InvalidPropertyFileException("No property in file.");
        }
    }

    private Property parsePropertyLine(String rawProperty) throws InvalidPropertyFileException {
        Matcher matcher = PROPERTY_PATTERN.matcher(rawProperty);
        if (rawProperty == null) {
            throw new InvalidPropertyFileException("The property is not well-formed!");
        }
        ImmutableMap<String, ? extends Property> propStringToProperty = AVAILABLE_VERIFICATION_PROPERTIES;
        if (!matcher.matches() || matcher.groupCount() != 2) {
            matcher = COVERAGE_PATTERN.matcher(rawProperty);
            if (!matcher.matches() || matcher.groupCount() != 2) {
                throw new InvalidPropertyFileException(String.format("The property '%s' is not well-formed!", rawProperty));
            }
            propStringToProperty = AVAILABLE_COVERAGE_PROPERTIES;
        }
        if (this.entryFunction == null) {
            this.entryFunction = matcher.group(1);
        } else if (!this.entryFunction.equals(matcher.group(1))) {
            throw new InvalidPropertyFileException(String.format("Specifying two different entry functions %s and %s is not supported.", this.entryFunction, matcher.group(1)));
        }
        String rawLtlProperty = matcher.group(2);
        Property property = (Property)propStringToProperty.get(rawLtlProperty);
        if (property == null && propStringToProperty == AVAILABLE_VERIFICATION_PROPERTIES) {
            property = new Property.OtherLtlProperty(rawLtlProperty);
        }
        if (property == null && propStringToProperty == AVAILABLE_COVERAGE_PROPERTIES) {
            property = Property.CoverFunctionCallProperty.getProperty(rawProperty);
        }
        return property;
    }

    public String getEntryFunction() {
        Preconditions.checkState((this.entryFunction != null ? 1 : 0) != 0);
        return this.entryFunction;
    }

    public ImmutableSet<Property> getProperties() {
        Preconditions.checkState((this.properties != null ? 1 : 0) != 0);
        return this.properties;
    }

    public static class InvalidPropertyFileException
    extends Exception {
        private static final long serialVersionUID = -5880923544560903123L;

        public InvalidPropertyFileException(String msg) {
            super(msg);
        }

        public InvalidPropertyFileException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

