/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.specification;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.truth.Expect;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.core.specification.PropertyFileParser;

public class PropertyFileParserTest {
    private static final ImmutableMap<String, Property> TEST_PROPERTIES = ImmutableMap.builder().put((Object)"CHECK( init(Main.main()), LTL(G assert) )", (Object)Property.CommonVerificationProperty.ASSERT).put((Object)"CHECK( init(Main.main()), LTL(G !deadlock) )", (Object)new Property.OtherLtlProperty("G !deadlock")).put((Object)"CHECK( init(main()), LTL(F end) )", (Object)Property.CommonVerificationProperty.TERMINATION).put((Object)"CHECK( init(main()), LTL(G ! call(reach_error())) )", (Object)Property.CommonVerificationProperty.REACHABILITY_ERROR).put((Object)"CHECK( init(main()), LTL(G ! data-race) )", (Object)Property.CommonVerificationProperty.DATA_RACE).put((Object)"CHECK( init(main()), LTL(G def-behavior) )", (Object)new Property.OtherLtlProperty("G def-behavior")).put((Object)"CHECK( init(main()), LTL(G ! overflow) )", (Object)Property.CommonVerificationProperty.OVERFLOW).put((Object)"CHECK( init(main()), LTL(G valid-deref) )", (Object)Property.CommonVerificationProperty.VALID_DEREF).put((Object)"CHECK( init(main()), LTL(G valid-free) )", (Object)Property.CommonVerificationProperty.VALID_FREE).put((Object)"CHECK( init(main()), LTL(G valid-memcleanup) )", (Object)Property.CommonVerificationProperty.VALID_MEMCLEANUP).put((Object)"CHECK( init(main()), LTL(G valid-memtrack) )", (Object)Property.CommonVerificationProperty.VALID_MEMTRACK).put((Object)"COVER( init(main()), FQL(COVER EDGES(@BASICBLOCKENTRY)) )", (Object)Property.CommonCoverageProperty.COVERAGE_STATEMENT).put((Object)"COVER( init(main()), FQL(COVER EDGES(@CALL(reach_error))) )", (Object)new Property.CoverFunctionCallProperty("reach_error")).put((Object)"COVER( init(main()), FQL(COVER EDGES(@CONDITIONEDGE)) )", (Object)Property.CommonCoverageProperty.COVERAGE_CONDITION).put((Object)"COVER( init(main()), FQL(COVER EDGES(@DECISIONEDGE)) )", (Object)Property.CommonCoverageProperty.COVERAGE_BRANCH).put((Object)"CHECK( init(main()), LTL(G ! label(ERROR)) )", (Object)Property.CommonVerificationProperty.REACHABILITY_LABEL).put((Object)"CHECK( init(main()), LTL(G ! call(__VERIFIER_error())) )", (Object)Property.CommonVerificationProperty.REACHABILITY).put((Object)"COVER( init(main()), FQL(COVER EDGES(@CALL(__VERIFIER_error))) )", (Object)Property.CommonCoverageProperty.COVERAGE_ERROR).put((Object)"CHECK( init(main()), LTL(G ! deadlock) )", (Object)Property.CommonVerificationProperty.DEADLOCK).put((Object)"COVER( init(main()), FQL(COVER EDGES(@CALL(some_arbitrary_function))) )", (Object)new Property.CoverFunctionCallProperty("some_arbitrary_function")).put((Object)"CHECK( init(main()), LTL( F G (x = 1) ) )", (Object)new Property.OtherLtlProperty(" F G (x = 1) ")).buildOrThrow();
    private static final String VALID_ASSERT_PROPERTY = "CHECK( init(main()), LTL(G assert) )";
    @Rule
    public final Expect expect = Expect.create();

    @Test
    public void checkTestCompletness() {
        this.expect.withMessage("Please add tests when adding new properties").that((Iterable)TEST_PROPERTIES.values()).containsAtLeastElementsIn((Object[])Property.CommonVerificationProperty.values());
        this.expect.withMessage("Please add tests when adding new properties").that((Iterable)TEST_PROPERTIES.values()).containsAtLeastElementsIn((Object[])Property.CommonCoverageProperty.values());
    }

    @Test
    public void testSingleProperty() throws PropertyFileParser.InvalidPropertyFileException, IOException {
        for (Map.Entry entry : TEST_PROPERTIES.entrySet()) {
            PropertyFileParser parser = new PropertyFileParser(CharSource.wrap((CharSequence)((CharSequence)entry.getKey())));
            parser.parse();
            this.expect.that(parser.getProperties()).containsExactly(new Object[]{entry.getValue()});
        }
    }

    @Test
    public void testRedundant() throws PropertyFileParser.InvalidPropertyFileException, IOException {
        String fileContent = "CHECK( init(main()), LTL(G assert) )\nCHECK( init(main()), LTL(G assert) )";
        PropertyFileParser parser = new PropertyFileParser(CharSource.wrap((CharSequence)fileContent));
        parser.parse();
        Truth.assertThat(parser.getProperties()).containsExactly(new Object[]{Property.CommonVerificationProperty.ASSERT});
    }

    @Test
    public void testMemsafety() throws PropertyFileParser.InvalidPropertyFileException, IOException {
        ImmutableSet properties = ImmutableSet.of((Object)Property.CommonVerificationProperty.VALID_DEREF, (Object)Property.CommonVerificationProperty.VALID_FREE, (Object)Property.CommonVerificationProperty.VALID_MEMTRACK);
        Set propertyStrings = Maps.filterValues(TEST_PROPERTIES, arg_0 -> PropertyFileParserTest.lambda$testMemsafety$0((Set)properties, arg_0)).keySet();
        String fileContent = Joiner.on((char)'\n').join(propertyStrings);
        PropertyFileParser parser = new PropertyFileParser(CharSource.wrap((CharSequence)fileContent));
        parser.parse();
        Truth.assertThat(parser.getProperties()).containsExactlyElementsIn((Iterable)properties).inOrder();
    }

    @Test
    public void testEntryFunction() throws PropertyFileParser.InvalidPropertyFileException, IOException {
        for (String entryFunction : ImmutableList.of((Object)"main", (Object)"foo", (Object)"package.Class.method")) {
            String fileContent = String.format("CHECK( init(%s()), LTL(G assert) )", entryFunction);
            PropertyFileParser parser = new PropertyFileParser(CharSource.wrap((CharSequence)fileContent));
            parser.parse();
            this.expect.that(parser.getEntryFunction()).isEqualTo((Object)entryFunction.trim());
        }
    }

    @Test
    public void testInvalid() {
        ImmutableList invalidFiles = ImmutableList.of((Object)"", (Object)"  \n  ", (Object)"# CHECK( init(main()), LTL(G assert) )", (Object)" CHECK( init(main()), LTL(G assert) )", (Object)"CHECK( init(main()), LTL(G assert) )\n#", (Object)"CHECK( init(main), LTL(G assert) )", (Object)"CHECK( LTL(G assert) )", (Object)"CHECK( init(main()), LTL(G assert) )\nCHECK( init(foo()), LTL(G assert) )");
        for (String fileContent : invalidFiles) {
            PropertyFileParser parser = new PropertyFileParser(CharSource.wrap((CharSequence)fileContent));
            Assert.assertThrows(PropertyFileParser.InvalidPropertyFileException.class, () -> parser.parse());
        }
    }

    private static /* synthetic */ boolean lambda$testMemsafety$0(Set properties, Property v) {
        return properties.contains(v);
    }
}

