/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.specification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.CFAWithACSLAnnotations;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.DummyScope;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.core.specification.PropertyFileParser;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonACSLParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonGraphmlParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.ltl.Ltl2BuechiConverter;
import org.sosy_lab.cpachecker.util.ltl.LtlParseException;
import org.sosy_lab.cpachecker.util.ltl.LtlParser;
import org.sosy_lab.cpachecker.util.ltl.formulas.LabelledFormula;

public final class Specification {
    private static final ImmutableMap<Property, String> AUTOMATA_FOR_PROPERTIES = ImmutableMap.builder().put((Object)Property.CommonVerificationProperty.REACHABILITY_LABEL, (Object)"sv-comp-errorlabel").put((Object)Property.CommonVerificationProperty.REACHABILITY, (Object)"sv-comp-reachability").put((Object)Property.CommonVerificationProperty.REACHABILITY_ERROR, (Object)"sv-comp-reachability").put((Object)Property.CommonVerificationProperty.VALID_FREE, (Object)"sv-comp-memorysafety").put((Object)Property.CommonVerificationProperty.VALID_DEREF, (Object)"sv-comp-memorysafety").put((Object)Property.CommonVerificationProperty.VALID_MEMTRACK, (Object)"sv-comp-memorysafety").put((Object)Property.CommonVerificationProperty.VALID_MEMCLEANUP, (Object)"sv-comp-memorycleanup").put((Object)Property.CommonVerificationProperty.OVERFLOW, (Object)"sv-comp-overflow").put((Object)Property.CommonVerificationProperty.DATA_RACE, (Object)"sv-comp-datarace").put((Object)Property.CommonVerificationProperty.DEADLOCK, (Object)"deadlock").put((Object)Property.CommonVerificationProperty.ASSERT, (Object)"JavaAssertion").buildOrThrow();
    private final ImmutableSet<Path> specificationFiles;
    private final ImmutableSet<Property> properties;
    private final ImmutableListMultimap<Path, Automaton> pathToSpecificationAutomata;

    private static Path getAutomatonForProperty(Property property) {
        String name = (String)AUTOMATA_FOR_PROPERTIES.get((Object)property);
        if (name == null) {
            return null;
        }
        return Classes.getCodeLocation(Specification.class).resolveSibling("config").resolve("specification").resolve(name + ".spc");
    }

    public static Specification alwaysSatisfied() {
        return new Specification((Set<Path>)ImmutableSet.of(), (Set<Property>)ImmutableSet.of(), (ImmutableListMultimap<Path, Automaton>)ImmutableListMultimap.of());
    }

    public static Specification fromAutomata(List<Automaton> automata) {
        ImmutableListMultimap pathToSpecificationAutomata = ImmutableListMultimap.builder().putAll((Object)Path.of("", new String[0]), automata).build();
        return new Specification((Set<Path>)ImmutableSet.of(), (Set<Property>)ImmutableSet.of(), (ImmutableListMultimap<Path, Automaton>)pathToSpecificationAutomata);
    }

    public static Specification fromFiles(Iterable<Path> pSpecFiles, CFA cfa, Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, InterruptedException {
        Scope scope;
        Preconditions.checkNotNull((Object)cfa);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)pShutdownNotifier);
        ImmutableSet specFiles = ImmutableSet.copyOf(pSpecFiles);
        if (specFiles.isEmpty()) {
            return Specification.alwaysSatisfied();
        }
        ImmutableSet.Builder properties = ImmutableSet.builder();
        ImmutableListMultimap.Builder specificationAutomata = ImmutableListMultimap.builder();
        switch (cfa.getLanguage()) {
            case C: {
                scope = new CProgramScope(cfa, logger);
                break;
            }
            default: {
                scope = DummyScope.getInstance();
            }
        }
        HashSet<Path> handledAutomataForProperties = new HashSet<Path>();
        for (Path specFile : specFiles) {
            if (MoreFiles.getFileExtension((Path)specFile).equals("prp")) {
                PropertyFileParser parser = new PropertyFileParser(specFile);
                try {
                    parser.parse();
                }
                catch (IOException | PropertyFileParser.InvalidPropertyFileException e) {
                    throw new InvalidConfigurationException(String.format("Cannot parse property file %s: %s", specFile, e.getMessage()), (Throwable)e);
                }
                String configuredEntryFunction = config.getProperty("analysis.entryFunction");
                if (!parser.getEntryFunction().equals(configuredEntryFunction)) {
                    throw new InvalidConfigurationException(String.format("Entry function %s specified in %s is not consistent with configured entry function %s. Please set 'analysis.entryFunction=%s' or pass property file on command line with '-spec %s'.", parser.getEntryFunction(), specFile, configuredEntryFunction, parser.getEntryFunction(), specFile));
                }
                for (Property prop : parser.getProperties()) {
                    properties.add((Object)prop);
                    if (prop instanceof Property.OtherLtlProperty) {
                        Automaton automaton = Specification.parseLtlFormula(prop.toString(), cfa, config, logger, pShutdownNotifier, scope);
                        specificationAutomata.put((Object)specFile, (Object)automaton);
                        continue;
                    }
                    Path automatonFile = Specification.getAutomatonForProperty(prop);
                    if (automatonFile == null || !handledAutomataForProperties.add(automatonFile)) continue;
                    List<Automaton> automata = Specification.parseSpecificationFile(automatonFile, cfa, config, logger, pShutdownNotifier, scope);
                    specificationAutomata.putAll((Object)specFile, automata);
                }
                continue;
            }
            List<Automaton> automata = Specification.parseSpecificationFile(specFile, cfa, config, logger, pShutdownNotifier, scope);
            specificationAutomata.putAll((Object)specFile, automata);
        }
        return new Specification((Set<Path>)specFiles, (Set<Property>)properties.build(), (ImmutableListMultimap<Path, Automaton>)specificationAutomata.build());
    }

    private static List<Automaton> parseSpecificationFile(Path specFile, CFA cfa, Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, Scope scope) throws InvalidConfigurationException, InterruptedException {
        Object automata;
        try {
            if (Files.size(specFile) == 0L) {
                throw new InvalidConfigurationException("The specification file is empty: " + specFile);
            }
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Could not load automaton from file " + e.getMessage(), (Throwable)e);
        }
        if (AutomatonGraphmlParser.isGraphmlAutomatonFromConfiguration(specFile)) {
            AutomatonGraphmlParser graphmlParser = new AutomatonGraphmlParser(config, logger, pShutdownNotifier, cfa, scope);
            automata = ImmutableList.of((Object)graphmlParser.parseAutomatonFile(specFile));
        } else if (AutomatonACSLParser.isACSLAnnotatedFile(specFile)) {
            CFAWithACSLAnnotations annotatedCFA;
            logger.logf(Level.INFO, "Parsing CFA with ACSL annotations from file \"%s\"", new Object[]{specFile});
            CFACreator cfaCreator = new CFACreator(config, logger, pShutdownNotifier);
            try {
                annotatedCFA = (CFAWithACSLAnnotations)cfaCreator.parseFileAndCreateCFA((List<String>)ImmutableList.of((Object)specFile.toString()));
            }
            catch (IOException | ParserException e) {
                throw new InvalidConfigurationException("Could not load automaton from file: " + e.getMessage(), (Throwable)e);
            }
            AutomatonACSLParser acslParser = new AutomatonACSLParser(annotatedCFA, logger);
            assert (acslParser.areIsomorphicCFAs(cfa)) : "CFAs of task program and annotated program differ, annotated program is probably unrelated to this task";
            automata = ImmutableList.of((Object)acslParser.parseAsAutomaton());
        } else {
            automata = AutomatonParser.parseAutomatonFile(specFile, config, logger, cfa.getMachineModel(), scope, cfa.getLanguage(), pShutdownNotifier);
            if (automata.isEmpty()) {
                throw new InvalidConfigurationException("Specification file contains no automata: " + specFile);
            }
        }
        Iterator iterator = automata.iterator();
        while (iterator.hasNext()) {
            Automaton automaton = (Automaton)iterator.next();
            logger.logf(Level.FINER, "Loaded Automaton %s with %d states from %s.", new Object[]{automaton.getName(), automaton.getNumberOfStates(), specFile});
        }
        return automata;
    }

    private static Automaton parseLtlFormula(String ltl, CFA cfa, Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, Scope scope) throws InvalidConfigurationException, InterruptedException {
        try {
            LabelledFormula formula = LtlParser.parseProperty(ltl);
            return Ltl2BuechiConverter.convertFormula(formula.not(), cfa.getMainFunction().getFunctionName(), config, logger, cfa.getMachineModel(), scope, pShutdownNotifier);
        }
        catch (LtlParseException e) {
            throw new InvalidConfigurationException(String.format("Could not parse property '%s' (%s)", ltl, e.getMessage()), (Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(String.format("An exception occured during the execution of the external ltl converter tool:%n%s", e.getMessage()), (Throwable)e);
        }
    }

    public Specification withAdditionalSpecificationFile(Set<Path> pSpecificationFiles, CFA cfa, Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, InterruptedException {
        Preconditions.checkNotNull((Object)cfa);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)pShutdownNotifier);
        ImmutableSet newSpecFiles = Sets.difference(pSpecificationFiles, (Set)this.pathToSpecificationAutomata.keySet()).immutableCopy();
        if (newSpecFiles.isEmpty()) {
            return this;
        }
        Specification newSpec = Specification.fromFiles((Iterable<Path>)newSpecFiles, cfa, config, logger, pShutdownNotifier);
        return new Specification((Set<Path>)Sets.union(this.specificationFiles, (Set)newSpecFiles), (Set<Property>)Sets.union(this.properties, newSpec.properties), (ImmutableListMultimap<Path, Automaton>)ImmutableListMultimap.builder().putAll(this.pathToSpecificationAutomata).putAll(newSpec.pathToSpecificationAutomata).build());
    }

    public Specification withAdditionalProperties(Set<Property> pProperties) {
        ImmutableSet newProperties = Sets.union(this.properties, pProperties).immutableCopy();
        if (newProperties.size() == this.properties.size()) {
            return this;
        }
        return new Specification((Set<Path>)this.specificationFiles, (Set<Property>)newProperties, this.pathToSpecificationAutomata);
    }

    @VisibleForTesting
    Specification(Set<Path> pSpecificationFiles, Set<Property> pProperties, ImmutableListMultimap<Path, Automaton> pSpecification) {
        this.specificationFiles = ImmutableSet.copyOf(pSpecificationFiles);
        this.properties = ImmutableSet.copyOf(pProperties);
        this.pathToSpecificationAutomata = (ImmutableListMultimap)Preconditions.checkNotNull(pSpecification);
    }

    public ImmutableList<Automaton> getSpecificationAutomata() {
        return this.pathToSpecificationAutomata.values().asList();
    }

    public int hashCode() {
        return this.pathToSpecificationAutomata.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Specification)) {
            return false;
        }
        Specification other = (Specification)obj;
        return this.pathToSpecificationAutomata.equals(other.pathToSpecificationAutomata);
    }

    public String toString() {
        return "Specification" + this.pathToSpecificationAutomata.values().stream().map(Automaton::getName).collect(Collectors.joining(", ", "[", "]"));
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public ImmutableSet<Path> getFiles() {
        return this.specificationFiles;
    }

    public ImmutableListMultimap<Path, Automaton> getPathToSpecificationAutomata() {
        return this.pathToSpecificationAutomata;
    }
}

