/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import com.google.common.collect.ImmutableSet;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;

@Options(prefix="analysis.traversal")
public class BlockConfiguration {
    @Option(secure=true, description="resource limit for the block")
    private int blockResourceLimit = 1000;
    @Option(secure=true, description="resource limit for the entry block")
    private int entryResourceLimit = 100000;
    @Option(secure=true, description="save resources for the block if it is empty")
    private boolean blockSaveResources = true;
    @Option(secure=true, description="Patterns for detecting block starts (ldv_ like functions)")
    private ImmutableSet<String> blockFunctionPatterns = ImmutableSet.of((Object)"ldv_%_instance_%");

    public BlockConfiguration(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    int getBlockResourceLimit() {
        return this.blockResourceLimit;
    }

    int getEntryResourceLimit() {
        return this.entryResourceLimit;
    }

    boolean shouldSaveBlockResources() {
        return this.blockSaveResources;
    }

    ImmutableSet<String> getBlockFunctionPatterns() {
        return this.blockFunctionPatterns;
    }
}

