/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.waitlist.BlockConfiguration;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class BlockWaitlist
implements Waitlist {
    private final Waitlist.WaitlistFactory wrappedWaitlist;
    private int size = 0;
    private final NavigableMap<BKey, Block> activeBlocksMap = new TreeMap<BKey, Block>();
    private final Map<BKey, Block> inactiveBlocksMap = new TreeMap<BKey, Block>();
    private final Map<BKey, Block> savedBlocksMap = new TreeMap<BKey, Block>();
    private BlockConfiguration config;
    private LogManager logger;
    private Pattern[] ldvPattern;
    boolean unknownIfHasInactive = true;

    private static CallstackState retreiveCallstack(AbstractState pState) {
        return AbstractStates.extractStateByType(pState, CallstackState.class);
    }

    protected BlockWaitlist(Waitlist.WaitlistFactory pSecondaryStrategy, BlockConfiguration pConfig, LogManager pLogger) {
        this.wrappedWaitlist = (Waitlist.WaitlistFactory)Preconditions.checkNotNull((Object)pSecondaryStrategy);
        this.config = pConfig;
        this.logger = pLogger;
        int len = this.config.getBlockFunctionPatterns().size();
        int i = 0;
        this.ldvPattern = new Pattern[len];
        for (String p : this.config.getBlockFunctionPatterns()) {
            this.ldvPattern[i] = Pattern.compile(p.replace("%", ".*"));
            ++i;
        }
    }

    private void addNewBlock(BKey key, AbstractState pState) {
        Block b;
        if (this.activeBlocksMap.containsKey(key)) {
            b = (Block)this.activeBlocksMap.get(key);
        } else {
            if (this.config.shouldSaveBlockResources() && this.savedBlocksMap.containsKey(key)) {
                b = this.savedBlocksMap.remove(key);
            } else {
                b = new Block(key, this.wrappedWaitlist, this.config);
                b.isEntryBlock = key.name.equals("entry_block_main");
            }
            this.activeBlocksMap.put(key, b);
        }
        b.addStateToMain(pState);
    }

    private void makeBlockInactive(BKey key) {
        Block b = (Block)this.activeBlocksMap.get(key);
        this.inactiveBlocksMap.put(key, b);
        b.savedResources = b.countResources;
        this.activeBlocksMap.remove(key);
        this.logger.log(Level.INFO, new Object[]{"Make inactive " + key + ", resources=" + b.countResources});
    }

    private boolean isBlock(String func) {
        for (Pattern p : this.ldvPattern) {
            Matcher matcher = p.matcher(func);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private BKey getBlockKey(AbstractState e) {
        String resFunc = "entry_block_main";
        int resDepth = 1;
        for (CallstackState callStack = BlockWaitlist.retreiveCallstack(e); callStack != null; callStack = callStack.getPreviousState()) {
            String func = callStack.getCurrentFunction();
            if (!this.isBlock(func)) continue;
            resFunc = func;
            resDepth = callStack.getDepth();
            break;
        }
        return new BKey(resFunc, resDepth);
    }

    private @Nullable Block getBlockForState(AbstractState e) {
        BKey key = this.getBlockKey(e);
        assert (key != null);
        Block block = (Block)this.activeBlocksMap.get(key);
        if (block != null) {
            return block;
        }
        block = this.inactiveBlocksMap.get(key);
        return block;
    }

    @Override
    public Iterator<AbstractState> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(AbstractState pState) {
        BKey key = this.getBlockKey(pState);
        ++this.size;
        CallstackState cs = BlockWaitlist.retreiveCallstack(pState);
        this.logger.log(Level.FINE, new Object[]{"Add" + key + "[" + cs.getCurrentFunction() + "], size=" + this.size});
        if (this.inactiveBlocksMap.containsKey(key)) {
            Block block = this.inactiveBlocksMap.get(key);
            block.addStateToMain(pState);
        } else {
            Block b = (Block)this.activeBlocksMap.get(key);
            if (b != null) {
                b.addStateToMain(pState);
                this.logger.log(Level.FINE, new Object[]{"Resources=" + b.countResources});
                this.logger.log(Level.FINE, new Object[]{"Callstack=" + cs});
                if (b.checkResources()) {
                    this.makeBlockInactive(key);
                }
            } else {
                this.addNewBlock(key, pState);
            }
        }
    }

    @Override
    public boolean contains(AbstractState pState) {
        Block block = this.getBlockForState(pState);
        if (block == null) {
            return false;
        }
        return block.mainWaitlist.contains(pState);
    }

    @Override
    public boolean remove(AbstractState pState) {
        Block block = this.getBlockForState(pState);
        if (block == null) {
            return false;
        }
        boolean b = block.removeState(pState);
        if (!b) {
            return false;
        }
        --this.size;
        this.logger.log(Level.FINE, new Object[]{"Remove[" + block.name + "] resources=" + block.countResources + ", size=" + this.size});
        return true;
    }

    @Override
    public AbstractState pop() {
        assert (!this.isEmpty());
        Map.Entry<BKey, Block> e = this.activeBlocksMap.lastEntry();
        while (e != null && e.getValue().isEmpty()) {
            this.activeBlocksMap.pollLastEntry();
            if (this.config.shouldSaveBlockResources() && e.getValue().countResources != 0) {
                this.logger.log(Level.INFO, new Object[]{"Save block=" + e.getKey() + ", resources=" + e.getValue().countResources});
                this.savedBlocksMap.put(e.getKey(), e.getValue());
            }
            e = this.activeBlocksMap.lastEntry();
        }
        if (this.unknownIfHasInactive && this.isEmptyMap()) {
            this.logger.log(Level.FINE, new Object[]{"active blocks=" + this.activeBlocksMap.keySet()});
            throw new RuntimeException("Waitlist of size=" + this.size + " contains only inactive blocks " + this.inactiveBlocksMap.keySet());
        }
        assert (!this.isEmpty());
        Map.Entry<BKey, Block> highestEntry = this.activeBlocksMap.lastEntry();
        AbstractState state = highestEntry.getValue().popState();
        --this.size;
        this.logger.log(Level.FINE, new Object[]{"Pop" + highestEntry.getKey() + " resources=" + highestEntry.getValue().countResources + ", size=" + this.size});
        return state;
    }

    @Override
    public int size() {
        return this.size;
    }

    private boolean isEmptyMap() {
        if (this.activeBlocksMap.isEmpty()) {
            return true;
        }
        Map.Entry<BKey, Block> highestEntry = this.activeBlocksMap.lastEntry();
        if (!highestEntry.getValue().isEmpty()) {
            return false;
        }
        for (BKey key : this.activeBlocksMap.descendingKeySet()) {
            Block b = (Block)this.activeBlocksMap.get(key);
            if (b.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private int countSize() {
        int completeSize = 0;
        for (Block b : this.activeBlocksMap.values()) {
            completeSize += b.size();
        }
        for (Block b : this.inactiveBlocksMap.values()) {
            completeSize += b.size();
        }
        return completeSize;
    }

    @Override
    public boolean isEmpty() {
        assert (this.size == this.countSize()) : "size mismatch, size=" + this.size + ", countSize=" + this.countSize();
        if (this.unknownIfHasInactive) {
            return this.size == 0;
        }
        return this.isEmptyMap();
    }

    @Override
    public void clear() {
        this.activeBlocksMap.clear();
        this.inactiveBlocksMap.clear();
        this.size = 0;
    }

    public static Waitlist.WaitlistFactory factory(Waitlist.WaitlistFactory pSecondaryStrategy, BlockConfiguration config, LogManager logger) {
        return () -> new BlockWaitlist(pSecondaryStrategy, config, logger);
    }

    private static final class BKey
    implements Comparable<BKey> {
        private final String name;
        private final int callStackDepth;

        BKey(String pName, int pDepth) {
            this.name = (String)Preconditions.checkNotNull((Object)pName);
            this.callStackDepth = pDepth;
        }

        @Override
        public int compareTo(BKey k2) {
            return ComparisonChain.start().compare(this.callStackDepth, k2.callStackDepth).compare((Comparable)((Object)this.name), (Comparable)((Object)k2.name)).result();
        }

        public String toString() {
            return "[" + this.name + ", " + this.callStackDepth + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.callStackDepth;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BKey other = (BKey)obj;
            return this.callStackDepth == other.callStackDepth && this.name.equals(other.name);
        }
    }

    private static class Block {
        public static final String ENTRY_BLOCK_NAME = "entry_block_main";
        private String name;
        private int countResources;
        private int savedResources;
        private BlockConfiguration limits;
        private Waitlist mainWaitlist;
        private boolean isEntryBlock;

        Block(BKey key, Waitlist.WaitlistFactory factory, BlockConfiguration pLimits) {
            this.mainWaitlist = factory.createWaitlistInstance();
            this.limits = pLimits;
            this.name = key.name;
        }

        public int getSavedResources() {
            return this.savedResources;
        }

        void addStateToMain(AbstractState e) {
            this.mainWaitlist.add(e);
            this.incResources(e);
        }

        boolean checkResources() {
            if (this.isEntryBlock) {
                return this.countResources > this.limits.getEntryResourceLimit();
            }
            return this.countResources > this.limits.getBlockResourceLimit();
        }

        private void incResources(AbstractState e) {
            ++this.countResources;
        }

        private void decResources(AbstractState e) {
            --this.countResources;
        }

        boolean isEmpty() {
            return this.mainWaitlist.isEmpty();
        }

        boolean removeState(AbstractState e) {
            boolean b = this.mainWaitlist.remove(e);
            if (b) {
                this.decResources(e);
            }
            return b;
        }

        AbstractState popState() {
            if (!this.mainWaitlist.isEmpty()) {
                AbstractState res = this.mainWaitlist.pop();
                return res;
            }
            throw new AssertionError((Object)"invalid pop: current block is empty");
        }

        int size() {
            return this.mainWaitlist.size();
        }
    }
}

