/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.waitlist.AbstractSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class LoopIterationSortedWaitlist
extends AbstractSortedWaitlist<Integer> {
    private final int multiplier;

    private LoopIterationSortedWaitlist(Waitlist.WaitlistFactory pSecondaryStrategy, int pMultiplier) {
        super(pSecondaryStrategy);
        this.multiplier = pMultiplier;
    }

    @Override
    protected Integer getSortKey(AbstractState pState) {
        LoopBoundState loopBoundState = AbstractStates.extractStateByType(pState, LoopBoundState.class);
        return loopBoundState != null ? this.multiplier * loopBoundState.getMaxNumberOfIterationsInLoopstackFrame() : 0;
    }

    public static Waitlist.WaitlistFactory factory(Waitlist.WaitlistFactory pSecondaryStrategy) {
        return () -> new LoopIterationSortedWaitlist(pSecondaryStrategy, 1);
    }

    public static Waitlist.WaitlistFactory reversedFactory(Waitlist.WaitlistFactory pSecondaryStrategy) {
        return () -> new LoopIterationSortedWaitlist(pSecondaryStrategy, -1);
    }
}

