/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;

public class RoundRobinWaitlist
implements Waitlist {
    private final ImmutableList<Waitlist> waitlistStrategies = ImmutableList.of((Object)Waitlist.TraversalMethod.DFS.createWaitlistInstance(), (Object)Waitlist.TraversalMethod.BFS.createWaitlistInstance());
    private int nextStrategy = 0;

    protected RoundRobinWaitlist() {
    }

    @Override
    public Iterator<AbstractState> iterator() {
        return ((Waitlist)this.waitlistStrategies.get(this.nextStrategy)).iterator();
    }

    @Override
    public void add(AbstractState pState) {
        for (Waitlist waitlist : this.waitlistStrategies) {
            waitlist.add(pState);
        }
    }

    @Override
    public void clear() {
        for (Waitlist waitlist : this.waitlistStrategies) {
            waitlist.clear();
        }
        this.nextStrategy = 0;
    }

    @Override
    public boolean contains(AbstractState pState) {
        return ((Waitlist)this.waitlistStrategies.get(this.nextStrategy)).contains(pState);
    }

    @Override
    public boolean isEmpty() {
        return ((Waitlist)this.waitlistStrategies.get(this.nextStrategy)).isEmpty();
    }

    @Override
    public AbstractState pop() {
        AbstractState poppedElem = ((Waitlist)this.waitlistStrategies.get(this.nextStrategy)).pop();
        for (Waitlist waitlist : this.waitlistStrategies) {
            waitlist.remove(poppedElem);
        }
        this.nextStrategy = (this.nextStrategy + 1) % this.waitlistStrategies.size();
        return poppedElem;
    }

    @Override
    public boolean remove(AbstractState pState) {
        boolean removed = false;
        for (Waitlist waitlist : this.waitlistStrategies) {
            removed = waitlist.remove(pState);
        }
        return removed;
    }

    @Override
    public int size() {
        return ((Waitlist)this.waitlistStrategies.get(this.nextStrategy)).size();
    }
}

