/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.waitlist;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.util.OrderStatisticMap;

public class WeightedRandomWaitlist
implements Waitlist {
    private final double exponent;
    private OrderStatisticMap<AbstractState, Waitlist> states;
    private Waitlist.WaitlistFactory waitlistFactory;
    private Comparator<AbstractState> comparator;
    private Random random;

    public WeightedRandomWaitlist(Comparator<AbstractState> pComparator, Waitlist.WaitlistFactory pFactory, WaitlistOptions pConfig) {
        this.exponent = pConfig.exponent;
        this.random = new Random(pConfig.seed);
        this.comparator = pComparator;
        this.states = new OrderStatisticMap.OrderStatisticsMapProxy<AbstractState, Waitlist>(new TreeMap(this.comparator));
        this.waitlistFactory = pFactory;
    }

    @Override
    public void add(AbstractState state) {
        if (!this.states.containsKey(state)) {
            this.states.put(state, this.waitlistFactory.createWaitlistInstance());
        }
        Waitlist w = (Waitlist)this.states.get(state);
        w.add(state);
    }

    @Override
    public void clear() {
        this.states.clear();
    }

    @Override
    public boolean contains(AbstractState state) {
        return this.states.containsKey(state) && ((Waitlist)this.states.get(state)).contains(state);
    }

    @Override
    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    private int getRandomIndex() {
        double r = this.random.nextDouble();
        double x = Math.pow(r, this.exponent);
        int s = this.states.size() - 1;
        return (int)Math.round((double)s * x);
    }

    @Override
    public AbstractState pop() {
        assert (this.size() > 0);
        int idx = this.getRandomIndex();
        Preconditions.checkElementIndex((int)idx, (int)this.states.size());
        Waitlist chosenWaitlist = this.states.getEntryByRank(idx).getValue();
        AbstractState poppedState = chosenWaitlist.pop();
        if (chosenWaitlist.isEmpty()) {
            this.states.removeByRank(idx);
        }
        return poppedState;
    }

    @Override
    public boolean remove(AbstractState state) {
        if (this.states.containsKey(state)) {
            Waitlist containingWaitlist = (Waitlist)this.states.get(state);
            boolean removed = containingWaitlist.remove(state);
            if (containingWaitlist.isEmpty()) {
                this.states.remove(state);
            }
            return removed;
        }
        return false;
    }

    @Override
    public int size() {
        int sum = 0;
        for (Waitlist w : this.states.values()) {
            sum += w.size();
        }
        return sum;
    }

    @Override
    public Iterator<AbstractState> iterator() {
        if (this.states.isEmpty()) {
            return new Iterator<AbstractState>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public AbstractState next() {
                    throw new NoSuchElementException();
                }
            };
        }
        return new Iterator<AbstractState>(){
            private Iterator<AbstractState> currIt;
            private int currRank;
            private int maxRank;
            {
                this.currIt = ((Waitlist)WeightedRandomWaitlist.this.states.firstEntry().getValue()).iterator();
                this.currRank = 0;
                this.maxRank = WeightedRandomWaitlist.this.states.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.currIt.hasNext() || this.currRank < this.maxRank;
            }

            @Override
            public AbstractState next() {
                if (!this.currIt.hasNext()) {
                    ++this.currRank;
                    this.currIt = WeightedRandomWaitlist.this.states.getEntryByRank(this.currRank).getValue().iterator();
                }
                return this.currIt.next();
            }

            @Override
            public void remove() {
                this.currIt.remove();
            }
        };
    }

    @Options(prefix="analysis.traversal.random")
    public static class WaitlistOptions {
        @Option(secure=true, description="Exponent of random function.This value influences the probability distribution over the waitlist elementswhen choosing the next element.Has to be a double in the range [0, INF)")
        private double exponent = 1.0;
        @Option(secure=true, description="Seed for random values.")
        private int seed = 0;

        public WaitlistOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
            if (this.exponent < 0.0) {
                throw new InvalidConfigurationException("analysis.traversal.random.exponent has to be a double greater or equal to 0");
            }
        }
    }
}

