/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.Unmaintained;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.FileTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.abe.ABECPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.argReplay.ARGReplayCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPAWithBreakOnMissingBlock;
import org.sosy_lab.cpachecker.cpa.cache.CacheCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.dca.DCACPA;
import org.sosy_lab.cpachecker.cpa.flowdep.FlowDependenceCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPA;
import org.sosy_lab.cpachecker.cpa.monitor.MonitorCPA;
import org.sosy_lab.cpachecker.cpa.powerset.PowerSetCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.singleSuccessorCompactor.SingleSuccessorCompactorCPA;
import org.sosy_lab.cpachecker.cpa.slab.SLABCPA;
import org.sosy_lab.cpachecker.cpa.slab.SLABPredicateWrappingCPA;
import org.sosy_lab.cpachecker.cpa.slicing.SlicingCPA;
import org.sosy_lab.cpachecker.cpa.termination.TerminationCPA;
import org.sosy_lab.cpachecker.cpa.traceabstraction.TraceAbstractionCPA;
import org.sosy_lab.cpachecker.cpa.usage.UsageCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

@RunWith(value=Parameterized.class)
public class CPAsTest {
    @ClassRule
    public static final TemporaryFolder tempFolder = new TemporaryFolder();
    private static final LogManager logManager = LogManager.createTestLogManager();
    private static final ShutdownNotifier shutdownNotifier = ShutdownNotifier.createDummy();
    private static final StateSpacePartition partition = StateSpacePartition.getDefaultPartition();
    private static Configuration config;
    private static CFA cfa;
    private static FunctionEntryNode main;
    @Parameterized.Parameter(value=0)
    public Class<ConfigurableProgramAnalysis> cpaClass;
    private ConfigurableProgramAnalysis cpa;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Class<?>> getCPAs() throws IOException {
        Set cpas = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader()).getTopLevelClassesRecursive(CPAsTest.class.getPackage().getName()).stream().map(ClassPath.ClassInfo::load).filter(candidate -> !Modifier.isAbstract(candidate.getModifiers())).filter(candidate -> !Modifier.isInterface(candidate.getModifiers())).filter(ConfigurableProgramAnalysis.class::isAssignableFrom).filter(candidate -> !candidate.isAnnotationPresent(Unmaintained.class)).filter(candidate -> !candidate.getPackage().isAnnotationPresent(Unmaintained.class)).collect(Collectors.toCollection(HashSet::new));
        cpas.remove(ARGCPA.class);
        cpas.remove(BAMCPA.class);
        cpas.remove(BAMCPAWithBreakOnMissingBlock.class);
        cpas.remove(CacheCPA.class);
        cpas.remove(DCACPA.class);
        cpas.remove(UsageCPA.class);
        cpas.remove(CompositeCPA.class);
        cpas.remove(MonitorCPA.class);
        cpas.remove(PropertyCheckerCPA.class);
        cpas.remove(SingleSuccessorCompactorCPA.class);
        cpas.remove(PowerSetCPA.class);
        cpas.remove(FlowDependenceCPA.class);
        cpas.remove(SlicingCPA.class);
        cpas.remove(SLABCPA.class);
        cpas.remove(ARGReplayCPA.class);
        cpas.remove(ABECPA.class);
        return cpas;
    }

    @BeforeClass
    public static void setup() throws Exception {
        FileTypeConverter fileTypeConverter = FileTypeConverter.create((Configuration)Configuration.builder().setOption("output.disable", "true").setOption("rootDirectory", tempFolder.getRoot().toString()).build());
        Configuration.getDefaultConverters().put(FileOption.class, fileTypeConverter);
        String cProgram = TestDataTools.getEmptyProgram(tempFolder, false);
        config = Configuration.builder().addConverter(FileOption.class, (TypeConverter)fileTypeConverter).setOption("cfa.findLiveVariables", "true").setOption("cpa.conditions.path.condition", "PathLengthCondition").setOption("cpa.automaton.inputFile", "test/config/automata/AssumptionAutomaton.spc").setOption("differential.program", cProgram).build();
        tempFolder.newFile("betamap.conf");
        tempFolder.newFile("immediatechecks.conf");
        cfa = TestDataTools.toSingleFunctionCFA(new CFACreator(config, logManager, shutdownNotifier), "  int a;", "  a = 1;", "  return a;");
        main = cfa.getMainFunction();
    }

    @Before
    public void instantiate() throws Exception {
        Method factoryMethod = this.cpaClass.getMethod("factory", new Class[0]);
        CPAFactory factory = (CPAFactory)factoryMethod.invoke(null, new Object[0]);
        AggregatedReachedSets aggregatedReachedSets = AggregatedReachedSets.empty();
        ReachedSetFactory reachedSetFactory = new ReachedSetFactory(config, logManager);
        Optional<CPAFactory> childCPA = this.getChildCpaFactoryIfNecessary(this.cpaClass);
        if (childCPA.isPresent()) {
            factory.setChild(this.createCpa(childCPA.orElseThrow(), aggregatedReachedSets, reachedSetFactory));
        }
        try {
            this.cpa = this.createCpa(factory, aggregatedReachedSets, reachedSetFactory);
        }
        catch (LinkageError e) {
            Assume.assumeNoException((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    private Optional<CPAFactory> getChildCpaFactoryIfNecessary(Class<?> pCpaClass) {
        if (pCpaClass.equals(TerminationCPA.class)) {
            return Optional.of(LocationCPA.factory());
        }
        if (pCpaClass.equals(SLABPredicateWrappingCPA.class) || pCpaClass.equals(TraceAbstractionCPA.class)) {
            return Optional.of(PredicateCPA.factory());
        }
        return Optional.empty();
    }

    private ConfigurableProgramAnalysis createCpa(CPAFactory factory, AggregatedReachedSets aggregatedReachedSets, ReachedSetFactory reachedSetFactory) throws InvalidConfigurationException, CPAException, InterruptedException {
        return factory.setLogger(logManager).setConfiguration(config).setShutdownNotifier(shutdownNotifier).set(reachedSetFactory, ReachedSetFactory.class).set(cfa, CFA.class).set(Specification.alwaysSatisfied(), Specification.class).set(aggregatedReachedSets, AggregatedReachedSets.class).createInstance();
    }

    @Test
    public void getInitialState() throws InterruptedException {
        Truth.assertWithMessage((String)"initial state").that((Object)this.cpa.getInitialState(main, partition)).isNotNull();
    }

    @Test
    public void join() throws CPAException, InterruptedException {
        AbstractState joined;
        AbstractState initial = this.cpa.getInitialState(main, partition);
        try {
            joined = this.cpa.getAbstractDomain().join(initial, initial);
        }
        catch (UnsupportedOperationException e) {
            Assume.assumeNoException((Throwable)e);
            throw new AssertionError((Object)e);
        }
        Truth.assertWithMessage((String)"result of join").that((Object)joined).isNotNull();
        Truth.assert_().withMessage("Join of same elements is unsound").that(Boolean.valueOf(this.isLessOrEqual(initial, joined))).isTrue();
    }

    @Test
    public void merge() throws CPAException, InterruptedException {
        AbstractState initial = this.cpa.getInitialState(main, partition);
        Precision initialPrec = this.cpa.getInitialPrecision(main, partition);
        AbstractState merged = this.cpa.getMergeOperator().merge(initial, initial, initialPrec);
        Truth.assertWithMessage((String)"result of merge").that((Object)merged).isNotNull();
        Truth.assert_().withMessage("Merging same elements was unsound").that(Boolean.valueOf(this.isLessOrEqual(initial, merged))).isTrue();
    }

    @Test
    public void stop_EmptyReached() throws CPAException, InterruptedException {
        AbstractState initial = this.cpa.getInitialState(main, partition);
        Precision initialPrec = this.cpa.getInitialPrecision(main, partition);
        ImmutableSet reached = ImmutableSet.of();
        this.cpa.getStopOperator().stop(initial, (Collection<AbstractState>)reached, initialPrec);
    }

    @Test
    public void stop_SameElement() throws CPAException, InterruptedException {
        AbstractState initial = this.cpa.getInitialState(main, partition);
        Precision initialPrec = this.cpa.getInitialPrecision(main, partition);
        ImmutableSet reached = ImmutableSet.of((Object)initial);
        Truth.assert_().withMessage("Did not stop on same element").that(Boolean.valueOf(this.cpa.getStopOperator().stop(initial, (Collection<AbstractState>)reached, initialPrec))).isTrue();
    }

    private boolean isLessOrEqual(AbstractState s1, AbstractState s2) throws CPAException, InterruptedException {
        try {
            return this.cpa.getAbstractDomain().isLessOrEqual(s1, s2);
        }
        catch (UnsupportedOperationException e) {
            Assume.assumeNoException((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }
}

