/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abe;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.abe.ABEAbstractedState;
import org.sosy_lab.cpachecker.cpa.abe.ABEManager;
import org.sosy_lab.cpachecker.cpa.abe.ABEState;
import org.sosy_lab.cpachecker.cpa.abe.ABEWrappingManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;

@Options(prefix="cpa.abe")
public final class ABECPA<A extends ABEAbstractedState<A>, P extends Precision>
extends SingleEdgeTransferRelation
implements ConfigurableProgramAnalysis,
AbstractDomain,
PrecisionAdjustment,
MergeOperator {
    @Option(secure=true, description="Cache formulas produced by path formula manager")
    private boolean useCachingPathFormulaManager = true;
    private final ABEWrappingManager<A, P> manager;

    public ABECPA(Configuration pConfiguration, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCFA, ABEManager<A, P> clientManager, Solver pSolver) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this, ABECPA.class);
        FormulaManagerView formulaManager = pSolver.getFormulaManager();
        PathFormulaManager pathFormulaManager = new PathFormulaManagerImpl(formulaManager, pConfiguration, pLogger, pShutdownNotifier, pCFA, AnalysisDirection.FORWARD);
        if (this.useCachingPathFormulaManager) {
            pathFormulaManager = new CachingPathFormulaManager(pathFormulaManager);
        }
        this.manager = new ABEWrappingManager<A, P>(clientManager, pathFormulaManager, formulaManager, pCFA, pLogger, pSolver, pConfiguration);
    }

    @Override
    public AbstractState join(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        throw new UnsupportedOperationException("Join operator not supported.");
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this;
    }

    @Override
    public boolean isLessOrEqual(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        return this.manager.isLessOrEqual((ABEState)state1, (ABEState)state2);
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this;
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this);
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this;
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return this.manager.getInitialState(node, partition);
    }

    @Override
    public Precision getInitialPrecision(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return this.manager.getInitialPrecision(node, partition);
    }

    @Override
    public AbstractState merge(AbstractState state1, AbstractState state2, Precision precision) throws CPAException, InterruptedException {
        return this.manager.merge((ABEState)state1, (ABEState)state2);
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState state, Precision precision, UnmodifiableReachedSet states, Function<AbstractState, AbstractState> stateProjection, AbstractState fullState) throws CPAException, InterruptedException {
        return this.manager.prec((ABEState)state, precision, states, fullState);
    }

    @Override
    public Optional<? extends AbstractState> strengthen(AbstractState pState, Precision pPrecision, Iterable<AbstractState> otherStates) throws CPAException, InterruptedException {
        return this.manager.strengthen((ABEState)pState, pPrecision, otherStates);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState state, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        return this.manager.getAbstractSuccessorsForEdge((ABEState)state, cfaEdge);
    }
}

