/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.abe;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.abe.ABEAbstractedState;
import org.sosy_lab.cpachecker.cpa.abe.ABEIntermediateState;
import org.sosy_lab.cpachecker.cpa.abe.ABEManager;
import org.sosy_lab.cpachecker.cpa.abe.ABEState;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.abe")
public class ABEWrappingManager<A extends ABEAbstractedState<A>, P extends Precision> {
    @Option(secure=true, description="Where to perform abstraction")
    private AbstractionLocations abstractionLocations = AbstractionLocations.LOOPHEAD;
    @Option(secure=true, description="Check target states reachability")
    private boolean checkTargetStates = true;
    private final ABEManager<A, P> clientManager;
    private final PathFormulaManager pfmgr;
    private final FormulaManagerView fmgr;
    private final CFA cfa;
    private final LogManager logger;
    private final BooleanFormulaManager bfmgr;
    private final Solver solver;

    public ABEWrappingManager(ABEManager<A, P> pAbstractABEStatePABEManager, PathFormulaManager pPathFormulaManager, FormulaManagerView pFormulaManager, CFA pCfa, LogManager pLogger, Solver pSolver, Configuration pConfiguration) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this, ABEWrappingManager.class);
        this.clientManager = pAbstractABEStatePABEManager;
        this.pfmgr = pPathFormulaManager;
        this.fmgr = pFormulaManager;
        this.cfa = pCfa;
        this.logger = pLogger;
        this.solver = pSolver;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
    }

    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(ABEState<A> pState, CFAEdge edge) throws CPATransferException, InterruptedException {
        ABEIntermediateState<A> iOldState;
        CFANode node = edge.getSuccessor();
        if (pState.isAbstract()) {
            ABEAbstractedState<A> aState = pState.asAbstracted();
            iOldState = ABEIntermediateState.of(pState.getNode(), this.pfmgr.makeEmptyPathFormulaWithContext(aState.getSSAMap(), aState.getPointerTargetSet()), aState);
        } else {
            iOldState = pState.asIntermediate();
        }
        PathFormula outPath = this.pfmgr.makeAnd(iOldState.getPathFormula(), edge);
        ABEIntermediateState<A> out = ABEIntermediateState.of(node, outPath, iOldState.getBackpointerState());
        return Collections.singleton(out);
    }

    public Optional<? extends AbstractState> strengthen(ABEState<A> pState, P pPrecision, Iterable<AbstractState> pOtherStates) {
        if (!pState.isAbstract()) {
            return Optional.of(pState);
        }
        return this.clientManager.strengthen(pState.asAbstracted(), pPrecision, pOtherStates);
    }

    public A getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.clientManager.getInitialState(pNode, pPartition);
    }

    public P getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.clientManager.getInitialPrecision(pNode, pPartition);
    }

    public boolean isLessOrEqual(ABEState<A> pState1, ABEState<A> pState2) {
        if (!pState1.isAbstract()) {
            ABEIntermediateState<A> iState2;
            ABEIntermediateState<A> iState1 = pState1.asIntermediate();
            return iState1.isMergedInto(iState2 = pState2.asIntermediate()) || iState1.getPathFormula().getFormula().equals(iState2.getPathFormula().getFormula()) && this.clientManager.isLessOrEqual(iState1.getBackpointerState(), iState2.getBackpointerState());
        }
        return this.clientManager.isLessOrEqual(pState1.asAbstracted(), pState2.asAbstracted());
    }

    public ABEState<A> merge(ABEState<A> state1, ABEState<A> state2) throws InterruptedException {
        Preconditions.checkState((state1.isAbstract() == state2.isAbstract() ? 1 : 0) != 0, (Object)"Only states with the same abstraction status should be allowed to merge");
        if (state1.isAbstract()) {
            return state2;
        }
        ABEIntermediateState<A> iState1 = state1.asIntermediate();
        ABEIntermediateState<A> iState2 = state2.asIntermediate();
        Preconditions.checkState((boolean)Objects.equals(iState1.getNode(), iState2.getNode()));
        if (!iState1.getBackpointerState().equals(iState2.getBackpointerState())) {
            return iState2;
        }
        if (iState1.isMergedInto(iState2)) {
            return iState2;
        }
        if (iState2.isMergedInto(iState1)) {
            return iState1;
        }
        PathFormula mergedPath = this.pfmgr.makeOr(iState1.getPathFormula(), iState2.getPathFormula());
        ABEIntermediateState<A> out = ABEIntermediateState.of(iState1.getNode(), mergedPath, iState2.getBackpointerState());
        iState1.setMergedInto(out);
        iState2.setMergedInto(out);
        return out;
    }

    public Optional<PrecisionAdjustmentResult> prec(ABEState<A> pState, P pPrecision, UnmodifiableReachedSet pStates, AbstractState pFullState) throws CPATransferException, InterruptedException {
        Preconditions.checkState((!pState.isAbstract() ? 1 : 0) != 0);
        ABEIntermediateState<A> iState = pState.asIntermediate();
        boolean hasTargetState = AbstractStates.asIterable(pFullState).anyMatch(AbstractStates::isTargetState);
        boolean shouldPerformAbstraction = this.shouldPerformAbstraction(iState.getNode(), pFullState);
        BooleanFormula extraInvariant = this.extractFormula(pFullState);
        if ((hasTargetState && this.checkTargetStates || shouldPerformAbstraction) && this.isUnreachable(iState, extraInvariant)) {
            this.logger.log(Level.INFO, new Object[]{"Returning bottom state"});
            return Optional.empty();
        }
        if (shouldPerformAbstraction) {
            return Optional.of(this.clientManager.performAbstraction(iState, pPrecision, pStates, pFullState));
        }
        return Optional.of(PrecisionAdjustmentResult.create(iState, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
    }

    private boolean isUnreachable(ABEIntermediateState<A> pIState, BooleanFormula pExtraInvariant) throws CPATransferException, InterruptedException {
        BooleanFormula backpointerFormula = pIState.getBackpointerState().instantiate();
        BooleanFormula constraint = this.bfmgr.and(new BooleanFormula[]{backpointerFormula, pIState.getPathFormula().getFormula(), this.fmgr.instantiate(pExtraInvariant, pIState.getPathFormula().getSsa())});
        try {
            return this.solver.isUnsat(this.bfmgr.toConjunctionArgs(constraint, true), pIState.getNode());
        }
        catch (SolverException e) {
            throw new CPATransferException("Failed solving", e);
        }
    }

    private boolean shouldPerformAbstraction(CFANode node, AbstractState totalState) {
        switch (this.abstractionLocations) {
            case ALL: {
                return true;
            }
            case LOOPHEAD: {
                LoopBoundState loopState = AbstractStates.extractStateByType(totalState, LoopBoundState.class);
                return this.cfa.getAllLoopHeads().orElseThrow().contains((Object)node) && (loopState == null || loopState.isLoopCounterAbstracted());
            }
            case MERGE: {
                return node.getNumEnteringEdges() > 1;
            }
        }
        throw new UnsupportedOperationException("Unexpected state");
    }

    private BooleanFormula extractFormula(AbstractState pFormulaState) {
        return AbstractStates.extractReportedFormulas(this.fmgr, pFormulaState);
    }

    public static enum AbstractionLocations {
        ALL,
        LOOPHEAD,
        MERGE;

    }
}

