/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.acsl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFAWithACSLAnnotations;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBuiltinCollectingVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateToExpressionTreeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTermToCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.acsl.ACSLState;
import org.sosy_lab.cpachecker.cpa.acsl.ACSLTransferRelation;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.expressions.ToCExpressionVisitor;

@Options(prefix="cpa.acsl")
public class ACSLCPA
extends AbstractCPA
implements ConfigurableProgramAnalysis {
    @Option(secure=true, description="only store pure C expressions without ACSL-specific constructs")
    private boolean usePureExpressionsOnly = true;
    private final CFAWithACSLAnnotations cfa;
    private final LogManager logger;
    private final ACSLPredicateToExpressionTreeVisitor acslVisitor;
    private final ToCExpressionVisitor expressionTreeVisitor;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ACSLCPA.class);
    }

    private ACSLCPA(CFA pCFA, LogManager pLogManager, Configuration pConfig) throws InvalidConfigurationException {
        super("sep", "sep", null);
        this.logger = pLogManager;
        if (pCFA instanceof CFAWithACSLAnnotations) {
            this.cfa = (CFAWithACSLAnnotations)pCFA;
        } else {
            this.cfa = new CFAWithACSLAnnotations(pCFA);
            this.logger.log(Level.WARNING, new Object[]{"No ACSL annotations in CFA, ACSLCPA is useless."});
        }
        ACSLTermToCExpressionVisitor termVisitor = new ACSLTermToCExpressionVisitor(this.cfa, this.logger);
        this.acslVisitor = new ACSLPredicateToExpressionTreeVisitor(termVisitor);
        this.expressionTreeVisitor = new ToCExpressionVisitor(this.cfa.getMachineModel(), this.logger);
        pConfig.inject((Object)this);
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new ACSLTransferRelation(this.cfa, this.logger, this.acslVisitor, this.expressionTreeVisitor, this.usePureExpressionsOnly);
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) throws InterruptedException {
        ImmutableSet.Builder annotations = ImmutableSet.builder();
        for (CFAEdge edge : CFAUtils.enteringEdges(node)) {
            Collection annotationsForEdge = this.cfa.getEdgesToAnnotations().get((Object)edge);
            if (this.usePureExpressionsOnly) {
                ACSLBuiltinCollectingVisitor visitor = new ACSLBuiltinCollectingVisitor();
                annotationsForEdge = FluentIterable.from((Iterable)annotationsForEdge).filter(x -> x.getPredicateRepresentation().accept(visitor).isEmpty()).toSet();
            }
            annotations.addAll((Iterable)annotationsForEdge);
        }
        return new ACSLState((Set<ACSLAnnotation>)annotations.build(), this.acslVisitor, this.expressionTreeVisitor, this.logger);
    }
}

