/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.acsl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateToExpressionTreeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.ExpressionTreeReportingState;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.expressions.ToCExpressionVisitor;

public class ACSLState
implements AbstractStateWithAssumptions,
ExpressionTreeReportingState {
    private final ImmutableSet<ACSLAnnotation> annotations;
    private final ACSLPredicateToExpressionTreeVisitor acslVisitor;
    private final ToCExpressionVisitor expressionTreeVisitor;
    private final LogManager logger;

    public ACSLState(Set<ACSLAnnotation> pAnnotations, ACSLPredicateToExpressionTreeVisitor pACSLVisitor, ToCExpressionVisitor pExpressionTreeVisitor, LogManager pLogManager) {
        this.annotations = ImmutableSet.copyOf(pAnnotations);
        this.acslVisitor = pACSLVisitor;
        this.expressionTreeVisitor = pExpressionTreeVisitor;
        this.logger = pLogManager;
    }

    @Override
    public ExpressionTree<Object> getFormulaApproximation(FunctionEntryNode pFunctionScope, CFANode pLocation) {
        return this.toExpressionTree();
    }

    private ExpressionTree<Object> toExpressionTree() {
        if (this.annotations.isEmpty()) {
            return ExpressionTrees.getTrue();
        }
        ArrayList representations = new ArrayList(this.annotations.size());
        for (ACSLAnnotation annotation : this.annotations) {
            ACSLPredicate predicate = annotation.getPredicateRepresentation();
            try {
                representations.add(predicate.accept(this.acslVisitor));
            }
            catch (UnrecognizedCodeException e) {
                throw new AssertionError((Object)("Could not convert predicate to expression tree: " + predicate));
            }
        }
        ExpressionTreeFactory factory = ExpressionTrees.newFactory();
        return factory.and(representations);
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotations);
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof ACSLState) {
            ACSLState that = (ACSLState)pO;
            return this.annotations.equals(that.annotations);
        }
        return false;
    }

    @Override
    public String toString() {
        return "ACSLState " + this.annotations;
    }

    @Override
    public List<? extends AExpression> getAssumptions() {
        try {
            ExpressionTree<Object> exp = this.toExpressionTree();
            if (exp.equals(ExpressionTrees.getTrue())) {
                return ImmutableList.of();
            }
            if (exp.equals(ExpressionTrees.getFalse())) {
                return ImmutableList.of((Object)((CExpression)this.expressionTreeVisitor.visitFalse()));
            }
            if (exp instanceof LeafExpression) {
                return ImmutableList.of((Object)((CExpression)this.expressionTreeVisitor.visit((LeafExpression)exp)));
            }
            if (exp instanceof And) {
                return ImmutableList.of((Object)((CExpression)this.expressionTreeVisitor.visit((And)exp)));
            }
            if (exp instanceof Or) {
                return ImmutableList.of((Object)((CExpression)this.expressionTreeVisitor.visit((Or)exp)));
            }
            throw new AssertionError((Object)"Unknown type of ExpressionTree.");
        }
        catch (UnrecognizedCodeException e) {
            this.logger.log(Level.WARNING, new Object[]{"Could not convert some annotations to assumption, ignoring"});
            return ImmutableList.of();
        }
    }
}

