/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.acsl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFAWithACSLAnnotations;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLBuiltinCollectingVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateToExpressionTreeVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.acsl.ACSLState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.expressions.ToCExpressionVisitor;

public class ACSLTransferRelation
extends SingleEdgeTransferRelation {
    private final CFAWithACSLAnnotations cfa;
    private final LogManager logger;
    private final ACSLPredicateToExpressionTreeVisitor acslVisitor;
    private final ToCExpressionVisitor expressionTreeVisitor;
    private final boolean usePureExpressionsOnly;

    public ACSLTransferRelation(CFAWithACSLAnnotations pCFA, LogManager pLogManager, ACSLPredicateToExpressionTreeVisitor pACSLVisitor, ToCExpressionVisitor pExpressionTreeVisitor, boolean pUsePureExpressionsOnly) {
        this.cfa = pCFA;
        this.logger = pLogManager;
        this.acslVisitor = pACSLVisitor;
        this.expressionTreeVisitor = pExpressionTreeVisitor;
        this.usePureExpressionsOnly = pUsePureExpressionsOnly;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState state, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        ImmutableSet annotationsForEdge = ImmutableSet.copyOf((Collection)this.cfa.getEdgesToAnnotations().get((Object)cfaEdge));
        if (this.usePureExpressionsOnly) {
            ACSLBuiltinCollectingVisitor visitor = new ACSLBuiltinCollectingVisitor();
            ImmutableSet annotations = FluentIterable.from((Iterable)annotationsForEdge).filter(x -> x.getPredicateRepresentation().accept(visitor).isEmpty()).toSet();
            return ImmutableList.of((Object)new ACSLState((Set<ACSLAnnotation>)annotations, this.acslVisitor, this.expressionTreeVisitor, this.logger));
        }
        return ImmutableList.of((Object)new ACSLState((Set<ACSLAnnotation>)annotationsForEdge, this.acslVisitor, this.expressionTreeVisitor, this.logger));
    }
}

