/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.andersen;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.andersen.AndersenState;
import org.sosy_lab.cpachecker.cpa.andersen.util.BaseConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.ComplexConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.SimpleConstraint;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class AndersenTransferRelation
extends SingleEdgeTransferRelation {
    private final LogManager logger;

    public AndersenTransferRelation(LogManager pLogger) {
        this.logger = pLogger;
    }

    public Collection<AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        AndersenState successor = null;
        AndersenState andersenState = (AndersenState)pElement;
        switch (pCfaEdge.getEdgeType()) {
            case StatementEdge: {
                CStatementEdge statementEdge = (CStatementEdge)pCfaEdge;
                successor = this.handleStatement(andersenState, statementEdge.getStatement(), pCfaEdge);
                break;
            }
            case DeclarationEdge: {
                CDeclarationEdge declarationEdge = (CDeclarationEdge)pCfaEdge;
                successor = this.handleDeclaration(andersenState, declarationEdge);
                break;
            }
            case AssumeEdge: {
                successor = andersenState;
                break;
            }
            case BlankEdge: {
                successor = andersenState;
                break;
            }
            default: {
                this.printWarning(pCfaEdge);
            }
        }
        if (successor == null) {
            return ImmutableSet.of();
        }
        return Collections.singleton(successor);
    }

    private AndersenState handleStatement(AndersenState pElement, CStatement pExpression, CFAEdge pCfaEdge) throws UnrecognizedCodeException {
        if (pExpression instanceof CAssignment) {
            return this.handleAssignment(pElement, (CAssignment)pExpression, pCfaEdge);
        }
        if (pExpression instanceof CFunctionCallStatement) {
            return pElement;
        }
        if (pExpression instanceof CExpressionStatement) {
            return pElement;
        }
        throw new UnrecognizedCodeException("unknown statement", pCfaEdge, pExpression);
    }

    private AndersenState handleAssignment(AndersenState pElement, CAssignment pAssignExpression, CFAEdge pCfaEdge) throws UnrecognizedCodeException {
        CExpression op1 = pAssignExpression.getLeftHandSide();
        CRightHandSide op2 = pAssignExpression.getRightHandSide();
        if (op1 instanceof CIdExpression) {
            return this.handleAssignmentTo(op1.toASTString(), op2, pElement, pCfaEdge);
        }
        if (op1 instanceof CPointerExpression && op2 instanceof CIdExpression) {
            if ((op1 = ((CPointerExpression)op1).getOperand()) instanceof CIdExpression) {
                return pElement.addConstraint(new ComplexConstraint(op2.toASTString(), op1.toASTString(), false));
            }
            throw new UnrecognizedCodeException("not supported", pCfaEdge, op2);
        }
        throw new UnrecognizedCodeException("not supported", pCfaEdge, op1);
    }

    private AndersenState handleAssignmentTo(String pOp1, CRightHandSide pOp2, AndersenState pElement, CFAEdge pCfaEdge) throws UnrecognizedCodeException {
        while (pOp2 instanceof CCastExpression) {
            pOp2 = ((CCastExpression)pOp2).getOperand();
        }
        if (pOp2 instanceof CIdExpression) {
            return pElement.addConstraint(new SimpleConstraint(pOp2.toASTString(), pOp1));
        }
        if (pOp2 instanceof CUnaryExpression && ((CUnaryExpression)pOp2).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            if ((pOp2 = ((CUnaryExpression)pOp2).getOperand()) instanceof CIdExpression) {
                return pElement.addConstraint(new BaseConstraint(pOp2.toASTString(), pOp1));
            }
            throw new UnrecognizedCodeException("not supported", pCfaEdge, pOp2);
        }
        if (pOp2 instanceof CPointerExpression) {
            if ((pOp2 = ((CPointerExpression)pOp2).getOperand()) instanceof CIdExpression) {
                return pElement.addConstraint(new ComplexConstraint(pOp2.toASTString(), pOp1, true));
            }
            throw new UnrecognizedCodeException("not supported", pCfaEdge, pOp2);
        }
        if (pOp2 instanceof CFunctionCallExpression && "malloc".equals(((CFunctionCallExpression)pOp2).getFunctionNameExpression().toASTString())) {
            return pElement.addConstraint(new BaseConstraint("malloc-" + pCfaEdge.getLineNumber(), pOp1));
        }
        this.printWarning(pCfaEdge);
        return pElement;
    }

    private AndersenState handleDeclaration(AndersenState pElement, CDeclarationEdge pDeclarationEdge) throws UnrecognizedCodeException {
        if (!(pDeclarationEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return pElement;
        }
        CVariableDeclaration decl = (CVariableDeclaration)pDeclarationEdge.getDeclaration();
        String varName = decl.getName();
        CInitializer init = decl.getInitializer();
        if (init instanceof CInitializerExpression) {
            CExpression exp = ((CInitializerExpression)init).getExpression();
            return this.handleAssignmentTo(varName, exp, pElement, pDeclarationEdge);
        }
        return pElement;
    }

    private void printWarning(CFAEdge pCfaEdge) {
        this.logger.log(Level.WARNING, new Object[]{pCfaEdge.getFileLocation() + ":", "Warning! CFA Edge \"" + pCfaEdge.getRawStatement() + "\" not handled."});
    }
}

