/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.andersen.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.andersen.util.BaseConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.ComplexConstraint;
import org.sosy_lab.cpachecker.cpa.andersen.util.DirectedGraph;
import org.sosy_lab.cpachecker.cpa.andersen.util.SimpleConstraint;

public class ConstraintSystem {
    private final Set<BaseConstraint> baseConstraints = new HashSet<BaseConstraint>();
    private final Set<SimpleConstraint> simpleConstraints = new HashSet<SimpleConstraint>();
    private final Set<ComplexConstraint> complexConstraints = new HashSet<ComplexConstraint>();
    @LazyInit
    private ImmutableListMultimap<String, String> pointsToSets;

    public ConstraintSystem() {
    }

    public ConstraintSystem(ConstraintSystem pToCopy) {
        this.baseConstraints.addAll(pToCopy.baseConstraints);
        this.simpleConstraints.addAll(pToCopy.simpleConstraints);
        this.complexConstraints.addAll(pToCopy.complexConstraints);
    }

    public Set<BaseConstraint> getBaseConstraints() {
        return Collections.unmodifiableSet(this.baseConstraints);
    }

    public Set<SimpleConstraint> getSimpleConstraints() {
        return Collections.unmodifiableSet(this.simpleConstraints);
    }

    public Set<ComplexConstraint> getComplexConstraints() {
        return Collections.unmodifiableSet(this.complexConstraints);
    }

    public ImmutableListMultimap<String, String> getPointsToSets() {
        if (this.pointsToSets == null) {
            this.pointsToSets = ConstraintSystem.computeDynTransitiveClosure(this.baseConstraints, this.simpleConstraints, this.complexConstraints);
        }
        return this.pointsToSets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.baseConstraints == null ? 0 : this.baseConstraints.hashCode());
        result = 31 * result + (this.complexConstraints == null ? 0 : this.complexConstraints.hashCode());
        result = 31 * result + (this.pointsToSets == null ? 0 : this.pointsToSets.hashCode());
        result = 31 * result + (this.simpleConstraints == null ? 0 : this.simpleConstraints.hashCode());
        return result;
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO instanceof ConstraintSystem) {
            ConstraintSystem other = (ConstraintSystem)pO;
            return this.baseConstraints.equals(other.baseConstraints) && this.complexConstraints.equals(other.complexConstraints) && this.simpleConstraints.equals(other.simpleConstraints);
        }
        return false;
    }

    public ConstraintSystem addConstraint(BaseConstraint pConstr) {
        if (this.baseConstraints.contains(pConstr)) {
            return this;
        }
        ConstraintSystem result = new ConstraintSystem(this);
        result.baseConstraints.add(pConstr);
        return result;
    }

    public ConstraintSystem addConstraint(SimpleConstraint pConstr) {
        if (this.simpleConstraints.contains(pConstr)) {
            return this;
        }
        ConstraintSystem result = new ConstraintSystem(this);
        result.simpleConstraints.add(pConstr);
        return result;
    }

    public ConstraintSystem addConstraint(ComplexConstraint pConstr) {
        if (this.complexConstraints.contains(pConstr)) {
            return this;
        }
        ConstraintSystem result = new ConstraintSystem(this);
        result.complexConstraints.add(pConstr);
        return result;
    }

    private static ImmutableListMultimap<String, String> computeDynTransitiveClosure(Set<BaseConstraint> bConstr, Set<SimpleConstraint> sConstr, Set<ComplexConstraint> cConstr) {
        DirectedGraph g = new DirectedGraph();
        ConstraintSystem.buildGraph(bConstr, sConstr, cConstr, g);
        HashSet<DirectedGraph.Node> workset = new HashSet<DirectedGraph.Node>();
        for (Map.Entry<String, DirectedGraph.Node> entry : g.getNameMappings()) {
            workset.add(entry.getValue());
        }
        HashSet<DirectedGraph.Edge> tested = new HashSet<DirectedGraph.Edge>();
        block1: while (!workset.isEmpty()) {
            DirectedGraph.Node n = (DirectedGraph.Node)workset.iterator().next();
            workset.remove(n);
            if (!n.isValid()) continue;
            if (n.mergePts != null) {
                g.mergeNodes(n.mergePts, n.getPointsToNodesSet());
            }
            for (DirectedGraph.Node v : n.getPointsToNodesSet()) {
                for (String aStr : n.complexConstrMeSub) {
                    DirectedGraph.Node a = g.getNode(aStr);
                    if (v.isSuccessor(a)) continue;
                    g.addEdge(v, a);
                    workset.add(v);
                }
                for (String bStr : n.complexConstrMeSuper) {
                    DirectedGraph.Node b = g.getNode(bStr);
                    if (b.isSuccessor(v)) continue;
                    g.addEdge(b, v);
                    workset.add(b);
                }
            }
            for (DirectedGraph.Node z : n.getSuccessors()) {
                DirectedGraph.Edge edge = new DirectedGraph.Edge(n, z);
                if (z.getPointsToSet().equals(n.getPointsToSet()) && !tested.contains(edge)) {
                    tested.add(edge);
                    DirectedGraph.Node merged = g.detectAndCollapseCycleContainingEdge(edge);
                    if (merged == null) continue;
                    workset.add(merged);
                    continue block1;
                }
                if (!n.propagatePointerTargetsTo(z)) continue;
                workset.add(z);
            }
        }
        ImmutableListMultimap.Builder ptSets = ImmutableListMultimap.builder();
        for (Map.Entry<String, DirectedGraph.Node> e : g.getNameMappings()) {
            Set<String> ptSetNode = e.getValue().getPointsToSet();
            ptSets.putAll((Object)e.getKey(), ptSetNode);
        }
        return ptSets.build();
    }

    private static void buildGraph(Set<BaseConstraint> bConstr, Set<SimpleConstraint> sConstr, Set<ComplexConstraint> cConstr, DirectedGraph g) {
        DirectedGraph.Node n;
        List<List<String>> sccs = ConstraintSystem.buildOfflineGraphAndFindSCCs(sConstr, cConstr);
        for (BaseConstraint bc : bConstr) {
            n = g.getNode(bc.getSuperVar());
            n.addPointerTarget(bc.getSubVar());
        }
        for (SimpleConstraint sc : sConstr) {
            DirectedGraph.Node src = g.getNode(sc.getSubVar());
            DirectedGraph.Node dest = g.getNode(sc.getSuperVar());
            g.addEdge(src, dest);
        }
        for (ComplexConstraint cc : cConstr) {
            if (cc.isSubDerefed()) {
                n = g.getNode(cc.getSubVar());
                n.complexConstrMeSub.add(cc.getSuperVar());
                continue;
            }
            n = g.getNode(cc.getSuperVar());
            n.complexConstrMeSuper.add(cc.getSubVar());
        }
        ConstraintSystem.mergeOrMarkSCCs(g, sccs);
    }

    private static void mergeOrMarkSCCs(DirectedGraph g, List<List<String>> sccs) {
        for (List<String> scc : sccs) {
            ArrayList<DirectedGraph.Node> refNodes = new ArrayList<DirectedGraph.Node>();
            ArrayDeque<DirectedGraph.Node> normNodes = new ArrayDeque<DirectedGraph.Node>();
            for (String n : scc) {
                if (n.charAt(0) == '*') {
                    refNodes.add(g.getNode(n.substring(1)));
                    continue;
                }
                normNodes.add(g.getNode(n));
            }
            DirectedGraph.Node merged = g.mergeNodes((DirectedGraph.Node)normNodes.poll(), normNodes);
            for (DirectedGraph.Node n : refNodes) {
                n.mergePts = merged;
            }
        }
    }

    private static List<List<String>> buildOfflineGraphAndFindSCCs(Collection<SimpleConstraint> sConstr, Collection<ComplexConstraint> cConstr) {
        DirectedGraph.Node dest;
        DirectedGraph.Node src;
        Object destStr;
        Object srcStr;
        HashSet<DirectedGraph.Node> workset = new HashSet<DirectedGraph.Node>();
        DirectedGraph g = new DirectedGraph();
        HashMap<DirectedGraph.Node, String> nodeStrMap = new HashMap<DirectedGraph.Node, String>();
        for (SimpleConstraint sc : sConstr) {
            srcStr = sc.getSubVar();
            destStr = sc.getSuperVar();
            src = g.getNode((String)srcStr);
            dest = g.getNode((String)destStr);
            g.addEdge(src, dest);
            workset.add(src);
            workset.add(dest);
            nodeStrMap.put(src, (String)srcStr);
            nodeStrMap.put(dest, (String)destStr);
        }
        for (ComplexConstraint cc : cConstr) {
            if (cc.isSubDerefed()) {
                srcStr = "*" + cc.getSubVar();
                destStr = cc.getSuperVar();
            } else {
                srcStr = cc.getSubVar();
                destStr = "*" + cc.getSuperVar();
            }
            src = g.getNode((String)srcStr);
            dest = g.getNode((String)destStr);
            g.addEdge(src, dest);
            workset.add(src);
            workset.add(dest);
            nodeStrMap.put(src, (String)srcStr);
            nodeStrMap.put(dest, (String)destStr);
        }
        int maxdfs = 1;
        ArrayDeque<DirectedGraph.Node> stack = new ArrayDeque<DirectedGraph.Node>();
        ArrayList<List<String>> sccs = new ArrayList<List<String>>();
        while (!workset.isEmpty()) {
            DirectedGraph.Node n = (DirectedGraph.Node)workset.iterator().next();
            maxdfs = ConstraintSystem.tarjan(maxdfs, n, workset, stack, nodeStrMap, sccs);
        }
        return sccs;
    }

    private static int tarjan(int maxdfs, DirectedGraph.Node v, Set<DirectedGraph.Node> workset, Deque<DirectedGraph.Node> stack, Map<DirectedGraph.Node, String> nodeStrMap, List<List<String>> sccs) {
        v.dfs = maxdfs;
        v.lowlink = maxdfs++;
        stack.push(v);
        workset.remove(v);
        for (DirectedGraph.Node succ : v.getSuccessors()) {
            if (workset.contains(succ)) {
                maxdfs = ConstraintSystem.tarjan(maxdfs, succ, workset, stack, nodeStrMap, sccs);
                v.lowlink = Math.min(v.lowlink, succ.lowlink);
                continue;
            }
            if (succ.dfs <= 0) continue;
            v.lowlink = Math.min(v.lowlink, succ.dfs);
        }
        if (v.lowlink == v.dfs) {
            DirectedGraph.Node succ;
            ArrayList<String> scc = new ArrayList<String>();
            do {
                succ = stack.pop();
                succ.dfs = -succ.dfs;
                scc.add(nodeStrMap.get(succ));
            } while (!succ.equals(v));
            if (scc.size() > 1) {
                sccs.add(scc);
            }
        }
        return maxdfs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append('\n');
        for (BaseConstraint baseConstraint : this.getBaseConstraints()) {
            sb.append('{').append(baseConstraint.getSubVar()).append("} \u2286 ");
            sb.append(baseConstraint.getSuperVar()).append('\n');
        }
        for (SimpleConstraint simpleConstraint : this.getSimpleConstraints()) {
            sb.append(simpleConstraint.getSubVar()).append(" \u2286 ");
            sb.append(simpleConstraint.getSuperVar()).append('\n');
        }
        for (ComplexConstraint complexConstraint : this.getComplexConstraints()) {
            sb.append(complexConstraint.getSubVar()).append(" \u2286 ");
            sb.append(complexConstraint.getSuperVar()).append('\n');
        }
        int size = this.getBaseConstraints().size() + this.getSimpleConstraints().size() + this.getComplexConstraints().size();
        sb.append("] size->  ").append(size);
        sb.append('\n');
        sb.append('[').append('\n');
        ImmutableListMultimap<String, String> immutableListMultimap = this.getPointsToSets();
        for (Map.Entry entry : immutableListMultimap.asMap().entrySet()) {
            sb.append((String)entry.getKey()).append(" -> {");
            Joiner.on((char)',').appendTo(sb, (Iterable)entry.getValue());
            sb.append('}').append('\n');
        }
        sb.append(']').append('\n');
        return sb.toString();
    }

    public ConstraintSystem join(ConstraintSystem pLocalConstraintSystem) {
        ConstraintSystem result = new ConstraintSystem(this);
        result.baseConstraints.addAll(pLocalConstraintSystem.baseConstraints);
        result.simpleConstraints.addAll(pLocalConstraintSystem.simpleConstraints);
        result.complexConstraints.addAll(pLocalConstraintSystem.complexConstraints);
        return result;
    }
}

