/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron;

import apron.Abstract0;
import apron.ApronException;
import java.util.HashMap;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.util.Pair;

class ApronDomain
implements AbstractDomain {
    private final LogManager logger;

    public ApronDomain(LogManager log) {
        this.logger = log;
    }

    @Override
    public boolean isLessOrEqual(AbstractState element1, AbstractState element2) {
        HashMap covers = new HashMap();
        ApronState apronState1 = (ApronState)element1;
        ApronState apronState2 = (ApronState)element2;
        if (covers.containsKey(apronState2) && ((Set)covers.get(apronState2)).contains(apronState1)) {
            return true;
        }
        try {
            return apronState1.isLessOrEquals(apronState2);
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
    }

    @Override
    public AbstractState join(AbstractState successor, AbstractState reached) {
        Abstract0 newApronState;
        ApronState firstState;
        Pair<ApronState, ApronState> shrinkedStates;
        try {
            shrinkedStates = this.getShrinkedStates((ApronState)successor, (ApronState)reached);
            firstState = shrinkedStates.getFirst();
            newApronState = firstState.getApronNativeState().joinCopy(firstState.getManager().getManager(), shrinkedStates.getSecond().getApronNativeState());
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
        ApronState newState = new ApronState(newApronState, firstState.getManager(), shrinkedStates.getFirst().getIntegerVariableToIndexMap(), shrinkedStates.getFirst().getRealVariableToIndexMap(), shrinkedStates.getFirst().getVariableToTypeMap(), ((ApronState)successor).isLoopHead(), this.logger);
        if (newState.equals(reached)) {
            return reached;
        }
        if (newState.equals(successor)) {
            return successor;
        }
        return newState;
    }

    public AbstractState widening(ApronState successorState, ApronState reachedState) {
        Abstract0 newApronState;
        try {
            Pair<ApronState, ApronState> shrinkedStates = this.getShrinkedStates(successorState, reachedState);
            successorState = shrinkedStates.getFirst();
            reachedState = shrinkedStates.getSecond();
            newApronState = reachedState.getApronNativeState().widening(reachedState.getManager().getManager(), successorState.getApronNativeState());
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occured while operating with the apron library", e);
        }
        ApronState newState = new ApronState(newApronState, reachedState.getManager(), successorState.getIntegerVariableToIndexMap(), successorState.getRealVariableToIndexMap(), successorState.getVariableToTypeMap(), successorState.isLoopHead(), this.logger);
        if (newState.equals(successorState)) {
            return successorState;
        }
        if (newState.equals(reachedState)) {
            return reachedState;
        }
        return newState;
    }

    private Pair<ApronState, ApronState> getShrinkedStates(ApronState succ, ApronState reached) throws ApronException {
        if (succ.sizeOfVariables() > reached.sizeOfVariables()) {
            Pair<ApronState, ApronState> tmp = succ.shrinkToFittingSize(reached);
            succ = tmp.getFirst();
            reached = tmp.getSecond();
        } else {
            Pair<ApronState, ApronState> tmp = reached.shrinkToFittingSize(succ);
            succ = tmp.getSecond();
            reached = tmp.getFirst();
        }
        return Pair.of(succ, reached);
    }
}

