/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron;

import java.util.Objects;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.apron.ApronDomain;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="cpa.apron.mergeop")
public class ApronMergeOperator {
    private final ApronDomain domain;
    @Option(secure=true, name="type", toUppercase=true, values={"SEP", "JOIN", "WIDENING"}, description="of which type should the merge be?")
    private String type = "SEP";
    @Option(secure=true, name="onlyMergeAtLoopHeads", description="with this option enabled the states are only merged at loop heads")
    private boolean onlyMergeAtLoopHeads = false;

    public static MergeOperator getInstance(ApronDomain domain, Configuration config) throws InvalidConfigurationException {
        ApronMergeOperator mergeOp = new ApronMergeOperator(domain, config);
        switch (mergeOp.type) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "JOIN": {
                ApronMergeOperator apronMergeOperator = mergeOp;
                Objects.requireNonNull(apronMergeOperator);
                return apronMergeOperator.new ApronMergeJoinOperator(domain, config);
            }
            case "WIDENING": {
                ApronMergeOperator apronMergeOperator = mergeOp;
                Objects.requireNonNull(apronMergeOperator);
                return apronMergeOperator.new ApronMergeWideningOperator(domain, config);
            }
        }
        throw new InvalidConfigurationException("Unknown type for merge operator");
    }

    private ApronMergeOperator(ApronDomain domain, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.domain = domain;
    }

    @Options(prefix="cpa.apron.mergeop")
    class ApronMergeWideningOperator
    extends ApronMergeOperator
    implements MergeOperator {
        private ApronMergeWideningOperator(ApronDomain domain, Configuration config) throws InvalidConfigurationException {
            super(domain, config);
        }

        @Override
        public AbstractState merge(AbstractState el1, AbstractState el2, Precision p) throws CPAException {
            if (!(!ApronMergeOperator.this.onlyMergeAtLoopHeads || ((ApronState)el1).isLoopHead() && ((ApronState)el2).isLoopHead())) {
                return el2;
            }
            return ApronMergeOperator.this.domain.widening((ApronState)el1, (ApronState)el2);
        }
    }

    @Options(prefix="cpa.apron.mergeop")
    class ApronMergeJoinOperator
    extends ApronMergeOperator
    implements MergeOperator {
        private ApronMergeJoinOperator(ApronDomain domain, Configuration config) throws InvalidConfigurationException {
            super(domain, config);
        }

        @Override
        public AbstractState merge(AbstractState el1, AbstractState el2, Precision p) throws CPAException {
            if (!(!ApronMergeOperator.this.onlyMergeAtLoopHeads || ((ApronState)el1).isLoopHead() && ((ApronState)el2).isLoopHead())) {
                return el2;
            }
            return ApronMergeOperator.this.domain.join(el1, el2);
        }
    }
}

