/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron;

import apron.Abstract0;
import apron.Dimchange;
import apron.Dimension;
import apron.DoubleScalar;
import apron.Interval;
import apron.Lincons0;
import apron.Linexpr0;
import apron.Manager;
import apron.MpfrScalar;
import apron.MpqScalar;
import apron.Scalar;
import apron.Tcons0;
import apron.Texpr0BinNode;
import apron.Texpr0CstNode;
import apron.Texpr0DimNode;
import apron.Texpr0Intern;
import apron.Texpr0Node;
import apron.Texpr0UnNode;
import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.util.ApronManager;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.smt.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;

public class ApronState
implements AbstractState,
Serializable,
FormulaReportingState {
    private static final long serialVersionUID = -7953805400649927048L;
    private transient Abstract0 apronState;
    private transient ApronManager apronManager;
    private List<MemoryLocation> integerToIndexMap;
    private List<MemoryLocation> realToIndexMap;
    private Map<MemoryLocation, Type> variableToTypeMap;
    private final boolean isLoopHead;
    private transient LogManager logger;

    public ApronState(LogManager log, ApronManager manager) {
        this.apronManager = manager;
        this.apronState = new Abstract0(this.apronManager.getManager(), 0, 0);
        this.logger = log;
        this.logger.log(Level.FINEST, new Object[]{"initial apron state"});
        this.integerToIndexMap = new ArrayList<MemoryLocation>();
        this.realToIndexMap = new ArrayList<MemoryLocation>();
        this.variableToTypeMap = new HashMap<MemoryLocation, Type>();
        this.isLoopHead = false;
    }

    public ApronState(Abstract0 apronNativeState, ApronManager manager, List<MemoryLocation> intMap, List<MemoryLocation> realMap, Map<MemoryLocation, Type> typeMap, boolean pIsLoopHead, LogManager log) {
        this.apronState = apronNativeState;
        this.apronManager = manager;
        this.integerToIndexMap = intMap;
        this.realToIndexMap = realMap;
        this.variableToTypeMap = typeMap;
        this.isLoopHead = pIsLoopHead;
        this.logger = log;
    }

    public boolean isLoopHead() {
        return this.isLoopHead;
    }

    public ApronState asLoopHead() {
        return new ApronState(this.apronState, this.apronManager, this.integerToIndexMap, this.realToIndexMap, this.variableToTypeMap, this.isLoopHead, this.logger);
    }

    @Override
    public boolean equals(Object pObj) {
        if (!(pObj instanceof ApronState)) {
            return false;
        }
        ApronState otherApron = (ApronState)pObj;
        this.logger.log(Level.FINEST, new Object[]{"apron state: isEqual"});
        return Objects.equals(this.integerToIndexMap, otherApron.integerToIndexMap) && Objects.equals(this.realToIndexMap, otherApron.realToIndexMap) && this.apronState.isEqual(this.apronManager.getManager(), otherApron.apronState) && this.isLoopHead == otherApron.isLoopHead;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Objects.hashCode(this.integerToIndexMap);
        result = 31 * result + Objects.hash(this.realToIndexMap);
        result = 31 * result + Objects.hashCode(this.variableToTypeMap);
        result = 31 * result + Objects.hash(this.isLoopHead);
        return result;
    }

    protected boolean isLessOrEquals(ApronState state) {
        assert (!this.isEmpty()) : "Empty states should not occur here!";
        if (Objects.equals(this.integerToIndexMap, state.integerToIndexMap) && Objects.equals(this.realToIndexMap, state.realToIndexMap)) {
            this.logger.log(Level.FINEST, new Object[]{"apron state: isIncluded"});
            return this.apronState.isIncluded(this.apronManager.getManager(), state.apronState);
        }
        this.logger.log(Level.FINEST, new Object[]{"Removing some temporary (in the transferrelation) introduced variables from the Abstract0 to compute #isLessOrEquals()"});
        if (this.integerToIndexMap.containsAll(state.integerToIndexMap) && this.realToIndexMap.containsAll(state.realToIndexMap)) {
            this.logger.log(Level.FINEST, new Object[]{"apron state: isIncluded"});
            return this.forgetVars(state).isIncluded(this.apronManager.getManager(), state.apronState);
        }
        return false;
    }

    private Abstract0 forgetVars(ApronState pConsiderSubsetOfVars) {
        int indexThis;
        int amountInts = this.integerToIndexMap.size() - pConsiderSubsetOfVars.integerToIndexMap.size();
        int[] removeDim = new int[amountInts + this.realToIndexMap.size() - pConsiderSubsetOfVars.realToIndexMap.size()];
        int arrayPos = 0;
        int indexParam = 0;
        for (indexThis = 0; indexThis < this.integerToIndexMap.size(); ++indexThis) {
            if (indexParam < pConsiderSubsetOfVars.integerToIndexMap.size() && this.integerToIndexMap.get(indexThis).equals(pConsiderSubsetOfVars.integerToIndexMap.get(indexParam))) {
                ++indexParam;
                continue;
            }
            removeDim[arrayPos] = indexThis;
            ++arrayPos;
        }
        indexParam = 0;
        for (indexThis = 0; indexThis < this.realToIndexMap.size(); ++indexThis) {
            if (indexParam < pConsiderSubsetOfVars.realToIndexMap.size() && this.realToIndexMap.get(indexThis).equals(pConsiderSubsetOfVars.realToIndexMap.get(indexParam))) {
                ++indexParam;
                continue;
            }
            removeDim[arrayPos] = indexThis;
            ++arrayPos;
        }
        return this.apronState.removeDimensionsCopy(this.apronManager.getManager(), new Dimchange(amountInts, removeDim.length - amountInts, removeDim));
    }

    public Pair<ApronState, ApronState> shrinkToFittingSize(ApronState oldState) {
        ApronState newState2;
        ApronState newState1;
        int maxEqualRealIndex;
        int maxEqualIntIndex;
        for (maxEqualIntIndex = 0; maxEqualIntIndex < this.integerToIndexMap.size() && this.integerToIndexMap.get(maxEqualIntIndex).equals(this.integerToIndexMap.get(maxEqualIntIndex)); ++maxEqualIntIndex) {
        }
        for (maxEqualRealIndex = 0; maxEqualRealIndex < this.realToIndexMap.size() && this.realToIndexMap.get(maxEqualRealIndex).equals(this.realToIndexMap.get(maxEqualRealIndex)); ++maxEqualRealIndex) {
        }
        if (this.variableToTypeMap.size() != maxEqualIntIndex + maxEqualRealIndex) {
            int index;
            int i;
            List<MemoryLocation> newIntMap1 = this.integerToIndexMap.subList(0, maxEqualIntIndex);
            List<MemoryLocation> newRealMap1 = this.realToIndexMap.subList(0, maxEqualRealIndex);
            HashMap<MemoryLocation, Type> newTypeMap1 = new HashMap<MemoryLocation, Type>(this.variableToTypeMap);
            int amountRemoved = this.variableToTypeMap.size() - (maxEqualIntIndex + maxEqualRealIndex);
            int[] placesRemoved = new int[amountRemoved];
            int amountInts = this.integerToIndexMap.size() - maxEqualIntIndex;
            int amountReals = this.realToIndexMap.size() - maxEqualRealIndex;
            for (i = 0; i < amountInts; ++i) {
                placesRemoved[i] = index = this.integerToIndexMap.size() - (amountInts - i);
                newTypeMap1.remove(this.integerToIndexMap.get(index));
            }
            for (i = amountInts; i < placesRemoved.length; ++i) {
                placesRemoved[i] = index = placesRemoved.length - (amountReals - i);
                newTypeMap1.remove(this.realToIndexMap.get(index - amountInts));
            }
            this.logger.log(Level.FINEST, new Object[]{"apron state: removeDimensionCopy: " + new Dimchange(amountInts, amountReals, placesRemoved)});
            Abstract0 newApronState1 = this.apronState.removeDimensionsCopy(this.apronManager.getManager(), new Dimchange(amountInts, amountReals, placesRemoved));
            newState1 = new ApronState(newApronState1, this.apronManager, newIntMap1, newRealMap1, newTypeMap1, this.isLoopHead, this.logger);
        } else {
            newState1 = this;
        }
        if (oldState.variableToTypeMap.size() != maxEqualIntIndex + maxEqualRealIndex) {
            int index;
            int i;
            List<MemoryLocation> newIntMap2 = this.integerToIndexMap.subList(0, maxEqualIntIndex);
            List<MemoryLocation> newRealMap2 = this.realToIndexMap.subList(0, maxEqualRealIndex);
            HashMap<MemoryLocation, Type> newTypeMap2 = new HashMap<MemoryLocation, Type>(this.variableToTypeMap);
            int amountRemoved = oldState.variableToTypeMap.size() - (maxEqualIntIndex + maxEqualRealIndex);
            int[] placesRemoved = new int[amountRemoved];
            int amountInts = oldState.integerToIndexMap.size() - maxEqualIntIndex;
            int amountReals = oldState.realToIndexMap.size() - maxEqualRealIndex;
            for (i = 0; i < amountInts; ++i) {
                placesRemoved[i] = index = oldState.integerToIndexMap.size() - (amountInts - i);
                newTypeMap2.remove(oldState.integerToIndexMap.get(index));
            }
            for (i = amountInts; i < placesRemoved.length; ++i) {
                placesRemoved[i] = index = placesRemoved.length - (amountReals - i);
                newTypeMap2.remove(oldState.realToIndexMap.get(index - amountInts));
            }
            this.logger.log(Level.FINEST, new Object[]{"apron state: removeDimensionCopy: " + new Dimchange(amountInts, amountReals, placesRemoved)});
            Abstract0 newApronState2 = oldState.apronState.removeDimensionsCopy(oldState.apronManager.getManager(), new Dimchange(amountInts, amountReals, placesRemoved));
            newState2 = new ApronState(newApronState2, oldState.apronManager, newIntMap2, newRealMap2, newTypeMap2, this.isLoopHead, this.logger);
        } else {
            newState2 = oldState;
        }
        return Pair.of(newState1, newState2);
    }

    @Override
    public String toString() {
        this.logger.log(Level.FINEST, new Object[]{"apron state: toString"});
        return this.apronState.toString(this.apronManager.getManager());
    }

    public boolean satisfies(Tcons0 cons) {
        this.logger.log(Level.FINEST, new Object[]{"apron state: satisfy: " + cons});
        return this.apronState.satisfy(this.apronManager.getManager(), cons);
    }

    public Abstract0 getApronNativeState() {
        return this.apronState;
    }

    public ApronManager getManager() {
        return this.apronManager;
    }

    public int sizeOfVariables() {
        return this.variableToTypeMap.size();
    }

    public List<MemoryLocation> getIntegerVariableToIndexMap() {
        return this.integerToIndexMap;
    }

    public List<MemoryLocation> getRealVariableToIndexMap() {
        return this.realToIndexMap;
    }

    public Map<MemoryLocation, Type> getVariableToTypeMap() {
        return this.variableToTypeMap;
    }

    public boolean isEmpty() {
        this.logger.log(Level.FINEST, new Object[]{"apron state: isBottom"});
        return this.apronState.isBottom(this.apronManager.getManager());
    }

    public ApronState forget(MemoryLocation pVariableName) {
        int varIdx = this.getVariableIndexFor(pVariableName);
        if (varIdx == -1) {
            return this;
        }
        this.logger.log(Level.FINEST, new Object[]{"apron state: forgetCopy: " + pVariableName});
        return new ApronState(this.apronState.forgetCopy(this.apronManager.getManager(), varIdx, false), this.apronManager, new ArrayList<MemoryLocation>(this.integerToIndexMap), new ArrayList<MemoryLocation>(this.realToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), false, this.logger);
    }

    protected int getVariableIndexFor(MemoryLocation pVariableName) {
        int counter;
        if (this.integerToIndexMap.contains(pVariableName)) {
            counter = 0;
            for (MemoryLocation str : this.integerToIndexMap) {
                if (str.equals(pVariableName)) {
                    return counter;
                }
                ++counter;
            }
        }
        if (this.realToIndexMap.contains(pVariableName)) {
            counter = 0;
            for (MemoryLocation str : this.realToIndexMap) {
                if (str.equals(pVariableName)) {
                    return counter + this.integerToIndexMap.size();
                }
                ++counter;
            }
        }
        return -1;
    }

    protected boolean isInt(int index) {
        return index < this.integerToIndexMap.size();
    }

    protected boolean existsVariable(MemoryLocation variableName) {
        return this.integerToIndexMap.contains(variableName) || this.realToIndexMap.contains(variableName);
    }

    public ApronState declareVariable(MemoryLocation varName, Type type) {
        Dimchange dimch;
        assert (!this.existsVariable(varName));
        int[] addPlace = new int[1];
        if (type == Type.INT) {
            addPlace[0] = this.integerToIndexMap.size();
            dimch = new Dimchange(1, 0, addPlace);
        } else {
            addPlace[0] = this.integerToIndexMap.size() + this.realToIndexMap.size();
            dimch = new Dimchange(0, 1, addPlace);
        }
        this.logger.log(Level.FINEST, new Object[]{"apron state: addDimensionCopy: " + varName + " " + dimch});
        ApronState newState = new ApronState(this.apronState.addDimensionsCopy(this.apronManager.getManager(), dimch, false), this.apronManager, new ArrayList<MemoryLocation>(this.integerToIndexMap), new ArrayList<MemoryLocation>(this.realToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), false, this.logger);
        if (type == Type.INT) {
            newState.integerToIndexMap.add(varName);
        } else {
            newState.realToIndexMap.add(varName);
        }
        newState.variableToTypeMap.put(varName, type);
        return newState;
    }

    public ApronState makeAssignment(MemoryLocation leftVarName, Linexpr0 assignment) {
        int varIndex = this.getVariableIndexFor(leftVarName);
        if (varIndex == -1) {
            return this;
        }
        if (assignment != null) {
            this.logger.log(Level.FINEST, new Object[]{"apron state: assignCopy: " + leftVarName + " = " + assignment});
            return new ApronState(this.apronState.assignCopy(this.apronManager.getManager(), varIndex, assignment, null), this.apronManager, this.integerToIndexMap, this.realToIndexMap, this.variableToTypeMap, false, this.logger);
        }
        return this.forget(leftVarName);
    }

    public ApronState makeAssignment(MemoryLocation leftVarName, Texpr0Node assignment) {
        return this.makeAssignment(leftVarName, new Texpr0Intern(assignment));
    }

    public ApronState makeAssignment(MemoryLocation leftVarName, Texpr0Intern assignment) {
        int varIndex = this.getVariableIndexFor(leftVarName);
        if (varIndex == -1) {
            return this;
        }
        if (assignment != null) {
            this.logger.log(Level.FINEST, new Object[]{"apron state: assignCopy: " + leftVarName + " = " + assignment});
            Abstract0 retState = this.apronState.assignCopy(this.apronManager.getManager(), varIndex, assignment, null);
            if (retState == null) {
                this.logger.log(Level.WARNING, new Object[]{"Assignment of expression to variable yielded an empty state, forgetting the value of the variable as fallback."});
                return this.forget(leftVarName);
            }
            return new ApronState(retState, this.apronManager, this.integerToIndexMap, this.realToIndexMap, this.variableToTypeMap, false, this.logger);
        }
        return this.forget(leftVarName);
    }

    public ApronState addConstraint(Lincons0 constraint) {
        this.logger.log(Level.FINEST, new Object[]{"apron state: meetCopy: " + constraint});
        return new ApronState(this.apronState.meetCopy(this.apronManager.getManager(), constraint), this.apronManager, this.integerToIndexMap, this.realToIndexMap, this.variableToTypeMap, false, this.logger);
    }

    public ApronState addConstraint(Tcons0 constraint) {
        this.logger.log(Level.FINEST, new Object[]{"apron state: meetCopy: " + constraint});
        return new ApronState(this.apronState.meetCopy(this.apronManager.getManager(), constraint), this.apronManager, this.integerToIndexMap, this.realToIndexMap, this.variableToTypeMap, false, this.logger);
    }

    public ApronState removeLocalVars(String functionName) {
        return this.removeVars(functionName + "::");
    }

    public Map<MemoryLocation, Interval> getVariablesWithBounds() {
        this.logger.log(Level.FINEST, new Object[]{"apron state: getBounds"});
        HashMap<MemoryLocation, Interval> vars = new HashMap<MemoryLocation, Interval>();
        for (MemoryLocation varName : this.integerToIndexMap) {
            vars.put(varName, this.apronState.getBound(this.apronManager.getManager(), this.getVariableIndexFor(varName)));
        }
        for (MemoryLocation varName : this.realToIndexMap) {
            vars.put(varName, this.apronState.getBound(this.apronManager.getManager(), this.getVariableIndexFor(varName)));
        }
        return vars;
    }

    private ApronState removeVars(String varPrefix) {
        ArrayList<MemoryLocation> keysToRemove = new ArrayList<MemoryLocation>();
        int intsRemoved = 0;
        for (MemoryLocation memoryLocation : this.integerToIndexMap) {
            if (!memoryLocation.getExtendedQualifiedName().startsWith(varPrefix)) continue;
            keysToRemove.add(memoryLocation);
            ++intsRemoved;
        }
        int realsRemoved = 0;
        for (MemoryLocation var : this.realToIndexMap) {
            if (!var.getExtendedQualifiedName().startsWith(varPrefix)) continue;
            keysToRemove.add(var);
            ++realsRemoved;
        }
        if (keysToRemove.isEmpty()) {
            return this;
        }
        int[] nArray = new int[keysToRemove.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getVariableIndexFor((MemoryLocation)keysToRemove.get(i));
        }
        this.logger.log(Level.FINEST, new Object[]{"apron state: removeDimensionCopy: " + new Dimchange(intsRemoved, realsRemoved, nArray)});
        ApronState newState = new ApronState(this.apronState.removeDimensionsCopy(this.apronManager.getManager(), new Dimchange(intsRemoved, realsRemoved, nArray)), this.apronManager, new ArrayList<MemoryLocation>(this.integerToIndexMap), new ArrayList<MemoryLocation>(this.realToIndexMap), new HashMap<MemoryLocation, Type>(this.variableToTypeMap), false, this.logger);
        newState.integerToIndexMap.removeAll(keysToRemove);
        newState.realToIndexMap.removeAll(keysToRemove);
        newState.variableToTypeMap.keySet().removeAll(keysToRemove);
        this.logger.log(Level.FINEST, new Object[]{"apron state: getDimension"});
        Dimension dim = newState.apronState.getDimension(this.apronManager.getManager());
        assert (dim.intDim + dim.realDim == newState.sizeOfVariables());
        return newState;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        byte[] serialized = this.apronState.serialize(this.apronManager.getManager());
        out.writeInt(serialized.length);
        out.write(serialized);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.logger = GlobalInfo.getInstance().getApronLogManager();
        this.apronManager = GlobalInfo.getInstance().getApronManager();
        byte[] deserialized = new byte[in.readInt()];
        in.readFully(deserialized);
        this.apronState = Abstract0.deserialize((Manager)this.apronManager.getManager(), (byte[])deserialized);
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView pManager) {
        BitvectorFormulaManagerView bitFmgr = pManager.getBitvectorFormulaManager();
        BooleanFormulaManagerView bFmgr = pManager.getBooleanFormulaManager();
        Tcons0[] constraints = this.apronState.toTcons(this.apronManager.getManager());
        return bFmgr.and(Lists.transform(Arrays.asList(constraints), cons -> this.createFormula(bFmgr, bitFmgr, (Tcons0)cons)));
    }

    private BooleanFormula createFormula(BooleanFormulaManager bFmgr, BitvectorFormulaManager bitFmgr, Tcons0 constraint) {
        Texpr0Node tree = constraint.toTexpr0Node();
        BitvectorFormula formula = (BitvectorFormula)new Texpr0ToFormulaVisitor(bitFmgr).visit(tree);
        BitvectorFormula rightHandside = bitFmgr.makeBitvector(32, 0L);
        switch (constraint.kind) {
            case 4: {
                return bFmgr.not(bitFmgr.equal(formula, rightHandside));
            }
            case 0: {
                return bitFmgr.equal(formula, rightHandside);
            }
            case 2: {
                return bitFmgr.greaterThan(formula, rightHandside, true);
            }
            case 1: {
                return bitFmgr.greaterOrEquals(formula, rightHandside, true);
            }
        }
        throw new AssertionError((Object)"unhandled constraint kind");
    }

    class Texpr0ToFormulaVisitor
    extends Texpr0NodeTraversal<BitvectorFormula> {
        BitvectorFormulaManager bitFmgr;

        public Texpr0ToFormulaVisitor(BitvectorFormulaManager pBitFmgr) {
            this.bitFmgr = pBitFmgr;
        }

        @Override
        BitvectorFormula visit(Texpr0BinNode pNode) {
            BitvectorFormula left = (BitvectorFormula)this.visit(pNode.getLeftArgument());
            BitvectorFormula right = (BitvectorFormula)this.visit(pNode.getRightArgument());
            switch (pNode.getOperation()) {
                case 0: {
                    return this.bitFmgr.add(left, right);
                }
                case 3: {
                    return this.bitFmgr.divide(left, right, true);
                }
                case 4: {
                    return this.bitFmgr.modulo(left, right, true);
                }
                case 1: {
                    return this.bitFmgr.subtract(left, right);
                }
                case 2: {
                    return this.bitFmgr.multiply(left, right);
                }
                case 5: {
                    throw new AssertionError((Object)"Pow not implemented in this visitor");
                }
            }
            throw new AssertionError((Object)"Unhandled operator for binary nodes.");
        }

        @Override
        BitvectorFormula visit(Texpr0CstNode pNode) {
            if (pNode.isScalar()) {
                double value;
                Scalar scalar = pNode.getConstant().inf();
                if (scalar instanceof DoubleScalar) {
                    value = ((DoubleScalar)scalar).get();
                } else if (scalar instanceof MpqScalar) {
                    value = ((MpqScalar)scalar).get().doubleValue();
                } else if (scalar instanceof MpfrScalar) {
                    value = ((MpfrScalar)scalar).get().doubleValue(0);
                } else {
                    throw new AssertionError((Object)("Unhandled Scalar subclass: " + scalar.getClass()));
                }
                if (DoubleMath.isMathematicalInteger((double)value)) {
                    return this.bitFmgr.makeBitvector(32, (long)((int)value));
                }
                throw new AssertionError((Object)"Floats are currently not handled");
            }
            throw new AssertionError((Object)"Intervals are currently not handled");
        }

        @Override
        BitvectorFormula visit(Texpr0DimNode pNode) {
            if (ApronState.this.isInt(pNode.dim)) {
                return this.bitFmgr.makeVariable(32, ApronState.this.integerToIndexMap.get(pNode.dim).getExtendedQualifiedName());
            }
            return this.bitFmgr.makeVariable(32, ApronState.this.realToIndexMap.get(pNode.dim - ApronState.this.integerToIndexMap.size()).getExtendedQualifiedName());
        }

        @Override
        BitvectorFormula visit(Texpr0UnNode pNode) {
            BitvectorFormula operand = (BitvectorFormula)this.visit(pNode.getArgument());
            switch (pNode.getOperation()) {
                case 6: {
                    return this.bitFmgr.negate(operand);
                }
                case 8: {
                    throw new AssertionError((Object)"sqrt not implemented in this visitor");
                }
            }
            return operand;
        }
    }

    static abstract class Texpr0NodeTraversal<T> {
        Texpr0NodeTraversal() {
        }

        T visit(Texpr0Node node) {
            if (node instanceof Texpr0BinNode) {
                return this.visit((Texpr0BinNode)node);
            }
            if (node instanceof Texpr0CstNode) {
                return this.visit((Texpr0CstNode)node);
            }
            if (node instanceof Texpr0DimNode) {
                return this.visit((Texpr0DimNode)node);
            }
            if (node instanceof Texpr0UnNode) {
                return this.visit((Texpr0UnNode)node);
            }
            throw new AssertionError((Object)"Unhandled Texpr0Node subclass.");
        }

        abstract T visit(Texpr0BinNode var1);

        abstract T visit(Texpr0CstNode var1);

        abstract T visit(Texpr0DimNode var1);

        abstract T visit(Texpr0UnNode var1);
    }

    static enum Type {
        INT,
        FLOAT;

    }
}

