/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron.refiner;

import apron.ApronException;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.apron.ApronCPA;
import org.sosy_lab.cpachecker.cpa.apron.ApronState;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.octagon.refiner.OctagonAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.ApronManager;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.WalltimeLimit;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

@Options(prefix="cpa.apron.refiner")
class ApronARGBasedDelegatingRefiner
implements ARGBasedRefiner,
Statistics,
StatisticsProvider {
    private final ValueAnalysisPathInterpolator interpolatingRefiner;
    private final FeasibilityChecker<ValueAnalysisState> valueAnalysisChecker;
    private int previousErrorPathID = -1;
    @Option(secure=true, description="Timelimit for the backup feasibility check with the apron analysis.(use seconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
    private TimeSpan timeForApronFeasibilityCheck = TimeSpan.ofNanos((long)0L);
    private int numberOfValueAnalysisRefinements = 0;
    private int numberOfSuccessfulValueAnalysisRefinements = 0;
    private boolean existsExplicitApronRefinement = false;
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final ApronManager apronManager;
    private final TransferRelation apronTransfer;

    ApronARGBasedDelegatingRefiner(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, ApronManager pApronManager, TransferRelation pApronTransfer, FeasibilityChecker<ValueAnalysisState> pValueAnalysisFeasibilityChecker, ValueAnalysisPathInterpolator pValueAnalysisPathInterpolator) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.apronManager = pApronManager;
        this.apronTransfer = pApronTransfer;
        this.valueAnalysisChecker = pValueAnalysisFeasibilityChecker;
        this.interpolatingRefiner = pValueAnalysisPathInterpolator;
    }

    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet reached, ARGPath pErrorPath) throws CPAException, InterruptedException {
        OctagonAnalysisFeasibilityChecker apronChecker;
        if (!this.isPathFeasible(pErrorPath) && !this.existsExplicitApronRefinement && this.performValueAnalysisRefinement(reached, pErrorPath)) {
            return CounterexampleInfo.spurious();
        }
        try {
            apronChecker = this.createApronFeasibilityChecker(pErrorPath);
        }
        catch (ApronException e) {
            throw new RuntimeException("An error occurred while operating with the apron library", e);
        }
        if (!apronChecker.isFeasible() && this.performApronAnalysisRefinement(reached, apronChecker)) {
            this.existsExplicitApronRefinement = true;
            return CounterexampleInfo.spurious();
        }
        return CounterexampleInfo.feasibleImprecise(pErrorPath);
    }

    private boolean performValueAnalysisRefinement(ARGReachedSet reached, ARGPath errorPath) throws CPAException, InterruptedException {
        ++this.numberOfValueAnalysisRefinements;
        UnmodifiableReachedSet reachedSet = reached.asReachedSet();
        Precision precision = reachedSet.getPrecision(reachedSet.getLastState());
        VariableTrackingPrecision apronPrecision = (VariableTrackingPrecision)Precisions.asIterable(precision).filter(VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class)).get(0);
        Multimap<CFANode, MemoryLocation> increment = this.interpolatingRefiner.determinePrecisionIncrement(errorPath);
        Pair<ARGState, CFAEdge> refinementRoot = this.interpolatingRefiner.determineRefinementRoot(errorPath, increment);
        if (increment.isEmpty()) {
            return false;
        }
        VariableTrackingPrecision refinedApronPrecision = apronPrecision.withIncrement(increment);
        if (this.valueAnalysisRefinementWasSuccessful(errorPath, apronPrecision, refinedApronPrecision)) {
            ++this.numberOfSuccessfulValueAnalysisRefinements;
            reached.removeSubtree(refinementRoot.getFirst(), refinedApronPrecision, VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class));
            return true;
        }
        return false;
    }

    private boolean performApronAnalysisRefinement(ARGReachedSet reached, OctagonAnalysisFeasibilityChecker checker) throws InterruptedException {
        UnmodifiableReachedSet reachedSet = reached.asReachedSet();
        Precision precision = reachedSet.getPrecision(reachedSet.getLastState());
        VariableTrackingPrecision apronPrecision = (VariableTrackingPrecision)Precisions.asIterable(precision).filter(VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class)).get(0);
        Multimap<CFANode, MemoryLocation> increment = checker.getPrecisionIncrement();
        if (increment.isEmpty()) {
            // empty if block
        }
        reached.removeSubtree(((ARGState)reachedSet.getFirstState()).getChildren().iterator().next(), apronPrecision.withIncrement(increment), VariableTrackingPrecision.isMatchingCPAClass(ApronCPA.class));
        this.logger.log(Level.INFO, new Object[]{"Refinement successful, precision incremented, following variables are now tracked additionally:\n" + new TreeSet(increment.values())});
        return true;
    }

    private boolean valueAnalysisRefinementWasSuccessful(ARGPath errorPath, VariableTrackingPrecision valueAnalysisPrecision, VariableTrackingPrecision refinedValueAnalysisPrecision) {
        boolean success = errorPath.toString().hashCode() != this.previousErrorPathID || refinedValueAnalysisPrecision.getSize() > valueAnalysisPrecision.getSize();
        this.previousErrorPathID = errorPath.toString().hashCode();
        return success;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this);
        pStatsCollection.add(this.interpolatingRefiner);
    }

    @Override
    public String getName() {
        return "ApronAnalysisDelegatingRefiner";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        out.println("  number of value analysis refinements:                " + this.numberOfValueAnalysisRefinements);
        out.println("  number of successful valueAnalysis refinements:      " + this.numberOfSuccessfulValueAnalysisRefinements);
    }

    boolean isPathFeasible(ARGPath path) throws CPAException, InterruptedException {
        return this.valueAnalysisChecker.isFeasible(path);
    }

    private OctagonAnalysisFeasibilityChecker createApronFeasibilityChecker(ARGPath path) throws CPAException, ApronException, InterruptedException {
        try {
            OctagonAnalysisFeasibilityChecker checker;
            if (this.timeForApronFeasibilityCheck.isEmpty()) {
                checker = new OctagonAnalysisFeasibilityChecker(this.config, this.shutdownNotifier, path, ApronCPA.class, this.cfa.getVarClassification(), this.apronTransfer, new ApronState(this.logger, this.apronManager));
            } else {
                ShutdownManager shutdown = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
                WalltimeLimit l = WalltimeLimit.fromNowOn(this.timeForApronFeasibilityCheck);
                ResourceLimitChecker limits = new ResourceLimitChecker(shutdown, Collections.singletonList(l));
                limits.start();
                checker = new OctagonAnalysisFeasibilityChecker(this.config, shutdown.getNotifier(), path, ApronCPA.class, this.cfa.getVarClassification(), this.apronTransfer, new ApronState(this.logger, this.apronManager));
                limits.cancel();
            }
            return checker;
        }
        catch (InvalidConfigurationException e) {
            throw new CPAException("counterexample-check failed: ", e);
        }
    }
}

