/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.apron.refiner;

import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.cpa.apron.ApronCPA;
import org.sosy_lab.cpachecker.cpa.apron.refiner.ApronARGBasedDelegatingRefiner;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisPrefixProvider;
import org.sosy_lab.cpachecker.util.CPAs;

public abstract class ApronDelegatingRefiner
implements Refiner {
    public static Refiner create(ConfigurableProgramAnalysis cpa) throws InvalidConfigurationException {
        ApronCPA apronCPA = CPAs.retrieveCPAOrFail(cpa, ApronCPA.class, ApronDelegatingRefiner.class);
        Configuration config = apronCPA.getConfiguration();
        LogManager logger = apronCPA.getLogger();
        ShutdownNotifier shutdownNotifier = apronCPA.getShutdownNotifier();
        CFA cfa = apronCPA.getCFA();
        ValueAnalysisStrongestPostOperator strongestPostOp = new ValueAnalysisStrongestPostOperator(logger, Configuration.defaultConfiguration(), cfa);
        ValueAnalysisFeasibilityChecker feasibilityChecker = new ValueAnalysisFeasibilityChecker(strongestPostOp, logger, cfa, config);
        ValueAnalysisPathInterpolator interpolatingRefiner = new ValueAnalysisPathInterpolator(feasibilityChecker, strongestPostOp, new ValueAnalysisPrefixProvider(logger, cfa, config, shutdownNotifier), config, logger, shutdownNotifier, cfa);
        ApronARGBasedDelegatingRefiner refiner = new ApronARGBasedDelegatingRefiner(config, logger, shutdownNotifier, cfa, apronCPA.getManager(), apronCPA.getTransferRelation(), feasibilityChecker, interpolatingRefiner);
        return AbstractARGBasedRefiner.forARGBasedRefiner(refiner, cpa);
    }
}

