/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.blocks.BlockPartitioning;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.NoOpReducer;
import org.sosy_lab.cpachecker.core.defaults.SimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCoveringStopOperator;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoin;
import org.sosy_lab.cpachecker.cpa.arg.ARGMergeJoinCPAEnabledAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.arg.ARGReducer;
import org.sosy_lab.cpachecker.cpa.arg.ARGSimplePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGStatistics;
import org.sosy_lab.cpachecker.cpa.arg.ARGStopSep;
import org.sosy_lab.cpachecker.cpa.arg.ARGTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="cpa.arg")
public class ARGCPA
extends AbstractSingleWrapperCPA
implements ConfigurableProgramAnalysisWithBAM,
ProofChecker {
    @Option(secure=true, description="inform ARG CPA if it is run in an analysis with enabler CPA because then it must behave differently during merge.")
    private boolean inCPAEnabledAnalysis = false;
    @Option(secure=true, description="inform merge operator in CPA enabled analysis that it should delete the subgraph of the merged node which is required to get at most one successor per CFA edge.")
    private boolean deleteInCPAEnabledAnalysis = false;
    @Option(secure=true, description="whether to keep covered states in the reached set as addition to keeping them in the ARG")
    private boolean keepCoveredStatesInReached = false;
    @Option(secure=true, description="prevent the stop-operator from aborting the stop-check early when it crosses a target state")
    private boolean coverTargetStates = false;
    @Option(secure=true, description="Enable reduction for nested abstract states when entering or leaving a block abstraction for BAM. The reduction can lead to a higher cache-hit-rate for BAM and a faster sub-analysis for blocks.")
    private boolean enableStateReduction = true;
    private final LogManager logger;
    private final ARGMergeJoin.MergeOptions mergeOptions;
    private final ARGStatistics stats;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ARGCPA.class);
    }

    private ARGCPA(ConfigurableProgramAnalysis cpa, Configuration config, LogManager logger, Specification pSpecification, CFA cfa) throws InvalidConfigurationException {
        super(cpa);
        config.inject((Object)this);
        this.logger = logger;
        this.mergeOptions = new ARGMergeJoin.MergeOptions(config);
        this.stats = new ARGStatistics(config, logger, this, pSpecification, cfa);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return new FlatLatticeDomain();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new ARGTransferRelation(this.getWrappedCpa().getTransferRelation());
    }

    @Override
    public MergeOperator getMergeOperator() {
        MergeOperator wrappedMergeOperator = this.getWrappedCpa().getMergeOperator();
        if (wrappedMergeOperator == MergeSepOperator.getInstance()) {
            return MergeSepOperator.getInstance();
        }
        if (this.inCPAEnabledAnalysis) {
            return new ARGMergeJoinCPAEnabledAnalysis(wrappedMergeOperator, this.deleteInCPAEnabledAnalysis);
        }
        return new ARGMergeJoin(wrappedMergeOperator, this.getWrappedCpa().getAbstractDomain(), this.logger, this.mergeOptions);
    }

    @Override
    public ForcedCoveringStopOperator getStopOperator() {
        return new ARGStopSep(this.getWrappedCpa().getStopOperator(), this.logger, this.inCPAEnabledAnalysis, this.keepCoveredStatesInReached, this.coverTargetStates);
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        PrecisionAdjustment wrappedPrec = this.getWrappedCpa().getPrecisionAdjustment();
        if (wrappedPrec instanceof SimplePrecisionAdjustment) {
            return new ARGSimplePrecisionAdjustment((SimplePrecisionAdjustment)wrappedPrec);
        }
        return new ARGPrecisionAdjustment(wrappedPrec, this.inCPAEnabledAnalysis, this.stats);
    }

    @Override
    public Reducer getReducer() throws InvalidConfigurationException {
        ConfigurableProgramAnalysis cpa = this.getWrappedCpa();
        Preconditions.checkState((boolean)(cpa instanceof ConfigurableProgramAnalysisWithBAM), (String)"wrapped CPA does not support BAM: %s", (Object)cpa.getClass().getCanonicalName());
        Reducer nestedReducer = this.enableStateReduction ? ((ConfigurableProgramAnalysisWithBAM)cpa).getReducer() : NoOpReducer.getInstance();
        return new ARGReducer(nestedReducer);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new ARGState(this.getWrappedCpa().getInitialState(pNode, pPartition), null);
    }

    public LogManager getLogger() {
        return this.logger;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (!Iterables.any(pStatsCollection, (Predicate)Predicates.instanceOf(ARGStatistics.class))) {
            pStatsCollection.add(this.stats);
        }
        super.collectStatistics(pStatsCollection);
    }

    public ARGStatistics getARGExporter() {
        return this.stats;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        Preconditions.checkState((boolean)(this.getWrappedCpa() instanceof ProofChecker), (Object)"Wrapped CPA has to implement ProofChecker interface");
        ProofChecker wrappedProofChecker = (ProofChecker)((Object)this.getWrappedCpa());
        ARGState element = (ARGState)pElement;
        assert (Iterables.elementsEqual(element.getChildren(), pSuccessors));
        AbstractState wrappedState = element.getWrappedState();
        HashMultimap wrappedSuccessors = HashMultimap.create();
        for (AbstractState abstractState : pSuccessors) {
            ARGState successorElem = (ARGState)abstractState;
            wrappedSuccessors.put((Object)element.getEdgeToChild(successorElem), (Object)successorElem.getWrappedState());
        }
        if (pCfaEdge != null) {
            return wrappedProofChecker.areAbstractSuccessors(wrappedState, pCfaEdge, wrappedSuccessors.get((Object)pCfaEdge));
        }
        for (CFAEdge cFAEdge : AbstractStates.getOutgoingEdges(element)) {
            if (wrappedProofChecker.areAbstractSuccessors(wrappedState, cFAEdge, wrappedSuccessors.get((Object)cFAEdge))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pElement, AbstractState pOtherElement) throws CPAException, InterruptedException {
        Preconditions.checkState((boolean)(this.getWrappedCpa() instanceof ProofChecker), (Object)"Wrapped CPA has to implement ProofChecker interface");
        ProofChecker wrappedProofChecker = (ProofChecker)((Object)this.getWrappedCpa());
        AbstractState wrappedState = ((ARGState)pElement).getWrappedState();
        AbstractState wrappedOtherElement = ((ARGState)pOtherElement).getWrappedState();
        return wrappedProofChecker.isCoveredBy(wrappedState, wrappedOtherElement);
    }

    @Override
    public void setPartitioning(BlockPartitioning partitioning) {
        ConfigurableProgramAnalysis cpa = this.getWrappedCpa();
        assert (cpa instanceof ConfigurableProgramAnalysisWithBAM);
        ((ConfigurableProgramAnalysisWithBAM)cpa).setPartitioning(partitioning);
    }

    @Override
    public boolean isCoveredByRecursiveState(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        return ((ConfigurableProgramAnalysisWithBAM)this.getWrappedCpa()).isCoveredByRecursiveState(((ARGState)state1).getWrappedState(), ((ARGState)state2).getWrappedState());
    }
}

