/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.slab.SLARGState;
import org.sosy_lab.cpachecker.cpa.slab.SLARGToDotWriter;
import org.sosy_lab.cpachecker.util.BiPredicates;

@Options(prefix="cpa.arg")
public class ARGLogger {
    private final UniqueIdGenerator iterationCount = new UniqueIdGenerator();
    @Option(secure=true, name="log.fileTemplate", description="write the ARG at various stages during execution into dot files whose name is specified by this option. Only works if 'cpa.arg.logARGs=true'")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate argLoggerFilenameTemplate = PathTemplate.ofFormatString((String)"ARG_log/ARG_%04d.dot");
    @Option(secure=true, description="Enable logging of ARGs at various positions")
    private boolean logARGs = false;
    private LogManager logger;

    public ARGLogger(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
    }

    public void log(String pTitle, UnmodifiableReachedSet pReachedSet) {
        if (!this.loggingAllowed() || pReachedSet == null || pReachedSet.isEmpty() || !(pReachedSet.iterator().next() instanceof ARGState)) {
            return;
        }
        String label = String.format("%s; waitlist=%s; reached=%s", pTitle, this.buildStatesList(pReachedSet.getWaitlist()), this.buildStatesList(pReachedSet.asCollection()));
        this.log(label, pReachedSet.asCollection());
    }

    public void log(String pTitle, Collection<AbstractState> pStates) {
        if (!this.loggingAllowed() || pStates == null || pStates.isEmpty()) {
            return;
        }
        Path file = this.argLoggerFilenameTemplate.getPath(new Object[]{this.iterationCount.getFreshId()});
        try (Writer w = IO.openOutputFile((Path)file, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            if (pStates.iterator().next() instanceof SLARGState) {
                SLARGToDotWriter.write(w, pStates, pTitle);
            } else if (pStates.iterator().next() instanceof ARGState) {
                ARGToDotWriter.write(w, pStates, pTitle);
            }
        }
        catch (IOException e) {
            this.logger.logfUserException(Level.WARNING, (Throwable)e, "A problem occurred while writing to %s ", new Object[]{file});
        }
    }

    public void log(AbstractState pRootState) {
        if (!this.loggingAllowed()) {
            return;
        }
        Path file = this.argLoggerFilenameTemplate.getPath(new Object[]{this.iterationCount.getFreshId()});
        try (Writer w = IO.openOutputFile((Path)file, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            ARGToDotWriter.write(w, (ARGState)pRootState, ARGState::getChildren, (Predicate<? super ARGState>)Predicates.alwaysTrue(), BiPredicates.alwaysFalse());
        }
        catch (IOException e) {
            this.logger.logfUserException(Level.WARNING, (Throwable)e, "A problem occurred while writing to %s ", new Object[]{file});
        }
    }

    private String buildStatesList(Collection<AbstractState> states) {
        return states.stream().map(x -> Integer.toString(((ARGState)x).getStateId())).collect(Collectors.joining(", "));
    }

    private boolean loggingAllowed() {
        return this.logARGs && this.argLoggerFilenameTemplate != null;
    }
}

