/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ARGMergeJoin
implements MergeOperator {
    private final MergeOperator wrappedMerge;
    private final AbstractDomain wrappedDomain;
    private final LogManager logger;
    private final MergeOptions options;

    public ARGMergeJoin(MergeOperator pWrappedMerge, AbstractDomain pWrappedDomain, LogManager pLogger, MergeOptions pOptions) {
        this.wrappedMerge = pWrappedMerge;
        this.wrappedDomain = pWrappedDomain;
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.options = (MergeOptions)Preconditions.checkNotNull((Object)pOptions);
    }

    @Override
    public AbstractState merge(AbstractState pElement1, AbstractState pElement2, Precision pPrecision) throws CPAException, InterruptedException {
        boolean continueMerge;
        AbstractState wrappedState2;
        ARGState argElement1 = (ARGState)pElement1;
        ARGState argElement2 = (ARGState)pElement2;
        Preconditions.checkArgument((!argElement1.isCovered() ? 1 : 0) != 0, (String)"Trying to merge covered element %s", (Object)argElement1);
        Preconditions.checkArgument((boolean)argElement1.getChildren().isEmpty(), (String)"First parameter %s of merge operator unexpectedly already has children", (Object)argElement1);
        if (!argElement2.mayCover()) {
            return pElement2;
        }
        if (argElement1.getMergedWith() != null) {
            return pElement2;
        }
        if (this.options.lateMerge == LateMergeHandling.PREVENT && !argElement2.getChildren().isEmpty()) {
            return pElement2;
        }
        AbstractState wrappedState1 = argElement1.getWrappedState();
        AbstractState retElement = this.wrappedMerge.merge(wrappedState1, wrappedState2 = argElement2.getWrappedState(), pPrecision);
        boolean bl = continueMerge = !retElement.equals(wrappedState2);
        if (this.options.mergeOnWrappedSubsumption) {
            ImmutableSet parents1 = ImmutableSet.copyOf(argElement1.getParents());
            ImmutableSet parents2 = ImmutableSet.copyOf(argElement2.getParents());
            boolean bl2 = continueMerge = continueMerge || !parents2.containsAll((Collection<?>)parents1) && this.wrappedDomain.isLessOrEqual(wrappedState1, wrappedState2);
        }
        if (!continueMerge) {
            return pElement2;
        }
        if (!argElement2.getChildren().isEmpty()) {
            switch (this.options.lateMerge) {
                case ALLOW_WARN: {
                    this.logger.log(Level.WARNING, new Object[]{ARGMergeJoin.getLateMergeMessage(argElement1, argElement2), "This is allowed but was configured to produce a warning because it is unexpected. The merge will be performed as usual and no further cases will be logged. Cf. issue #991 for more information about late merges."});
                    this.options.lateMerge = LateMergeHandling.ALLOW;
                }
                case ALLOW: {
                    break;
                }
                case PREVENT_WARN: {
                    this.logger.log(Level.WARNING, new Object[]{ARGMergeJoin.getLateMergeMessage(argElement1, argElement2), "This is allowed but was configured to produce a warning because it is unexpected. This merge and all other late merges will be prevented, but no further cases will be logged. Cf. issue #991 for more information about late merges."});
                    this.options.lateMerge = LateMergeHandling.PREVENT;
                }
                case PREVENT: {
                    return pElement2;
                }
                case CRASH: {
                    throw new AssertionError((Object)(ARGMergeJoin.getLateMergeMessage(argElement1, argElement2) + " This was configured to crash with option cpa.arg.lateMerge because it should not happen for this configuration. Either set this option to a different value or file a bug about this crash in the issue tracker. Cf. issue #991 for more information about late merges."));
                }
                default: {
                    throw new AssertionError((Object)"missing switch case");
                }
            }
        }
        ARGState mergedElement = new ARGState(retElement, null);
        argElement2.replaceInARGWith(mergedElement);
        for (ARGState parentOfElement1 : argElement1.getParents()) {
            mergedElement.addParent(parentOfElement1);
        }
        assert (argElement1.getChildren().isEmpty());
        assert (argElement1.getCoveredByThis().isEmpty());
        argElement1.setMergedWith(mergedElement);
        return mergedElement;
    }

    private static String getLateMergeMessage(ARGState s1, ARGState s2) {
        @Nullable CFANode cfaNode = AbstractStates.extractLocation(s2);
        String location = cfaNode != null ? " at CFA Node " + cfaNode + " (" + cfaNode.describeFileLocation() + ")" : "";
        return "Late merge detected" + location + ": " + s1.toShortString() + " was merged into " + s2.toShortString() + ".";
    }

    static enum LateMergeHandling {
        ALLOW,
        ALLOW_WARN,
        PREVENT,
        PREVENT_WARN,
        CRASH;

    }

    @Options(prefix="cpa.arg")
    static class MergeOptions {
        @Option(secure=true, description="If this option is enabled, ARG states will also be merged if the first wrapped state is subsumed by the second wrapped state (and the parents are not yet subsumed).")
        private boolean mergeOnWrappedSubsumption = false;
        @Option(secure=true, description="What do to on a late merge, i.e., if the second parameter of the merge already has child states (cf. issue #991):\n- ALLOW: Just merge as usual.\n- ALLOW_WARN: Log a warning the first time this happens, then ALLOW.\n- PREVENT: Do not merge, i.e., enforce merge-sep for such situations.\n- PREVENT_WARN: Log a warning the first time this happens, then PREVENT.\n- CRASH: Crash CPAchecker as soon as this happens\n  (useful for cases where a late merge should never happen).")
        private LateMergeHandling lateMerge = LateMergeHandling.ALLOW;

        MergeOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }
    }
}

