/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAEnabledAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class ARGMergeJoinCPAEnabledAnalysis
implements MergeOperator {
    private final boolean deleteSubgraphAfterMerge;
    private final MergeOperator wrappedMerge;
    private final List<ARGState> toDeleteFromReached = new ArrayList<ARGState>();

    public ARGMergeJoinCPAEnabledAnalysis(MergeOperator pWrappedMerge, boolean pDeleteSubgraph) {
        this.wrappedMerge = pWrappedMerge;
        this.deleteSubgraphAfterMerge = pDeleteSubgraph;
    }

    @Override
    public AbstractState merge(AbstractState pState1, AbstractState pState2, Precision pPrecision) throws CPAException, InterruptedException {
        AbstractState wrappedState2;
        ARGState argElement1 = (ARGState)pState1;
        ARGState argElement2 = (ARGState)pState2;
        assert (!argElement1.isCovered()) : "Trying to merge covered element " + argElement1;
        if (!argElement2.mayCover()) {
            return pState2;
        }
        if (argElement1.getMergedWith() != null) {
            return pState2;
        }
        AbstractState wrappedState1 = argElement1.getWrappedState();
        AbstractState retElement = this.wrappedMerge.merge(wrappedState1, wrappedState2 = argElement2.getWrappedState(), pPrecision);
        if (retElement.equals(wrappedState2)) {
            return pState2;
        }
        ARGState mergedElement = new ARGState(retElement, null);
        if (this.deleteSubgraphAfterMerge) {
            this.deleteChildren2(argElement2);
        }
        argElement2.replaceInARGWith(mergedElement);
        argElement1.setMergedWith(mergedElement);
        if (mergedElement.isTarget()) {
            throw new CPAEnabledAnalysisPropertyViolationException("Property violated during merge", argElement1, true);
        }
        return mergedElement;
    }

    private void deleteChildren(ARGState parent) {
        ArrayDeque<ARGState> toProcess = new ArrayDeque<ARGState>();
        toProcess.add(parent);
        while (!toProcess.isEmpty()) {
            ARGState current = (ARGState)toProcess.pop();
            this.toDeleteFromReached.add(current);
            while (!current.getChildren().isEmpty()) {
                ARGState child = current.getChildren().iterator().next();
                current.deleteChild(child);
                if (!child.getParents().isEmpty()) continue;
                if (!child.getCoveredByThis().isEmpty()) {
                    ARGState covered;
                    Iterator<ARGState> coveredElems = child.getCoveredByThis().iterator();
                    do {
                        if (!(covered = coveredElems.next()).getParents().isEmpty()) continue;
                        covered = null;
                    } while (covered == null && coveredElems.hasNext());
                    if (covered != null) {
                        covered.uncover();
                        covered.replaceInARGWith(child);
                        continue;
                    }
                    if (child.isCovered()) {
                        child.uncover();
                    }
                    toProcess.add(child);
                    continue;
                }
                if (child.isCovered()) {
                    child.uncover();
                }
                toProcess.add(child);
            }
        }
    }

    private void deleteChildren2(ARGState parent) {
        ARGState covered;
        ARGState child;
        ARGState current;
        Set<ARGState> subtreeNodes = this.getSubtreeNodes(parent);
        HashSet<ARGState> laterCovered = new HashSet<ARGState>();
        ArrayDeque<ARGState> toProcess = new ArrayDeque<ARGState>();
        toProcess.add(parent);
        while (!toProcess.isEmpty()) {
            current = (ARGState)toProcess.pop();
            this.toDeleteFromReached.add(current);
            while (!current.getChildren().isEmpty()) {
                child = current.getChildren().iterator().next();
                current.deleteChild(child);
                assert (child.getParents().isEmpty());
                if (!child.getCoveredByThis().isEmpty()) {
                    covered = this.getCoveredNodeFromDifferentSubtree(subtreeNodes, child);
                    if (covered != null) {
                        covered.uncover();
                        covered.replaceInARGWith(child);
                        subtreeNodes.removeAll(this.getSubtreeNodes(child));
                        continue;
                    }
                    laterCovered.add(child);
                    continue;
                }
                if (child.isCovered()) {
                    child.uncover();
                }
                toProcess.add(child);
            }
        }
        toProcess.addAll(laterCovered);
        while (!toProcess.isEmpty()) {
            current = (ARGState)toProcess.pop();
            for (ARGState c : current.getChildren()) {
                assert (c.getParents().size() == 1);
                if (!c.getCoveredByThis().isEmpty()) {
                    covered = this.getCoveredNodeFromDifferentSubtree(subtreeNodes, c);
                    if (covered != null) {
                        current.deleteChild(c);
                        new ARGState(c.getWrappedState(), current).setCovered(c);
                        covered.uncover();
                        covered.replaceInARGWith(c);
                        subtreeNodes.removeAll(this.getSubtreeNodes(c));
                        continue;
                    }
                    laterCovered.add(c);
                    toProcess.add(c);
                    continue;
                }
                toProcess.add(c);
            }
        }
        boolean changed = true;
        block4: while (changed) {
            changed = false;
            for (ARGState later : laterCovered) {
                if (later.getCoveredByThis().isEmpty() || (covered = this.getCoveredNodeFromDifferentSubtree(subtreeNodes, later)) == null) continue;
                assert (later.getParents().size() <= 1);
                if (later.getParents().size() == 1) {
                    new ARGState(later.getWrappedState(), later.getParents().iterator().next()).setCovered(later);
                    later.getParents().iterator().next().deleteChild(later);
                }
                covered.uncover();
                covered.replaceInARGWith(later);
                subtreeNodes.removeAll(this.getSubtreeNodes(later));
                laterCovered.remove(later);
                changed = true;
                continue block4;
            }
        }
        toProcess.addAll(laterCovered);
        while (!toProcess.isEmpty()) {
            current = (ARGState)toProcess.pop();
            this.toDeleteFromReached.add(current);
            while (!current.getChildren().isEmpty()) {
                child = current.getChildren().iterator().next();
                current.deleteChild(child);
                toProcess.add(child);
            }
        }
    }

    private ARGState getCoveredNodeFromDifferentSubtree(Set<ARGState> subtreeNodes, ARGState elem) {
        ARGState covered;
        Iterator<ARGState> coveredElems = elem.getCoveredByThis().iterator();
        do {
            covered = coveredElems.next();
            assert (covered.getCoveredByThis().isEmpty());
            if (!covered.getParents().isEmpty() && !subtreeNodes.contains(covered)) continue;
            covered = null;
        } while (covered == null && coveredElems.hasNext());
        return covered;
    }

    private Set<ARGState> getSubtreeNodes(ARGState top) {
        ArrayDeque<ARGState> toProcess = new ArrayDeque<ARGState>();
        HashSet<ARGState> nodes = new HashSet<ARGState>();
        toProcess.push(top);
        nodes.add(top);
        while (!toProcess.isEmpty()) {
            top = (ARGState)toProcess.pop();
            for (ARGState child : top.getChildren()) {
                if (!nodes.add(child)) continue;
                toProcess.push(child);
            }
        }
        return nodes;
    }

    public void cleanUp(ReachedSet pReachedSet) {
        pReachedSet.removeAll(this.toDeleteFromReached);
        this.toDeleteFromReached.clear();
    }
}

