/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGStatistics;
import org.sosy_lab.cpachecker.exceptions.CPAEnabledAnalysisPropertyViolationException;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class ARGPrecisionAdjustment
implements PrecisionAdjustment {
    private final PrecisionAdjustment wrappedPrecAdjustment;
    private final ARGStatistics statistics;
    protected final boolean inCPAEnabledAnalysis;

    public ARGPrecisionAdjustment(PrecisionAdjustment pWrappedPrecAdjustment, boolean pInCPAEnabledAnalysis, ARGStatistics pStats) {
        this.wrappedPrecAdjustment = pWrappedPrecAdjustment;
        this.inCPAEnabledAnalysis = pInCPAEnabledAnalysis;
        this.statistics = pStats;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pElement, Precision oldPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pElement instanceof ARGState));
        ARGState element = (ARGState)pElement;
        Optional<PrecisionAdjustmentResult> result = this.prec(element, oldPrecision, pElements, projection, fullState);
        this.statistics.printIterationStatistics(pElements);
        return result;
    }

    private Optional<PrecisionAdjustmentResult> prec(ARGState element, Precision oldPrecision, UnmodifiableReachedSet pElements, Function<AbstractState, AbstractState> projection, AbstractState fullState) throws CPAException, InterruptedException {
        if (this.inCPAEnabledAnalysis && element.isTarget()) {
            if (this.elementHasSiblings(element)) {
                this.removeUnreachedSiblingsFromARG(element, pElements);
            }
            throw new CPAEnabledAnalysisPropertyViolationException("Property violated during successor computation", element, false);
        }
        AbstractState oldElement = element.getWrappedState();
        Optional<PrecisionAdjustmentResult> optionalUnwrappedResult = this.wrappedPrecAdjustment.prec(oldElement, oldPrecision, pElements, (Function<AbstractState, AbstractState>)Functions.compose(state -> ((ARGState)state).getWrappedState(), projection), fullState);
        if (!optionalUnwrappedResult.isPresent()) {
            element.removeFromARG();
            return Optional.empty();
        }
        PrecisionAdjustmentResult unwrappedResult = optionalUnwrappedResult.orElseThrow();
        if (unwrappedResult.action() == PrecisionAdjustmentResult.Action.BREAK && this.elementHasSiblings(element)) {
            this.removeUnreachedSiblingsFromARG(element, pElements);
        }
        AbstractState newElement = unwrappedResult.abstractState();
        Precision newPrecision = unwrappedResult.precision();
        PrecisionAdjustmentResult.Action action = unwrappedResult.action();
        if (oldElement == newElement && oldPrecision == newPrecision) {
            return Optional.of(PrecisionAdjustmentResult.create(element, oldPrecision, action));
        }
        ARGState resultElement = new ARGState(newElement, null);
        element.replaceInARGWith(resultElement);
        return Optional.of(PrecisionAdjustmentResult.create(resultElement, newPrecision, action));
    }

    private void removeUnreachedSiblingsFromARG(ARGState element, UnmodifiableReachedSet pReachedSet) {
        ImmutableList.Builder scheduledForDeletion = ImmutableList.builder();
        for (ARGState sibling : ((ARGState)Iterables.getOnlyElement(element.getParents())).getChildren()) {
            if (Objects.equals(sibling, element) || pReachedSet.contains(sibling)) continue;
            scheduledForDeletion.add((Object)sibling);
        }
        for (ARGState sibling : scheduledForDeletion.build()) {
            sibling.removeFromARG();
        }
    }

    private boolean elementHasSiblings(ARGState element) {
        return ((ARGState)Iterables.getOnlyElement(element.getParents())).getChildren().size() > 1;
    }
}

