/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSetWrapper;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.Precisions;

public class ARGReachedSet {
    private final int refinementNumber;
    private final ConfigurableProgramAnalysis cpa;
    private final ReachedSet mReached;
    private final UnmodifiableReachedSet mUnmodifiableReached;

    public ARGReachedSet(ReachedSet pReached) {
        this(pReached, null);
    }

    public ARGReachedSet(ReachedSet pReached, ConfigurableProgramAnalysis pCpa) {
        this(pReached, pCpa, -1);
    }

    public ARGReachedSet(ReachedSet pReached, ConfigurableProgramAnalysis pCpa, int pRefinementNumber) {
        this.mReached = (ReachedSet)Preconditions.checkNotNull((Object)pReached);
        this.mUnmodifiableReached = new UnmodifiableReachedSetWrapper(this.mReached);
        this.cpa = pCpa;
        this.refinementNumber = pRefinementNumber;
    }

    public UnmodifiableReachedSet asReachedSet() {
        return this.mUnmodifiableReached;
    }

    public void removeSubtree(ARGState e) throws InterruptedException {
        Set<ARGState> toWaitlist = this.removeSubtree0(e);
        for (ARGState ae : toWaitlist) {
            this.mReached.reAddToWaitlist(ae);
        }
    }

    public void recalculateReachedSet(ARGState rootState) {
        this.removeUnReachableFrom(Collections.singleton(rootState), ARGState::getChildren, (Predicate<ARGState>)((Predicate)x -> true));
    }

    public void removeSafeRegions() {
        ImmutableList targetStates = FluentIterable.from((Iterable)this.mReached).filter(AbstractStates::isTargetState).toList();
        if (!targetStates.isEmpty()) {
            this.removeUnReachableFrom((Collection<AbstractState>)targetStates, ARGState::getParents, (Predicate<ARGState>)((Predicate)x -> x.wasExpanded()));
        }
    }

    private void removeUnReachableFrom(Collection<AbstractState> startStates, Function<? super ARGState, ? extends Iterable<ARGState>> successorFunction, Predicate<ARGState> allowedToRemove) {
        ArrayDeque<AbstractState> toVisit = new ArrayDeque<AbstractState>(startStates);
        HashSet<ARGState> reached = new HashSet<ARGState>();
        while (!toVisit.isEmpty()) {
            ARGState currentElement = (ARGState)toVisit.removeFirst();
            if (!reached.add(currentElement)) continue;
            ImmutableList notYetReached = FluentIterable.from(successorFunction.apply(currentElement)).filter(x -> !reached.contains(x)).toList();
            toVisit.addAll((Collection<AbstractState>)notYetReached);
        }
        ArrayList<ARGState> toRemove = new ArrayList<ARGState>(2);
        for (AbstractState inOldReached : this.mReached) {
            if (reached.contains(inOldReached) || !allowedToRemove.apply((Object)((ARGState)inOldReached))) continue;
            toRemove.add((ARGState)inOldReached);
        }
        for (ARGState state : toRemove) {
            if (state.isDestroyed()) continue;
            this.removeCoverageOf(state);
            state.removeFromARG();
        }
        this.mReached.removeAll(toRemove);
    }

    public void removeSubtree(ARGState e, Precision p, Predicate<? super Precision> pPrecisionType) throws InterruptedException {
        for (ARGState ae : this.removeSubtree0(e)) {
            this.mReached.updatePrecision(ae, this.adaptPrecision(this.mReached.getPrecision(ae), p, pPrecisionType));
            this.mReached.reAddToWaitlist(ae);
        }
    }

    public void removeSubtree(ARGState pState, List<Precision> pPrecisions, List<Predicate<? super Precision>> pPrecTypes) throws InterruptedException {
        Preconditions.checkNotNull((Object)pState);
        Preconditions.checkNotNull(pPrecisions);
        Preconditions.checkNotNull(pPrecTypes);
        Preconditions.checkArgument((pPrecisions.size() == pPrecTypes.size() ? 1 : 0) != 0);
        Set<ARGState> toWaitlist = this.removeSubtree0(pState);
        for (ARGState waitingState : toWaitlist) {
            Precision waitingStatePrec = this.mReached.getPrecision(waitingState);
            Preconditions.checkState((waitingStatePrec != null ? 1 : 0) != 0);
            for (int i = 0; i < pPrecisions.size(); ++i) {
                Precision adaptedPrec = this.adaptPrecision(waitingStatePrec, pPrecisions.get(i), pPrecTypes.get(i));
                if (adaptedPrec != null) {
                    waitingStatePrec = adaptedPrec;
                }
                Preconditions.checkState((waitingStatePrec != null ? 1 : 0) != 0);
            }
            this.mReached.updatePrecision(waitingState, waitingStatePrec);
            this.mReached.reAddToWaitlist(waitingState);
        }
    }

    public void removeInfeasiblePartofARG(ARGState rootOfInfeasiblePart) {
        this.dumpSubgraph(rootOfInfeasiblePart);
        ImmutableSet infeasibleSubtree = rootOfInfeasiblePart.getSubgraph().toSet();
        for (ARGState removedNode : infeasibleSubtree) {
            this.removeCoverageOf(removedNode);
        }
        ImmutableSet parentsOfRoot = ImmutableSet.copyOf(rootOfInfeasiblePart.getParents());
        NavigableSet<ARGState> parentsOfRemovedStates = this.removeSet((Set<ARGState>)infeasibleSubtree);
        assert (parentsOfRoot.equals(parentsOfRemovedStates));
    }

    public void cutOffSubtree(ARGState argState) {
        ImmutableList subgraph = argState.getSubgraph().toList();
        this.mReached.removeAll((Iterable<? extends AbstractState>)subgraph);
        for (ARGState ae : subgraph) {
            ae.detachFromARG();
        }
    }

    public void readdToWaitlist(ARGState state, Precision precision, Predicate<? super Precision> pPrecisionType) {
        this.mReached.updatePrecision(state, this.adaptPrecision(this.mReached.getPrecision(state), precision, pPrecisionType));
        this.mReached.reAddToWaitlist(state);
    }

    public void updatePrecisionForState(ARGState state, Precision precision, Predicate<? super Precision> pPrecisionType) {
        this.mReached.updatePrecision(state, this.adaptPrecision(this.mReached.getPrecision(state), precision, pPrecisionType));
    }

    public void updatePrecisionGlobally(Precision pNewPrecision, Predicate<? super Precision> pPrecisionType) {
        IdentityHashMap precisionUpdateCache = new IdentityHashMap();
        this.mReached.forEach((s, oldPrecision) -> {
            Precision newPrecision = precisionUpdateCache.computeIfAbsent(oldPrecision, oldPrec -> this.adaptPrecision((Precision)oldPrec, pNewPrecision, pPrecisionType));
            this.mReached.updatePrecision((AbstractState)s, newPrecision);
        });
    }

    private Precision adaptPrecision(Precision pOldPrecision, Precision pNewPrecision, Predicate<? super Precision> pPrecisionType) {
        return Precisions.replaceByType(pOldPrecision, pNewPrecision, pPrecisionType);
    }

    private Set<ARGState> removeSubtree0(ARGState e) {
        Preconditions.checkNotNull((Object)e);
        Preconditions.checkArgument((!e.getParents().isEmpty() ? 1 : 0) != 0, (String)"May not remove the initial state from the ARG/reached set.\nTrying to remove state '%s'.", (Object)e);
        this.dumpSubgraph(e);
        ImmutableList subtree = e.getSubgraph().toList();
        ImmutableSet toUnreach = FluentIterable.from((Iterable)subtree).transformAndConcat(ARGState::getCoveredByThis).append((Iterable)subtree).toSet();
        NavigableSet<ARGState> toWaitlist = this.removeSet((Set<ARGState>)toUnreach);
        return toWaitlist;
    }

    private void dumpSubgraph(ARGState e) {
        if (!(this.cpa instanceof ARGCPA)) {
            return;
        }
        ARGCPA argCpa = (ARGCPA)this.cpa;
        ARGToDotWriter refinementGraph = argCpa.getARGExporter().getRefinementGraphWriter();
        if (refinementGraph == null) {
            return;
        }
        SetMultimap<ARGState, ARGState> successors = ARGUtils.projectARG(e, ARGState::getChildren, (Predicate<? super ARGState>)((Predicate)ARGUtils::isRelevantState));
        SetMultimap<ARGState, ARGState> predecessors = ARGUtils.projectARG(e, ARGState::getParents, (Predicate<? super ARGState>)((Predicate)ARGUtils::isRelevantState));
        try {
            refinementGraph.enterSubgraph("cluster_" + this.refinementNumber, "Refinement " + this.refinementNumber);
            refinementGraph.writeSubgraph(e, (Function<? super ARGState, ? extends Iterable<ARGState>>)Functions.forMap((Map)successors.asMap(), (Object)ImmutableSet.of()), (Predicate<? super ARGState>)Predicates.alwaysTrue(), BiPredicates.alwaysFalse());
            refinementGraph.leaveSubgraph();
            for (ARGState predecessor : predecessors.get((Object)e)) {
                refinementGraph.writeEdge(predecessor, e);
            }
        }
        catch (IOException ex) {
            argCpa.getLogger().logUserException(Level.WARNING, (Throwable)ex, "Could not write refinement graph to file");
        }
    }

    private NavigableSet<ARGState> removeSet(Set<ARGState> elements) {
        this.mReached.removeAll(elements);
        TreeSet<ARGState> toWaitlist = new TreeSet<ARGState>();
        for (ARGState ae : elements) {
            for (ARGState parent : ae.getParents()) {
                if (elements.contains(parent)) continue;
                toWaitlist.add(parent);
            }
            ae.removeFromARG();
        }
        return toWaitlist;
    }

    public void removeCoverageOf(ARGState v) {
        for (ARGState coveredByChildOfV : ImmutableList.copyOf(v.getCoveredByThis())) {
            this.uncover(coveredByChildOfV);
        }
        assert (v.getCoveredByThis().isEmpty());
    }

    private void uncover(ARGState element) {
        element.uncover();
        for (ARGState e : element.getSubgraph()) {
            assert (!e.isCovered());
            e.setHasCoveredParent(false);
            if (e.wasExpanded()) continue;
            this.mReached.reAddToWaitlist(e);
        }
    }

    public boolean tryToCover(ARGState v) throws CPAException, InterruptedException {
        assert (v.mayCover());
        boolean stop = this.cpa.getStopOperator().stop(v, this.mReached.getReached(v), this.mReached.getPrecision(v));
        Preconditions.checkState((!stop ? 1 : 0) != 0);
        if (v.isCovered()) {
            ImmutableSet subtree = v.getSubgraph().filter(s -> !s.equals(v)).toSet();
            this.removeCoverageOf(v);
            for (ARGState childOfV : subtree) {
                this.removeCoverageOf(childOfV);
            }
            for (ARGState childOfV : subtree) {
                if (!childOfV.isCovered()) continue;
                childOfV.uncover();
            }
            for (ARGState childOfV : subtree) {
                this.mReached.removeOnlyFromWaitlist(childOfV);
                childOfV.setHasCoveredParent(true);
                assert (childOfV.getCoveredByThis().isEmpty());
                assert (!childOfV.mayCover());
            }
            this.mReached.removeOnlyFromWaitlist(v);
            return true;
        }
        return false;
    }

    public boolean tryToCover(ARGState v, boolean beUnsound) throws CPAException, InterruptedException {
        assert (v.mayCover());
        if (beUnsound) {
            this.cpa.getStopOperator().stop(v, this.mReached.getReached(v), this.mReached.getPrecision(v));
            return v.isCovered();
        }
        return this.tryToCover(v);
    }

    public void addForkedState(ARGState forkedState, ARGState originalState) {
        this.mReached.addNoWaitlist(forkedState, this.mReached.getPrecision(originalState));
    }

    public static class ForwardingARGReachedSet
    extends ARGReachedSet {
        protected final ARGReachedSet delegate;

        public ForwardingARGReachedSet(ARGReachedSet pReached) {
            super(pReached.mReached);
            this.delegate = pReached;
        }
    }
}

