/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.AbstractSerializableSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithDummyLocation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocations;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.arg.Splitable;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ARGState
extends AbstractSerializableSingleWrapperState
implements Comparable<ARGState>,
Graphable,
Splitable {
    private static final long serialVersionUID = 2608287648397165040L;
    private final Collection<ARGState> children = new ArrayList<ARGState>(1);
    private final Collection<ARGState> parents = new ArrayList<ARGState>(1);
    private ARGState mCoveredBy = null;
    private Set<ARGState> mCoveredByThis = null;
    private boolean wasExpanded = false;
    private boolean mayCover = true;
    private boolean destroyed = false;
    private boolean hasCoveredParent = false;
    private ARGState mergedWith = null;
    private final int stateId = idGenerator.getFreshId();
    private transient CounterexampleInfo counterexample;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();

    public ARGState(@Nullable AbstractState pWrappedState, @Nullable ARGState pParentElement) {
        super(pWrappedState);
        if (pParentElement != null) {
            this.addParent(pParentElement);
        }
    }

    public Collection<ARGState> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    public void addParent(ARGState pOtherParent) {
        Preconditions.checkNotNull((Object)pOtherParent);
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        if (!this.parents.contains(pOtherParent)) {
            assert (!pOtherParent.children.contains(this));
            this.parents.add(pOtherParent);
            pOtherParent.children.add(this);
        } else assert (pOtherParent.children.contains(this));
    }

    public Collection<ARGState> getChildren() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        return Collections.unmodifiableCollection(this.children);
    }

    public @Nullable CFAEdge getEdgeToChild(ARGState pChild) {
        AbstractStateWithLocations currentLocs = AbstractStates.extractStateByType(this, AbstractStateWithLocations.class);
        AbstractStateWithLocations childLocs = AbstractStates.extractStateByType(pChild, AbstractStateWithLocations.class);
        if (currentLocs != null && childLocs != null) {
            HashSet ingoingEdgesOfChild = Sets.newHashSet(childLocs.getIngoingEdges());
            for (CFAEdge edge : currentLocs.getOutgoingEdges()) {
                if (!ingoingEdgesOfChild.contains(edge)) continue;
                return edge;
            }
            for (CFANode currentLoc : currentLocs.getLocationNodes()) {
                for (CFANode childLoc : childLocs.getLocationNodes()) {
                    if (currentLoc.getLeavingSummaryEdge() == null || !currentLoc.getLeavingSummaryEdge().getSuccessor().equals(childLoc)) continue;
                    return currentLoc.getLeavingSummaryEdge();
                }
            }
        }
        AbstractStateWithDummyLocation stateWithDummyLocation = AbstractStates.extractStateByType(pChild, AbstractStateWithDummyLocation.class);
        if (currentLocs != null && stateWithDummyLocation != null && stateWithDummyLocation.isDummyLocation()) {
            for (CFAEdge enteringEdge : stateWithDummyLocation.getEnteringEdges()) {
                for (CFANode currentLocation : currentLocs.getLocationNodes()) {
                    if (!enteringEdge.getPredecessor().equals(currentLocation)) continue;
                    return enteringEdge;
                }
            }
        }
        return null;
    }

    public List<CFAEdge> getEdgesToChild(ARGState pChild) {
        CFAEdge singleEdge = this.getEdgeToChild(pChild);
        if (singleEdge == null) {
            ImmutableList.Builder allEdges = ImmutableList.builder();
            CFANode currentLoc = AbstractStates.extractLocation(this);
            CFANode childLoc = AbstractStates.extractLocation(pChild);
            if (currentLoc != null && childLoc != null) {
                while (!currentLoc.equals(childLoc)) {
                    if (currentLoc.getNumLeavingEdges() != 1) {
                        return ImmutableList.of();
                    }
                    CFAEdge leavingEdge = currentLoc.getLeavingEdge(0);
                    allEdges.add((Object)leavingEdge);
                    currentLoc = leavingEdge.getSuccessor();
                }
            }
            return allEdges.build();
        }
        return Collections.singletonList(singleEdge);
    }

    public FluentIterable<ARGState> getSubgraph() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        return FluentIterable.from((Iterable)Traverser.forGraph(ARGState::getChildren).breadthFirst((Object)this));
    }

    public void setCovered(@NonNull ARGState pCoveredBy) {
        Preconditions.checkState((!this.isCovered() ? 1 : 0) != 0, (String)"Cannot cover already covered element %s", (Object)this);
        Preconditions.checkNotNull((Object)pCoveredBy);
        Preconditions.checkArgument((boolean)pCoveredBy.mayCover, (String)"Trying to cover with non-covering element %s", (Object)pCoveredBy);
        this.mCoveredBy = pCoveredBy;
        if (pCoveredBy.mCoveredByThis == null) {
            pCoveredBy.mCoveredByThis = new LinkedHashSet<ARGState>(2);
        }
        pCoveredBy.mCoveredByThis.add(this);
    }

    public void uncover() {
        assert (this.isCovered());
        assert (this.mCoveredBy.mCoveredByThis.contains(this));
        this.mCoveredBy.mCoveredByThis.remove(this);
        this.mCoveredBy = null;
    }

    public boolean isCovered() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        return this.mCoveredBy != null;
    }

    public ARGState getCoveringState() {
        Preconditions.checkState((boolean)this.isCovered());
        return this.mCoveredBy;
    }

    public Set<ARGState> getCoveredByThis() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        if (this.mCoveredByThis == null) {
            return ImmutableSet.of();
        }
        return Collections.unmodifiableSet(this.mCoveredByThis);
    }

    public boolean mayCover() {
        return this.mayCover && !this.hasCoveredParent && !this.isCovered();
    }

    public void setNotCovering() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        this.mayCover = false;
    }

    void setHasCoveredParent(boolean pHasCoveredParent) {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        this.hasCoveredParent = pHasCoveredParent;
    }

    void setMergedWith(ARGState pMergedWith) {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        assert (this.mergedWith == null) : "Second merging of element " + this;
        this.mergedWith = pMergedWith;
    }

    public ARGState getMergedWith() {
        return this.mergedWith;
    }

    public boolean wasExpanded() {
        return this.wasExpanded;
    }

    public void markExpanded() {
        this.wasExpanded = true;
    }

    void deleteChild(ARGState child) {
        assert (this.children.contains(child));
        assert (child.parents.contains(this));
        this.children.remove(child);
        child.parents.remove(this);
    }

    public void addCounterexampleInformation(CounterexampleInfo pCounterexample) {
        Preconditions.checkState((this.counterexample == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.isTarget());
        Preconditions.checkArgument((!pCounterexample.isSpurious() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)pCounterexample.getTargetState().isTarget());
        this.counterexample = pCounterexample;
    }

    public void replaceCounterexampleInformation(CounterexampleInfo pCounterexample) {
        Preconditions.checkArgument((boolean)this.isTarget());
        Preconditions.checkArgument((!pCounterexample.isSpurious() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)pCounterexample.getTargetState().isTarget());
        this.counterexample = pCounterexample;
    }

    public Optional<CounterexampleInfo> getCounterexampleInformation() {
        Preconditions.checkState((boolean)this.isTarget());
        return Optional.ofNullable(this.counterexample);
    }

    public int getStateId() {
        return this.stateId;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public final int compareTo(ARGState pO) {
        return Integer.compare(this.stateId, pO.stateId);
    }

    @Override
    public final boolean equals(Object pObj) {
        return super.equals(pObj);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public boolean isOlderThan(ARGState other) {
        return this.stateId < other.stateId;
    }

    @Override
    public boolean isTarget() {
        return !this.hasCoveredParent && !this.isCovered() && super.isTarget();
    }

    @Override
    public String toString() {
        StringBuilder sb = this.toShortString();
        sb.append(" ");
        sb.append(this.getWrappedState());
        return sb.toString();
    }

    StringBuilder toShortString() {
        StringBuilder sb = new StringBuilder();
        if (this.destroyed) {
            sb.append("Destroyed ");
        }
        if (this.mCoveredBy != null) {
            sb.append("Covered ");
        }
        sb.append("ARG State (Id: ");
        sb.append(this.stateId);
        if (!this.destroyed) {
            sb.append(", Parents: ");
            sb.append(this.stateIdsOf(this.parents));
            sb.append(", Children: ");
            sb.append(this.stateIdsOf(this.children));
            if (this.mCoveredBy != null) {
                sb.append(", Covered by: ");
                sb.append(this.mCoveredBy.stateId);
            } else {
                sb.append(", Covering: ");
                sb.append(this.stateIdsOf(this.getCoveredByThis()));
            }
        }
        sb.append(")");
        return sb;
    }

    @Override
    public String toDOTLabel() {
        if (this.getWrappedState() instanceof Graphable) {
            return ((Graphable)((Object)this.getWrappedState())).toDOTLabel();
        }
        return "";
    }

    @Override
    public boolean shouldBeHighlighted() {
        if (this.getWrappedState() instanceof Graphable) {
            return ((Graphable)((Object)this.getWrappedState())).shouldBeHighlighted();
        }
        return false;
    }

    private Iterable<Integer> stateIdsOf(Iterable<ARGState> elements) {
        return FluentIterable.from(elements).transform(ARGState::getStateId);
    }

    public void removeFromARG() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        this.detachFromARG();
        this.clearCoverageRelation();
        this.destroyed = true;
    }

    private void clearCoverageRelation() {
        if (this.isCovered()) {
            assert (this.mCoveredBy.mCoveredByThis.contains(this));
            this.mCoveredBy.mCoveredByThis.remove(this);
            this.mCoveredBy = null;
        }
        if (this.mCoveredByThis != null) {
            for (ARGState covered : this.mCoveredByThis) {
                covered.mCoveredBy = null;
            }
            this.mCoveredByThis.clear();
            this.mCoveredByThis = null;
        }
    }

    void detachFromARG() {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        for (ARGState child : this.children) {
            assert (child.parents.contains(this));
            child.parents.remove(this);
        }
        this.children.clear();
        for (ARGState parent : this.parents) {
            assert (parent.children.contains(this));
            parent.children.remove(this);
        }
        this.parents.clear();
    }

    public void replaceInARGWith(ARGState replacement) {
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        assert (!replacement.destroyed) : "Don't use destroyed ARGState " + replacement;
        assert (!this.isCovered()) : "Not implemented: Replacement of covered element " + this;
        assert (!replacement.isCovered()) : "Cannot replace with covered element " + replacement;
        assert (!this.equals(replacement)) : "Don't replace ARGState " + this + " with itself";
        for (ARGState child : this.children) {
            assert (child.parents.contains(this)) : "Inconsistent ARG at " + this;
            child.parents.remove(this);
            child.addParent(replacement);
        }
        this.children.clear();
        for (ARGState parent : this.parents) {
            assert (parent.children.contains(this)) : "Inconsistent ARG at " + this;
            parent.children.remove(this);
            replacement.addParent(parent);
        }
        this.parents.clear();
        if (this.mCoveredByThis != null) {
            if (replacement.mCoveredByThis == null) {
                replacement.mCoveredByThis = Sets.newHashSetWithExpectedSize((int)this.mCoveredByThis.size());
            }
            for (ARGState covered : this.mCoveredByThis) {
                assert (this.equals(covered.mCoveredBy)) : "Inconsistent coverage relation at " + this;
                covered.mCoveredBy = replacement;
                replacement.mCoveredByThis.add(covered);
            }
            this.mCoveredByThis.clear();
            this.mCoveredByThis = null;
        }
        this.destroyed = true;
    }

    @Override
    public ARGState forkWithReplacements(Collection<AbstractState> pReplacementStates) {
        AbstractState wrappedState = this.getWrappedState();
        AbstractState newWrappedState = null;
        newWrappedState = wrappedState instanceof Splitable ? ((Splitable)((Object)wrappedState)).forkWithReplacements(pReplacementStates) : wrappedState;
        ARGState newState = new ARGState(newWrappedState, null);
        newState.makeTwinOf(this);
        return newState;
    }

    public void makeTwinOf(ARGState pTemplateState) {
        Preconditions.checkState((this.stateId != pTemplateState.stateId ? 1 : 0) != 0);
        Preconditions.checkState((!pTemplateState.destroyed ? 1 : 0) != 0);
        Preconditions.checkState((pTemplateState.counterexample == null ? 1 : 0) != 0);
        this.wasExpanded = pTemplateState.wasExpanded;
        this.mayCover = pTemplateState.mayCover;
        this.hasCoveredParent = pTemplateState.hasCoveredParent;
    }

    public void removeParent(ARGState pOtherParent) {
        Preconditions.checkNotNull((Object)pOtherParent);
        assert (!this.destroyed) : "Don't use destroyed ARGState " + this;
        if (this.parents.contains(pOtherParent)) {
            assert (pOtherParent.children.contains(this));
            this.parents.remove(pOtherParent);
            pOtherParent.children.remove(this);
        } else assert (!pOtherParent.children.contains(this)) : "Problem detected!";
    }
}

