/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.io.MoreFiles;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGToPixelsWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CEXExportOptions;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CEXExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.ExtendedWitnessExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessToOutputFormatsUtils;
import org.sosy_lab.cpachecker.cpa.automaton.ARGToAutomatonConverter;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.partitioning.PartitioningCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.cwriter.ARGToCTranslator;

@Options(prefix="cpa.arg")
public class ARGStatistics
implements Statistics {
    @Option(secure=true, name="dumpAfterIteration", description="Dump all ARG related statistics files after each iteration of the CPA algorithm? (for debugging and demonstration)")
    private boolean dumpArgInEachCpaIteration = false;
    @Option(secure=true, name="export", description="export final ARG as .dot file")
    private boolean exportARG = true;
    @Option(secure=true, name="file", description="export final ARG as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path argFile = Path.of("ARG.dot", new String[0]);
    @Option(secure=true, name="pixelGraphicFile", description="Export final ARG as pixel graphic to the given file name. The suffix is added  corresponding to the value of option pixelgraphic.export.formatIf set to 'null', no pixel graphic is exported.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path pixelGraphicFile = Path.of("ARG", new String[0]);
    @Option(secure=true, name="proofWitness", description="export a proof as .graphml file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path proofWitness = null;
    @Option(secure=true, name="proofWitness.dot", description="export a proof as dot/graphviz file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path proofWitnessDot = null;
    @Option(secure=true, name="compressWitness", description="compress the produced correctness-witness automata using GZIP compression.")
    private boolean compressWitness = true;
    @Option(secure=true, name="simplifiedARG.file", description="export final ARG as .dot file, showing only loop heads and function entries/exits")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path simplifiedArgFile = Path.of("ARGSimplified.dot", new String[0]);
    @Option(secure=true, name="refinements.file", description="export simplified ARG that shows all refinements to .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path refinementGraphFile = Path.of("ARGRefinements.dot", new String[0]);
    @Option(secure=true, name="translateToC", description="translate final ARG into C program")
    private boolean translateARG = false;
    @Option(secure=true, name="CTranslation.file", description="translate final ARG into this C file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path argCFile = Path.of("ARG.c", new String[0]);
    @Option(secure=true, name="automaton.export", description="translate final ARG into an automaton")
    private boolean exportAutomaton = false;
    @Option(secure=true, name="automaton.exportSpcZipFile", description="translate final ARG into an automaton, depends on 'automaton.export=true'")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path automatonSpcZipFile = Path.of("ARG_parts.zip", new String[0]);
    @Option(secure=true, name="automaton.exportSpcFile", description="translate final ARG into an automaton, depends on 'automaton.export=true'")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate automatonSpcFile = PathTemplate.ofFormatString((String)"ARG_parts/ARG.%06d.spc");
    @Option(secure=true, name="automaton.exportDotFile", description="translate final ARG into an automaton, depends on 'automaton.export=true'")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate automatonSpcDotFile = PathTemplate.ofFormatString((String)"ARG_parts/ARG.%06d.spc.dot");
    @Option(secure=true, name="automaton.exportCompressed", description="export as zip-files, depends on 'automaton.export=true'")
    private boolean exportAutomatonCompressed = true;
    @Option(secure=true, name="automaton.exportZipped", description="export all automata into one zip-file, depends on 'automaton.export=true'")
    private boolean exportAutomatonZipped = true;
    protected final ConfigurableProgramAnalysis cpa;
    private final CEXExportOptions counterexampleOptions;
    private Writer refinementGraphUnderlyingWriter = null;
    private ARGToDotWriter refinementGraphWriter = null;
    private final @Nullable CEXExporter cexExporter;
    private final WitnessExporter argWitnessExporter;
    private final AssumptionToEdgeAllocator assumptionToEdgeAllocator;
    private final ARGToCTranslator argToCExporter;
    private final ARGToPixelsWriter argToBitmapExporter;
    private ARGToAutomatonConverter argToAutomatonSplitter;
    protected final LogManager logger;

    public ARGStatistics(Configuration config, LogManager pLogger, ConfigurableProgramAnalysis pCpa, Specification pSpecification, CFA cfa) throws InvalidConfigurationException {
        config.inject((Object)this, ARGStatistics.class);
        this.counterexampleOptions = new CEXExportOptions(config);
        this.argToBitmapExporter = new ARGToPixelsWriter(config);
        this.logger = pLogger;
        this.cpa = pCpa;
        this.assumptionToEdgeAllocator = AssumptionToEdgeAllocator.create(config, this.logger, cfa.getMachineModel());
        if (this.argFile == null && this.simplifiedArgFile == null && this.refinementGraphFile == null && this.proofWitness == null && this.proofWitnessDot == null && this.pixelGraphicFile == null && (!this.exportAutomaton || this.automatonSpcFile == null && this.automatonSpcDotFile == null)) {
            this.exportARG = false;
        }
        this.argWitnessExporter = new WitnessExporter(config, this.logger, pSpecification, cfa);
        if (this.counterexampleOptions.disabledCompletely()) {
            this.cexExporter = null;
        } else {
            ExtendedWitnessExporter extendedWitnessExporter = new ExtendedWitnessExporter(config, this.logger, pSpecification, cfa);
            this.cexExporter = new CEXExporter(config, this.counterexampleOptions, this.logger, cfa, this.cpa, this.argWitnessExporter, extendedWitnessExporter);
        }
        this.argToCExporter = new ARGToCTranslator(this.logger, config, cfa.getMachineModel());
        this.argToAutomatonSplitter = new ARGToAutomatonConverter(config, cfa.getMachineModel(), this.logger);
        if (this.argCFile == null) {
            this.translateARG = false;
        }
    }

    ARGToDotWriter getRefinementGraphWriter() {
        if (!this.exportARG || this.refinementGraphFile == null) {
            return null;
        }
        if (this.refinementGraphWriter == null) {
            try {
                this.refinementGraphUnderlyingWriter = IO.openOutputFile((Path)this.refinementGraphFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                this.refinementGraphWriter = new ARGToDotWriter(this.refinementGraphUnderlyingWriter);
            }
            catch (IOException e) {
                if (this.refinementGraphUnderlyingWriter != null) {
                    try {
                        this.refinementGraphUnderlyingWriter.close();
                    }
                    catch (IOException innerException) {
                        e.addSuppressed(innerException);
                    }
                }
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write refinement graph to file");
                this.refinementGraphFile = null;
                this.refinementGraphUnderlyingWriter = null;
                this.refinementGraphWriter = null;
            }
        }
        assert (this.refinementGraphUnderlyingWriter == null == (this.refinementGraphWriter == null));
        return this.refinementGraphWriter;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
    }

    @Override
    public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        if ((this.counterexampleOptions.disabledCompletely() || this.counterexampleOptions.dumpErrorPathImmediately()) && !this.exportARG && !this.translateARG) {
            return;
        }
        Map<ARGState, CounterexampleInfo> counterexamples = this.getAllCounterexamples(pReached);
        if (!this.counterexampleOptions.disabledCompletely() && !this.counterexampleOptions.dumpErrorPathImmediately() && pResult == CPAcheckerResult.Result.FALSE) {
            for (Map.Entry<ARGState, CounterexampleInfo> cex : counterexamples.entrySet()) {
                this.cexExporter.exportCounterexample(cex.getKey(), cex.getValue());
            }
        }
        if (this.exportARG) {
            this.exportARG(pReached, counterexamples, pResult);
        }
        if (this.translateARG) {
            try {
                String argAsC = this.argToCExporter.translateARG((ARGState)pReached.getFirstState(), true);
                try (Writer writer = IO.openOutputFile((Path)this.argCFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                    writer.write(argAsC);
                }
            }
            catch (IOException | CPAException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write C translation of ARG to file");
            }
        }
    }

    private Path adjustPathNameForPartitioning(ARGState rootState, Path pPath) {
        if (pPath == null) {
            return null;
        }
        PartitioningCPA.PartitionState partyState = AbstractStates.extractStateByType(rootState, PartitioningCPA.PartitionState.class);
        if (partyState == null) {
            return pPath;
        }
        String partitionKey = partyState.getStateSpacePartition().getPartitionKey().toString();
        String path = pPath.toString();
        int sepIx = path.lastIndexOf(".");
        String prefix = path.substring(0, sepIx);
        String extension = path.substring(sepIx);
        return Path.of(prefix + "-" + partitionKey + extension, new String[0]);
    }

    private void exportARG(UnmodifiableReachedSet pReached, Map<ARGState, CounterexampleInfo> counterexamples, CPAcheckerResult.Result pResult) {
        HashSet allTargetPathEdges = new HashSet();
        for (CounterexampleInfo cex : counterexamples.values()) {
            allTargetPathEdges.addAll(cex.getTargetPath().getStatePairs());
        }
        boolean partitionedArg = pReached.isEmpty() || AbstractStates.extractStateByType(pReached.getFirstState(), PartitioningCPA.PartitionState.class) != null;
        ImmutableSet<ARGState> rootStates = partitionedArg ? ARGUtils.getRootStates(pReached) : Collections.singleton(AbstractStates.extractStateByType(pReached.getFirstState(), ARGState.class));
        for (ARGState rootState : rootStates) {
            this.exportARG0(rootState, BiPredicates.pairIn(allTargetPathEdges), pResult);
        }
    }

    private void exportARG0(ARGState rootState, BiPredicate<ARGState, ARGState> isTargetPathEdge, CPAcheckerResult.Result pResult) {
        Writer w;
        SetMultimap<ARGState, ARGState> relevantSuccessorRelation = ARGUtils.projectARG(rootState, ARGState::getChildren, (Predicate<? super ARGState>)((Predicate)ARGUtils::isRelevantState));
        Function relevantSuccessorFunction = Functions.forMap((Map)relevantSuccessorRelation.asMap(), (Object)ImmutableSet.of());
        if (EnumSet.of(CPAcheckerResult.Result.TRUE, CPAcheckerResult.Result.UNKNOWN).contains((Object)pResult)) {
            try {
                Path witnessFile;
                Witness witness = this.argWitnessExporter.generateProofWitness(rootState, (Predicate<? super ARGState>)Predicates.alwaysTrue(), BiPredicates.alwaysTrue(), this.argWitnessExporter.getProofInvariantProvider());
                if (this.proofWitness != null) {
                    witnessFile = this.adjustPathNameForPartitioning(rootState, this.proofWitness);
                    WitnessToOutputFormatsUtils.writeWitness(witnessFile, this.compressWitness, pAppendable -> WitnessToOutputFormatsUtils.writeToGraphMl(witness, pAppendable), this.logger);
                }
                if (this.proofWitnessDot != null) {
                    witnessFile = this.adjustPathNameForPartitioning(rootState, this.proofWitnessDot);
                    WitnessToOutputFormatsUtils.writeWitness(witnessFile, this.compressWitness, pAppendable -> WitnessToOutputFormatsUtils.writeToDot(witness, pAppendable), this.logger);
                }
            }
            catch (InterruptedException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not export witness due to interruption");
            }
        }
        if (this.argFile != null) {
            try {
                w = IO.openOutputFile((Path)this.adjustPathNameForPartitioning(rootState, this.argFile), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try {
                    ARGToDotWriter.write(w, rootState, ARGState::getChildren, (Predicate<? super ARGState>)Predicates.alwaysTrue(), isTargetPathEdge);
                }
                finally {
                    if (w != null) {
                        w.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write ARG to file");
            }
        }
        if (this.pixelGraphicFile != null) {
            try {
                Path adjustedBitmapFileName = this.adjustPathNameForPartitioning(rootState, this.pixelGraphicFile);
                this.argToBitmapExporter.write(rootState, adjustedBitmapFileName);
            }
            catch (IOException | InvalidConfigurationException e) {
                this.logger.logUserException(Level.WARNING, e, "Could not write ARG bitmap to file");
            }
        }
        if (this.simplifiedArgFile != null) {
            try {
                w = IO.openOutputFile((Path)this.adjustPathNameForPartitioning(rootState, this.simplifiedArgFile), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try {
                    ARGToDotWriter.write(w, rootState, (java.util.function.Function<? super ARGState, ? extends Iterable<ARGState>>)relevantSuccessorFunction, (Predicate<? super ARGState>)Predicates.alwaysTrue(), BiPredicates.alwaysFalse());
                }
                finally {
                    if (w != null) {
                        w.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write ARG to file");
            }
        }
        assert (this.refinementGraphUnderlyingWriter == null == (this.refinementGraphWriter == null));
        if (this.refinementGraphUnderlyingWriter != null) {
            try {
                w = this.refinementGraphUnderlyingWriter;
                try {
                    this.refinementGraphWriter.writeSubgraph(rootState, (java.util.function.Function<? super ARGState, ? extends Iterable<ARGState>>)relevantSuccessorFunction, (Predicate<? super ARGState>)Predicates.alwaysTrue(), BiPredicates.alwaysFalse());
                    this.refinementGraphWriter.finish();
                }
                finally {
                    if (w != null) {
                        w.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write refinement graph to file");
            }
        }
        if (this.exportAutomaton && (this.automatonSpcFile != null || this.automatonSpcDotFile != null)) {
            try {
                if (this.exportAutomatonZipped && this.automatonSpcZipFile != null) {
                    Files.deleteIfExists(this.automatonSpcZipFile);
                }
                int baseId = -1;
                this.writeAutomaton(-1, this.argToAutomatonSplitter.getAutomaton(rootState, true));
            }
            catch (IOException io) {
                this.logger.logUserException(Level.WARNING, (Throwable)io, "Could not write ARG to automata to file");
            }
            try {
                int counterId = 0;
                for (Automaton automaton : this.argToAutomatonSplitter.getAutomata(rootState)) {
                    this.writeAutomaton(++counterId, automaton);
                }
                this.logger.log(Level.INFO, new Object[]{"Number of exported automata after splitting:", counterId});
            }
            catch (IOException io) {
                this.logger.logUserException(Level.WARNING, (Throwable)io, "Could not write ARG to automata to file");
            }
        }
    }

    private void writeAutomaton(int counterId, Automaton automaton) throws IOException {
        if (this.automatonSpcFile != null) {
            this.writeFile(this.automatonSpcFile.getPath(new Object[]{counterId}), automaton);
        }
        if (this.automatonSpcDotFile != null) {
            Appender app = automaton::writeDotFile;
            this.writeFile(this.automatonSpcDotFile.getPath(new Object[]{counterId}), app);
        }
    }

    private void writeFile(Path path, Object content) throws IOException {
        if (this.exportAutomatonZipped && this.automatonSpcZipFile != null) {
            MoreFiles.createParentDirectories((Path)this.automatonSpcZipFile, (FileAttribute[])new FileAttribute[0]);
            try (FileSystem fs = FileSystems.newFileSystem(URI.create("jar:" + this.automatonSpcZipFile.toUri()), ImmutableMap.of((Object)"create", (Object)"true"));){
                Path nf = fs.getPath(path.getFileName().toString(), new String[0]);
                IO.writeFile((Path)nf, (Charset)Charset.defaultCharset(), (Object)content);
            }
        } else if (this.exportAutomatonCompressed) {
            path = path.resolveSibling(path.getFileName() + ".gz");
            IO.writeGZIPFile((Path)path, (Charset)Charset.defaultCharset(), (Object)content);
        } else {
            IO.writeFile((Path)path, (Charset)Charset.defaultCharset(), (Object)content);
        }
    }

    public Map<ARGState, CounterexampleInfo> getAllCounterexamples(UnmodifiableReachedSet pReached) {
        ImmutableMap.Builder counterexamples = ImmutableMap.builder();
        for (AbstractState targetState : FluentIterable.from((Iterable)pReached).filter(AbstractStates::isTargetState)) {
            ARGState s = (ARGState)targetState;
            CounterexampleInfo cex2 = ARGUtils.tryGetOrCreateCounterexampleInformation(s, this.cpa, this.assumptionToEdgeAllocator).orElse(null);
            if (cex2 == null) continue;
            counterexamples.put((Object)s, (Object)cex2);
        }
        ImmutableMap allCounterexamples = counterexamples.buildOrThrow();
        Map preciseCounterexamples = Maps.filterValues((Map)allCounterexamples, cex -> cex.isPreciseCounterExample());
        return preciseCounterexamples.isEmpty() ? allCounterexamples : preciseCounterexamples;
    }

    public void exportCounterexampleOnTheFly(ARGState pTargetState, CounterexampleInfo pCounterexampleInfo) throws InterruptedException {
        if (!this.counterexampleOptions.disabledCompletely() && this.counterexampleOptions.dumpErrorPathImmediately()) {
            this.cexExporter.exportCounterexampleIfRelevant(pTargetState, pCounterexampleInfo);
        }
    }

    public void exportCounterexampleOnTheFly(UnmodifiableReachedSet pReachedSet) throws InterruptedException {
        if (this.counterexampleOptions.dumpAllFoundErrorPaths()) {
            for (Map.Entry<ARGState, CounterexampleInfo> cex : this.getAllCounterexamples(pReachedSet).entrySet()) {
                this.exportCounterexampleOnTheFly(cex.getKey(), cex.getValue());
            }
        }
    }

    public void printIterationStatistics(UnmodifiableReachedSet pReached) {
        if (this.dumpArgInEachCpaIteration) {
            this.exportARG(pReached, this.getAllCounterexamples(pReached), CPAcheckerResult.Result.UNKNOWN);
        }
    }
}

