/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ForcedCoveringStopOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class ARGStopSep
implements StopOperator,
ForcedCoveringStopOperator {
    private final boolean keepCoveredStatesInReached;
    private final boolean inCPAEnabledAnalysis;
    private final boolean coverTargetStates;
    private final StopOperator wrappedStop;
    private final LogManager logger;

    public ARGStopSep(StopOperator pWrappedStop, LogManager pLogger, boolean pInCPAEnabledAnalysis, boolean pKeepCoveredStatesInReached, boolean pCoverTargetStates) {
        this.wrappedStop = pWrappedStop;
        this.logger = pLogger;
        this.keepCoveredStatesInReached = pKeepCoveredStatesInReached;
        this.inCPAEnabledAnalysis = pInCPAEnabledAnalysis;
        this.coverTargetStates = pCoverTargetStates;
    }

    @Override
    public boolean stop(AbstractState pElement, Collection<AbstractState> pReached, Precision pPrecision) throws CPAException, InterruptedException {
        ARGState argElement = (ARGState)pElement;
        assert (!argElement.isCovered()) : "Passing element to stop which is already covered: " + argElement;
        if (argElement.getMergedWith() != null) {
            ARGState mergedWith = argElement.getMergedWith();
            if (pReached.contains(mergedWith)) {
                if (this.wrappedStop.stop(argElement.getWrappedState(), Collections.singleton(mergedWith.getWrappedState()), pPrecision)) {
                    if (this.inCPAEnabledAnalysis) {
                        argElement.setCovered(mergedWith);
                    } else {
                        argElement.removeFromARG();
                    }
                    this.logger.log(Level.FINEST, new Object[]{"Element is covered by the element it was merged into"});
                    return true;
                }
                this.logger.log(Level.FINEST, new Object[]{"Element was merged but not covered:", pElement});
            } else {
                this.logger.log(Level.FINEST, new Object[]{"Element was merged into an element that's not in the reached set, merged-with element is", mergedWith});
            }
        }
        if (!this.coverTargetStates && argElement.isTarget()) {
            return false;
        }
        ARGState parent = null;
        if (argElement.getParents().size() == 1) {
            parent = (ARGState)Iterables.get(argElement.getParents(), (int)0);
        }
        for (AbstractState reachedState : pReached) {
            ARGState argReachedState = (ARGState)reachedState;
            if (!this.stop(argElement, argReachedState, pPrecision)) continue;
            if (parent != null && argReachedState.getParents().contains(parent)) {
                argElement.removeFromARG();
                return true;
            }
            return !this.keepCoveredStatesInReached;
        }
        return false;
    }

    private boolean stop(ARGState pElement, ARGState pReachedState, Precision pPrecision) throws CPAException, InterruptedException {
        AbstractState wrappedReachedState;
        if (!pReachedState.mayCover()) {
            return false;
        }
        if (Objects.equals(pElement, pReachedState)) {
            return false;
        }
        if (pElement.isOlderThan(pReachedState)) {
            return false;
        }
        AbstractState wrappedState = pElement.getWrappedState();
        boolean stop = this.wrappedStop.stop(wrappedState, Collections.singleton(wrappedReachedState = pReachedState.getWrappedState()), pPrecision);
        if (stop) {
            pElement.setCovered(pReachedState);
        }
        return stop;
    }

    @Override
    public boolean isForcedCoveringPossible(AbstractState pElement, AbstractState pReachedState, Precision pPrecision) throws CPAException, InterruptedException {
        if (!(this.wrappedStop instanceof ForcedCoveringStopOperator)) {
            return false;
        }
        ARGState element = (ARGState)pElement;
        ARGState reachedState = (ARGState)pReachedState;
        if (reachedState.isCovered() || !reachedState.mayCover()) {
            return false;
        }
        if (element.isOlderThan(reachedState)) {
            return false;
        }
        return ((ForcedCoveringStopOperator)this.wrappedStop).isForcedCoveringPossible(element.getWrappedState(), reachedState.getWrappedState(), pPrecision);
    }
}

