/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableIntArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.pixelexport.GraphLevel;
import org.sosy_lab.cpachecker.util.pixelexport.GraphToPixelsWriter;
import org.sosy_lab.cpachecker.util.pixelexport.SimpleGraphLevel;

public class ARGToPixelsWriter
extends GraphToPixelsWriter<ARGState> {
    private static final Color COLOR_TARGET = Color.RED;
    private static final Color COLOR_HIGHLIGHT = Color.BLUE;
    private static final Color COLOR_NOTEXPANDED = Color.ORANGE;
    private static final Color COLOR_COVERED = Color.GREEN;

    public ARGToPixelsWriter(Configuration pConfig) throws InvalidConfigurationException {
        super(pConfig);
    }

    public ARGLevel.Builder getLevelBuilder() {
        return ARGLevel.builder();
    }

    @Override
    public Iterable<ARGState> getChildren(ARGState pParent) {
        return pParent.getChildren();
    }

    private static class ARGLevel
    extends SimpleGraphLevel {
        private final ImmutableIntArray targetIndices;
        private final ImmutableIntArray highlightIndices;
        private final ImmutableIntArray notExpandedIndices;
        private final ImmutableIntArray coveredIndices;

        private ARGLevel(int pWidth, ImmutableIntArray pTargets, ImmutableIntArray pNotExpanded, ImmutableIntArray pHighlights, ImmutableIntArray pCovered) {
            super(pWidth);
            this.targetIndices = (ImmutableIntArray)Preconditions.checkNotNull((Object)pTargets);
            this.notExpandedIndices = (ImmutableIntArray)Preconditions.checkNotNull((Object)pNotExpanded);
            this.highlightIndices = (ImmutableIntArray)Preconditions.checkNotNull((Object)pHighlights);
            this.coveredIndices = (ImmutableIntArray)Preconditions.checkNotNull((Object)pCovered);
        }

        @Override
        public Collection<Pair<ImmutableIntArray, Color>> getGroups() {
            ArrayDeque<Pair<ImmutableIntArray, Color>> groups = new ArrayDeque<Pair<ImmutableIntArray, Color>>(4);
            if (!this.highlightIndices.isEmpty()) {
                groups.add(Pair.of(this.highlightIndices, COLOR_HIGHLIGHT));
            }
            if (!this.notExpandedIndices.isEmpty()) {
                groups.add(Pair.of(this.notExpandedIndices, COLOR_NOTEXPANDED));
            }
            if (!this.targetIndices.isEmpty()) {
                groups.add(Pair.of(this.targetIndices, COLOR_TARGET));
            }
            if (!this.coveredIndices.isEmpty()) {
                groups.add(Pair.of(this.coveredIndices, COLOR_COVERED));
            }
            return groups;
        }

        @Override
        public Color getBackgroundColor() {
            Color color;
            if (!this.targetIndices.isEmpty()) {
                color = COLOR_TARGET;
            } else if (!this.highlightIndices.isEmpty()) {
                color = COLOR_HIGHLIGHT;
            } else if (this.notExpandedIndices.length() > this.coveredIndices.length()) {
                color = COLOR_NOTEXPANDED;
            } else if (!this.coveredIndices.isEmpty()) {
                color = COLOR_COVERED;
            } else {
                return GraphToPixelsWriter.COLOR_BACKGROUND;
            }
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
        }

        static Builder builder() {
            return new Builder();
        }

        public static class Builder
        implements GraphLevel.Builder<ARGState> {
            private int width = 0;
            private final ImmutableIntArray.Builder targets = ImmutableIntArray.builder();
            private final ImmutableIntArray.Builder notExpanded = ImmutableIntArray.builder();
            private final ImmutableIntArray.Builder highlights = ImmutableIntArray.builder();
            private final ImmutableIntArray.Builder covered = ImmutableIntArray.builder();

            @Override
            public ARGLevel build() {
                return new ARGLevel(this.width, this.targets.build(), this.notExpanded.build(), this.highlights.build(), this.covered.build());
            }

            @CanIgnoreReturnValue
            public Builder addMarkings(ARGState pNode) {
                if (pNode.isTarget()) {
                    this.targets.add(this.width);
                }
                if (!pNode.wasExpanded()) {
                    this.notExpanded.add(this.width);
                }
                if (pNode.shouldBeHighlighted()) {
                    this.highlights.add(this.width);
                }
                if (pNode.isCovered()) {
                    this.covered.add(this.width);
                }
                return this;
            }

            @CanIgnoreReturnValue
            public Builder node() {
                ++this.width;
                return this;
            }
        }
    }
}

