/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.Traverser;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.DummyCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.GraphUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class ARGUtils {
    private ARGUtils() {
    }

    public static ImmutableSet<ARGState> getAllStatesOnPathsTo(ARGState pLastElement) {
        return ImmutableSet.copyOf((Iterable)Traverser.forGraph(ARGState::getParents).depthFirstPreOrder((Object)pLastElement));
    }

    public static ImmutableSet<ARGState> getRootStates(UnmodifiableReachedSet pReached) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (AbstractState e : pReached) {
            ARGState state = AbstractStates.extractStateByType(e, ARGState.class);
            if (state == null || !state.getParents().isEmpty()) continue;
            result.add((Object)state);
        }
        return result.build();
    }

    public static boolean hasAmbiguousBranching(ARGState pRootState, Set<ARGState> pRelevantStates) {
        Objects.requireNonNull(pRootState);
        if (!pRelevantStates.contains(pRootState)) {
            return false;
        }
        HashSet<ARGState> visited = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.push(pRootState);
        visited.add(pRootState);
        while (!waitlist.isEmpty()) {
            ARGState current = (ARGState)waitlist.pop();
            ImmutableList children = FluentIterable.from(current.getChildren()).filter(Predicates.in(pRelevantStates)).toList();
            if (children.size() > 2) {
                return true;
            }
            if (children.size() == 2) {
                ARGState firstChild = (ARGState)children.get(0);
                ARGState secondChild = (ARGState)children.get(1);
                List<CFAEdge> edgesToFirstChild = current.getEdgesToChild(firstChild);
                if (edgesToFirstChild.size() > 1) {
                    return true;
                }
                CFAEdge edgeToFirstChild = edgesToFirstChild.iterator().next();
                if (!(edgeToFirstChild instanceof AssumeEdge)) {
                    return true;
                }
                List<CFAEdge> edgesToSecondChild = current.getEdgesToChild(secondChild);
                if (edgesToSecondChild.size() > 1) {
                    return true;
                }
                CFAEdge edgeToSecondChild = edgesToSecondChild.iterator().next();
                if (!(edgeToSecondChild instanceof AssumeEdge)) {
                    return true;
                }
                if (!CFAUtils.getComplimentaryAssumeEdge((AssumeEdge)edgeToFirstChild).equals(edgeToSecondChild)) {
                    return true;
                }
            }
            for (ARGState child : children) {
                if (!visited.add(child)) continue;
                waitlist.push(child);
            }
        }
        return false;
    }

    public static ARGPath getOnePathTo(ARGState pLastElement) {
        return ARGUtils.getOnePathFromTo((Predicate<ARGState>)((Predicate)x -> x.getParents().isEmpty()), pLastElement);
    }

    public static Optional<ARGPath> getOnePathTo(ARGState pEndState, Collection<ARGPath> pOtherPathThan) {
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        HashSet<ARGState> seenElements = new HashSet<ARGState>();
        ARGState currentARGState = pEndState;
        CFANode currentLocation = AbstractStates.extractLocation(pEndState);
        states.add(currentARGState);
        seenElements.add(currentARGState);
        Collection<PathPosition> tracePrefixesToAvoid = Collections2.transform(pOtherPathThan, otherPath -> {
            PathPosition result = otherPath.reversePathIterator().getPosition();
            CFANode expectedPostfixLoc = AbstractStates.extractLocation(pEndState);
            Verify.verify((boolean)result.getLocation().equals(expectedPostfixLoc));
            return result;
        });
        tracePrefixesToAvoid = ARGUtils.getTracePrefixesBeforePostfix(tracePrefixesToAvoid, currentLocation);
        boolean lastTransitionIsDifferent = false;
        while (!currentARGState.getParents().isEmpty()) {
            ArrayList<ARGState> potentialParents = new ArrayList<ARGState>(currentARGState.getParents());
            if (!tracePrefixesToAvoid.isEmpty()) {
                potentialParents.addAll(currentARGState.getCoveredByThis());
            }
            Iterator parents = potentialParents.iterator();
            boolean uniqueParentFound = false;
            ARGState parentElement = (ARGState)parents.next();
            while (true) {
                if (!seenElements.add(parentElement) && parents.hasNext()) {
                    parentElement = (ARGState)parents.next();
                    continue;
                }
                uniqueParentFound = true;
                CFANode parentLocation = AbstractStates.extractLocation(parentElement);
                for (PathPosition t : tracePrefixesToAvoid) {
                    if (!t.getLocation().equals(parentLocation)) continue;
                    uniqueParentFound = false;
                    lastTransitionIsDifferent = false;
                    break;
                }
                lastTransitionIsDifferent = tracePrefixesToAvoid.isEmpty();
                if (uniqueParentFound || !parents.hasNext()) break;
            }
            states.add(parentElement);
            currentARGState = parentElement;
            currentLocation = AbstractStates.extractLocation(currentARGState);
            tracePrefixesToAvoid = ARGUtils.getTracePrefixesBeforePostfix(tracePrefixesToAvoid, currentLocation);
        }
        if (!lastTransitionIsDifferent) {
            return Optional.empty();
        }
        return Optional.of(new ARGPath(Lists.reverse(states)));
    }

    public static ARGPath getOnePathFromTo(Predicate<ARGState> pIsStart, ARGState pEnd) {
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        HashSet<ARGState> seenElements = new HashSet<ARGState>();
        ARGState currentARGState = pEnd;
        states.add(currentARGState);
        seenElements.add(currentARGState);
        ArrayDeque<ARGState> backTrackPoints = new ArrayDeque<ARGState>();
        ArrayDeque backTrackOptions = new ArrayDeque();
        while (!pIsStart.apply((Object)currentARGState)) {
            Iterator<ARGState> parents = currentARGState.getParents().iterator();
            ARGState parentElement = parents.next();
            while (!pIsStart.apply((Object)parentElement) && seenElements.contains(parentElement) && parents.hasNext()) {
                parentElement = parents.next();
            }
            if (!pIsStart.apply((Object)parentElement) && seenElements.contains(parentElement)) {
                Preconditions.checkArgument((!backTrackPoints.isEmpty() ? 1 : 0) != 0, (Object)"No ARG path from the target state to a root state.");
                ARGState backTrackPoint = (ARGState)backTrackPoints.pop();
                ListIterator stateIterator = states.listIterator(states.size());
                while (stateIterator.hasPrevious() && !((ARGState)stateIterator.previous()).equals(backTrackPoint)) {
                    stateIterator.remove();
                }
                List options = (List)backTrackOptions.pop();
                for (ARGState parent : backTrackPoint.getParents()) {
                    if (options.contains(parent)) continue;
                    seenElements.add(parent);
                }
                currentARGState = backTrackPoint;
                continue;
            }
            if (parents.hasNext()) {
                ArrayList<ARGState> options = new ArrayList<ARGState>(1);
                while (parents.hasNext()) {
                    ARGState parent = parents.next();
                    if (seenElements.contains(parent)) continue;
                    options.add(parent);
                }
                if (!options.isEmpty()) {
                    backTrackPoints.push(currentARGState);
                    backTrackOptions.push(options);
                }
            }
            seenElements.add(parentElement);
            states.add(parentElement);
            currentARGState = parentElement;
        }
        return new ARGPath(Lists.reverse(states));
    }

    public static ARGPath getShortestPathTo(ARGState pLastElement) {
        HashMap<ARGState, ARGState> searchTree = new HashMap<ARGState, ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        searchTree.put(pLastElement, null);
        waitlist.add(pLastElement);
        ARGState firstElement = null;
        while (!waitlist.isEmpty()) {
            ARGState currentState = (ARGState)waitlist.pop();
            for (ARGState parent : currentState.getParents()) {
                if (parent.getParents().isEmpty()) {
                    firstElement = parent;
                    searchTree.put(parent, currentState);
                    break;
                }
                if (searchTree.containsKey(parent)) continue;
                waitlist.add(parent);
                searchTree.put(parent, currentState);
            }
            if (firstElement == null) continue;
            break;
        }
        assert (firstElement != null) : "ARG seems to have no initial state (state without parents)!";
        ImmutableList.Builder path = ImmutableList.builder();
        while (firstElement != null) {
            path.add(firstElement);
            firstElement = (ARGState)searchTree.get(firstElement);
        }
        return new ARGPath((List<ARGState>)path.build());
    }

    public static Collection<PathPosition> getTracePrefixesBeforePostfix(Collection<PathPosition> pTracePosition, CFANode pPostfixLocation) {
        Preconditions.checkNotNull(pTracePosition);
        Preconditions.checkNotNull((Object)pPostfixLocation);
        ImmutableList.Builder result = ImmutableList.builder();
        for (PathPosition p : pTracePosition) {
            PathIterator it;
            if (!pPostfixLocation.equals(p.getLocation()) || !(it = p.reverseIterator()).hasNext()) continue;
            it.advance();
            result.add((Object)it.getPosition());
        }
        return result.build();
    }

    public static ARGPath getRandomPath(ARGState root) {
        Preconditions.checkArgument((boolean)root.getParents().isEmpty());
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        ARGState currentElement = root;
        while (!currentElement.getChildren().isEmpty()) {
            states.add(currentElement);
            currentElement = currentElement.getChildren().iterator().next();
        }
        states.add(currentElement);
        return new ARGPath(states);
    }

    private static boolean isRelevantLocation(CFANode pInput) {
        return pInput.isLoopStart() || pInput instanceof FunctionEntryNode || pInput instanceof FunctionExitNode;
    }

    public static boolean isRelevantState(ARGState state) {
        return AbstractStates.isTargetState(state) || Iterables.any(AbstractStates.extractLocations(state), ARGUtils::isRelevantLocation) || !state.wasExpanded() || state.shouldBeHighlighted();
    }

    public static SetMultimap<ARGState, ARGState> projectARG(ARGState root, Function<? super ARGState, ? extends Iterable<ARGState>> successorFunction, Predicate<? super ARGState> isRelevant) {
        return GraphUtils.projectARG(root, successorFunction, isRelevant);
    }

    public static ARGPath getPathFromBranchingInformation(ARGState root, Predicate<? super ARGState> stateFilter, BiFunction<ARGState, AssumeEdge, Boolean> branchingInformation) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)stateFilter.test((Object)root));
        ARGPathBuilder builder = ARGPath.builder();
        ARGState currentElement = root;
        while (!currentElement.isTarget()) {
            CFAEdge edge;
            ARGState child;
            ImmutableSet childrenInArg = FluentIterable.from(currentElement.getChildren()).filter(stateFilter).toSet();
            switch (childrenInArg.size()) {
                case 0: {
                    return builder.build(currentElement);
                }
                case 1: {
                    child = (ARGState)Iterables.getOnlyElement((Iterable)childrenInArg);
                    edge = currentElement.getEdgeToChild(child);
                    break;
                }
                case 2: {
                    AssumeEdge trueEdge = null;
                    AssumeEdge falseEdge = null;
                    ARGState trueChild = null;
                    ARGState falseChild = null;
                    Iterable<CFANode> locs = AbstractStates.extractLocations(currentElement);
                    if (Iterables.any(locs, loc -> !CFAUtils.leavingEdges(loc).allMatch(Predicates.instanceOf(AssumeEdge.class)))) {
                        throw new IllegalArgumentException("ARG branches where there is no AssumeEdge!");
                    }
                    for (ARGState currentChild : childrenInArg) {
                        CFAEdge currentEdge = currentElement.getEdgeToChild(currentChild);
                        if (((AssumeEdge)currentEdge).getTruthAssumption()) {
                            trueEdge = (AssumeEdge)currentEdge;
                            trueChild = currentChild;
                            continue;
                        }
                        falseEdge = (AssumeEdge)currentEdge;
                        falseChild = currentChild;
                    }
                    if (trueEdge == null || falseEdge == null) {
                        throw new IllegalArgumentException("ARG branches with non-complementary AssumeEdges!");
                    }
                    assert (trueChild != null);
                    assert (falseChild != null);
                    Boolean predValue = branchingInformation.apply(currentElement, trueEdge);
                    if (predValue == null) {
                        throw new IllegalArgumentException("ARG branches without direction information!");
                    }
                    if (predValue.booleanValue()) {
                        edge = trueEdge;
                        child = trueChild;
                        break;
                    }
                    edge = falseEdge;
                    child = falseChild;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ARG splits with more than two branches!");
                }
            }
            Preconditions.checkArgument((boolean)stateFilter.test((Object)child), (Object)"ARG and direction information from solver disagree!");
            builder.add(currentElement, edge);
            currentElement = child;
        }
        return builder.build(currentElement);
    }

    public static Collection<ARGState> getUncoveredChildrenView(final ARGState s) {
        return new AbstractCollection<ARGState>(){

            @Override
            public Iterator<ARGState> iterator() {
                return new UnmodifiableIterator<ARGState>(){
                    private final Iterator<ARGState> children;
                    {
                        this.children = s.getChildren().iterator();
                    }

                    public boolean hasNext() {
                        return this.children.hasNext();
                    }

                    public ARGState next() {
                        ARGState child = this.children.next();
                        if (child.isCovered()) {
                            return (ARGState)Preconditions.checkNotNull((Object)child.getCoveringState());
                        }
                        return child;
                    }
                };
            }

            @Override
            public int size() {
                return s.getChildren().size();
            }
        };
    }

    public static boolean checkARG(ReachedSet pReached) {
        for (ARGState e : FluentIterable.from((Iterable)pReached).transform(AbstractStates.toState(ARGState.class))) {
            assert (e != null) : "Reached set contains abstract state without ARGState.";
            assert (!e.isDestroyed()) : "Reached set contains destroyed ARGState, which should have been removed.";
            for (ARGState parent : e.getParents()) {
                assert (parent.getChildren().contains(e)) : "Reference from parent to child is missing in ARG";
                assert (pReached.contains(parent)) : "Referenced parent is missing in reached";
            }
            for (ARGState child : e.getChildren()) {
                assert (child.getParents().contains(e)) : "Reference from child to parent is missing in ARG";
                if (!pReached.contains(child)) assert (child.isCovered() && child.getChildren().isEmpty() || pReached.getWaitlist().containsAll(child.getParents())) : "Referenced child is missing in reached set.";
            }
        }
        return true;
    }

    public static void producePathAutomaton(Appendable sb, List<ARGPath> pPaths, String name, @Nullable CounterexampleInfo pCounterExample) throws IOException {
        ARGState rootState = pPaths.iterator().next().getFirstState();
        ImmutableSetMultimap<ARGState, CFAEdgeWithAssumptions> valueMap = ImmutableListMultimap.of();
        if (pCounterExample != null && pCounterExample.isPreciseCounterExample()) {
            valueMap = pCounterExample.getExactVariableValues();
        }
        int index = 0;
        Function<ARGState, String> getLocationName = s -> Joiner.on((String)"_OR_").join(AbstractStates.extractLocations(s));
        Function<Integer, Function> getStateNameFunction = i -> s -> "S" + i + "at" + (String)getLocationName.apply((ARGState)s);
        sb.append("CONTROL AUTOMATON " + name + "\n\n");
        String stateName = (String)getStateNameFunction.apply(index).apply(rootState);
        sb.append("INITIAL STATE " + stateName + ";\n\n");
        for (ARGPath path : pPaths) {
            PathIterator pathIterator = path.fullPathIterator();
            while (pathIterator.advanceIfPossible()) {
                stateName = (String)getStateNameFunction.apply(index).apply(pathIterator.getPreviousAbstractState());
                ++index;
                sb.append("STATE USEFIRST " + stateName + " :\n");
                ARGState child = pathIterator.getAbstractState();
                CFAEdge edge = pathIterator.getIncomingEdge();
                ARGUtils.handleMatchCase(sb, edge);
                if (child.isTarget()) {
                    sb.append("ERROR");
                } else {
                    ARGUtils.addAssumption(valueMap, pathIterator.getPreviousAbstractState(), edge, sb);
                    stateName = (String)getStateNameFunction.apply(index).apply(child);
                    sb.append("GOTO " + stateName);
                }
                sb.append(";\n");
                sb.append("    TRUE -> STOP;\n\n");
            }
        }
        sb.append("END AUTOMATON\n");
    }

    public static void producePathAutomaton(Appendable sb, ARGState pRootState, Set<ARGState> pPathStates, String name, @Nullable CounterexampleInfo pCounterExample) throws IOException {
        ImmutableSetMultimap<ARGState, CFAEdgeWithAssumptions> valueMap = ImmutableListMultimap.of();
        if (pCounterExample != null && pCounterExample.isPreciseCounterExample()) {
            valueMap = pCounterExample.getExactVariableValues();
        }
        sb.append("CONTROL AUTOMATON " + name + "\n\n");
        sb.append("INITIAL STATE ARG" + pRootState.getStateId() + ";\n\n");
        int multiEdgeCount = 0;
        for (ARGState s : ImmutableList.sortedCopyOf(pPathStates)) {
            sb.append("STATE USEFIRST ARG" + s.getStateId() + " :\n");
            for (ARGState child : s.getChildren()) {
                CFAEdge edge;
                if (child.isCovered()) {
                    child = child.getCoveringState();
                    assert (!child.isCovered());
                }
                if (!pPathStates.contains(child)) continue;
                List<CFAEdge> allEdges = s.getEdgesToChild(child);
                if (allEdges.isEmpty()) {
                    edge = new DummyCFAEdge(AbstractStates.extractLocation(s), AbstractStates.extractLocation(child));
                } else if (allEdges.size() == 1) {
                    edge = (CFAEdge)Iterables.getOnlyElement(allEdges);
                } else {
                    int i;
                    ++multiEdgeCount;
                    sb.append("    MATCH \"");
                    ARGUtils.escape(allEdges.get(i).getRawStatement(), sb);
                    sb.append("\" -> ");
                    sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                    sb.append(";\n");
                    for (i = 0; i < allEdges.size() - 1; ++i) {
                        sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                        sb.append("    MATCH \"");
                        ARGUtils.escape(allEdges.get(i).getRawStatement(), sb);
                        sb.append("\" -> ");
                        sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                        sb.append(";\n");
                    }
                    edge = allEdges.get(i);
                    sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                }
                ARGUtils.handleMatchCase(sb, edge);
                if (child.isTarget()) {
                    sb.append("ERROR");
                } else {
                    ARGUtils.addAssumption(valueMap, s, edge, sb);
                    sb.append("GOTO ARG" + child.getStateId());
                }
                sb.append(";\n");
            }
            sb.append("    TRUE -> STOP;\n\n");
        }
        sb.append("END AUTOMATON\n");
    }

    public static void producePathAutomatonWithLoops(Appendable sb, ARGState pRootState, Set<ARGState> pPathStates, String name, Set<LoopStructure.Loop> loopsToUproll) throws IOException {
        sb.append("CONTROL AUTOMATON " + name + "\n\n");
        sb.append("INITIAL STATE ARG" + pRootState.getStateId() + ";\n\n");
        int multiEdgeCount = 0;
        ARGState inLoopState = null;
        ARGState outLoopState = null;
        ARGState inFunctionState = null;
        ARGState outFunctionState = null;
        HashMap<ARGState, ARGState> inToOutLoopMap = new HashMap<ARGState, ARGState>();
        HashMap<ARGState, ARGState> inToOutFunctionsMap = new HashMap<ARGState, ARGState>();
        CFANode inLoopNode = null;
        CFANode inFunctionNode = null;
        ImmutableList sortedStates = ImmutableList.sortedCopyOf(pPathStates);
        ArrayDeque<String> sortedFunctionOccurrence = new ArrayDeque<String>();
        for (ARGState aRGState : sortedStates) {
            CFANode node = AbstractStates.extractLocation(aRGState);
            if (!sortedFunctionOccurrence.isEmpty() && ((String)sortedFunctionOccurrence.getLast()).equals(node.getFunctionName())) continue;
            sortedFunctionOccurrence.add(node.getFunctionName());
        }
        for (ARGState aRGState : sortedStates) {
            CFANode loc = AbstractStates.extractLocation(aRGState);
            boolean loopFound = false;
            for (LoopStructure.Loop loop : loopsToUproll) {
                if (!loop.getLoopNodes().contains((Object)loc)) continue;
                loopFound = true;
                break;
            }
            if (loopFound && inLoopState == null) {
                inLoopState = aRGState;
                inLoopNode = AbstractStates.extractLocation(inLoopState);
                outLoopState = null;
                continue;
            }
            if (!loopFound && inLoopNode != null && !inLoopNode.getFunctionName().equals(AbstractStates.extractLocation(aRGState).getFunctionName())) continue;
            if (!loopFound && inLoopNode == null && loc.getLeavingSummaryEdge() != null && inFunctionState == null && ((String)sortedFunctionOccurrence.getFirst()).equals(sortedFunctionOccurrence.getLast()) && sortedFunctionOccurrence.size() > 1) {
                inFunctionState = aRGState;
                inFunctionNode = AbstractStates.extractLocation(inFunctionState);
                outFunctionState = null;
                continue;
            }
            if (inFunctionNode != null && !inFunctionNode.getFunctionName().equals(AbstractStates.extractLocation(aRGState).getFunctionName()) || loopFound) continue;
            if (inLoopState != null && outLoopState == null) {
                outLoopState = aRGState;
                inToOutLoopMap.put(inLoopState, outLoopState);
                inLoopNode = null;
                inLoopState = null;
            }
            if (inFunctionState != null && outFunctionState == null) {
                outFunctionState = aRGState;
                inToOutFunctionsMap.put(inFunctionState, outFunctionState);
                inFunctionNode = null;
                inFunctionState = null;
            }
            if (!((String)sortedFunctionOccurrence.getFirst()).equals(AbstractStates.extractLocation(aRGState).getFunctionName())) {
                sortedFunctionOccurrence.removeFirst();
            }
            sb.append("STATE USEFIRST ARG" + aRGState.getStateId() + " :\n");
            if (!loopFound) {
                for (ARGState child : aRGState.getChildren()) {
                    CFAEdge edge;
                    if (child.isCovered()) {
                        child = child.getCoveringState();
                        assert (!child.isCovered());
                    }
                    if (!pPathStates.contains(child)) continue;
                    List<CFAEdge> allEdges = aRGState.getEdgesToChild(child);
                    if (allEdges.size() == 1) {
                        edge = (CFAEdge)Iterables.getOnlyElement(allEdges);
                    } else {
                        int i;
                        ++multiEdgeCount;
                        sb.append("    MATCH \"");
                        ARGUtils.escape(allEdges.get(i).getRawStatement(), sb);
                        sb.append("\" -> ");
                        sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                        sb.append(";\n");
                        for (i = 0; i < allEdges.size() - 1; ++i) {
                            sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                            sb.append("    MATCH \"");
                            ARGUtils.escape(allEdges.get(i).getRawStatement(), sb);
                            sb.append("\" -> ");
                            sb.append("GOTO ARG" + child.getStateId() + "_" + (i + 1) + "_" + multiEdgeCount);
                            sb.append(";\n");
                        }
                        edge = allEdges.get(i);
                        sb.append("STATE USEFIRST ARG" + child.getStateId() + "_" + i + "_" + multiEdgeCount + " :\n");
                    }
                    ARGUtils.handleMatchCase(sb, edge);
                    if (child.isTarget()) {
                        sb.append("ERROR");
                    } else {
                        sb.append("GOTO ARG" + child.getStateId());
                    }
                    sb.append(";\n");
                }
            }
            sb.append("    TRUE -> STOP;\n\n");
        }
        for (Map.Entry entry : inToOutLoopMap.entrySet()) {
            ARGState intoLoopState = (ARGState)entry.getKey();
            ARGState outOfLoopState = (ARGState)entry.getValue();
            ARGUtils.handleLoop(sb, loopsToUproll, intoLoopState, outOfLoopState);
        }
        for (Map.Entry entry : inToOutFunctionsMap.entrySet()) {
            ARGState intoFunctionState = (ARGState)entry.getKey();
            ARGState outOfFunctionState = (ARGState)entry.getValue();
            ARGUtils.handleFunctionCall(sb, intoFunctionState, outOfFunctionState);
        }
        if (inLoopState != null) {
            ARGUtils.handleLoop(sb, loopsToUproll, inLoopState, null);
        }
        sb.append("END AUTOMATON\n");
    }

    private static void handleFunctionCall(Appendable sb, ARGState callState, ARGState returnState) throws IOException {
        FunctionSummaryEdge sumEdge = AbstractStates.extractLocation(callState).getLeavingSummaryEdge();
        CFANode sumEdgePredecessor = sumEdge.getPredecessor();
        sb.append("STATE USEFIRST ARG").append(Integer.toString(callState.getStateId())).append(" :\n").append("    TRUE -> ");
        ARGUtils.handleGotoNode(sb, sumEdgePredecessor, true);
        ARGUtils.handleUseFirstNode(sb, sumEdgePredecessor, true);
        sb.append("    ( CHECK(location, \"functionname==").append(sumEdgePredecessor.getFunctionName()).append("\")) -> ");
        ARGUtils.handleGotoArg(sb, returnState);
        sb.append("    TRUE -> ");
        ARGUtils.handleGotoNode(sb, sumEdgePredecessor, true);
        sb.append("\n");
    }

    private static void handleLoop(Appendable sb, Set<LoopStructure.Loop> loopsToUproll, ARGState intoLoopState, ARGState outOfLoopState) throws IOException {
        HashSet<CFANode> handledNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> nodesToHandle = new ArrayDeque<CFANode>();
        CFANode loopHead = AbstractStates.extractLocation(intoLoopState);
        nodesToHandle.offer(loopHead);
        boolean isFirstLoopIteration = true;
        while (!nodesToHandle.isEmpty()) {
            CFANode curNode = (CFANode)nodesToHandle.poll();
            if (!handledNodes.add(curNode)) continue;
            if (isFirstLoopIteration) {
                sb.append("STATE USEFIRST ARG").append(Integer.toString(intoLoopState.getStateId())).append(" :\n");
                isFirstLoopIteration = false;
            } else {
                ARGUtils.handleUseFirstNode(sb, curNode, false);
            }
            for (CFAEdge edge : CFAUtils.leavingEdges(curNode)) {
                CFANode edgeSuccessor = edge.getSuccessor();
                if (edge instanceof FunctionCallEdge) {
                    FunctionSummaryEdge sumEdge = ((FunctionCallEdge)edge).getSummaryEdge();
                    CFANode sumEdgeSuccessor = sumEdge.getSuccessor();
                    if (!sumEdgeSuccessor.equals(loopHead)) {
                        nodesToHandle.offer(sumEdgeSuccessor);
                    }
                    sb.append("    TRUE -> ");
                    ARGUtils.handleGotoNode(sb, curNode, true);
                    ARGUtils.handleUseFirstNode(sb, curNode, true);
                    sb.append("    ( CHECK(location, \"functionname==").append(sumEdge.getPredecessor().getFunctionName()).append("\")) -> ");
                    ARGUtils.handlePossibleOutOfLoopSuccessor(sb, intoLoopState, loopHead, sumEdgeSuccessor);
                    sb.append("    TRUE -> ");
                    ARGUtils.handleGotoNode(sb, curNode, true);
                    continue;
                }
                boolean stillInLoop = false;
                for (LoopStructure.Loop loop : loopsToUproll) {
                    if (!loop.getLoopNodes().contains((Object)edgeSuccessor)) continue;
                    stillInLoop = true;
                    break;
                }
                ARGUtils.handleMatchCase(sb, edge);
                if (stillInLoop && !edgeSuccessor.equals(loopHead)) {
                    ARGUtils.handleGotoNode(sb, edgeSuccessor, false);
                    nodesToHandle.offer(edgeSuccessor);
                    continue;
                }
                if (stillInLoop) {
                    ARGUtils.handleGotoArg(sb, intoLoopState);
                    continue;
                }
                if (outOfLoopState == null || !AbstractStates.extractLocation(outOfLoopState).equals(edgeSuccessor)) {
                    sb.append("STOP;\n");
                    continue;
                }
                ARGUtils.handleGotoArg(sb, outOfLoopState);
            }
            sb.append("    TRUE -> STOP;\n\n");
        }
    }

    private static void handleMatchCase(Appendable sb, CFAEdge edge) throws IOException {
        sb.append("    MATCH \"");
        ARGUtils.escape(edge.getRawStatement(), sb);
        sb.append("\" -> ");
    }

    private static void handleUseFirstNode(Appendable sb, CFANode node, boolean isFunctionSink) throws IOException {
        sb.append("STATE USEFIRST NODE").append(Integer.toString(node.getNodeNumber()));
        if (isFunctionSink) {
            sb.append("_FUNCTIONSINK");
        }
        sb.append(" :\n");
    }

    private static void handleGotoArg(Appendable sb, ARGState state) throws IOException {
        sb.append("GOTO ARG").append(Integer.toString(state.getStateId())).append(";\n");
    }

    private static void handleGotoNode(Appendable sb, CFANode node, boolean isFunctionSink) throws IOException {
        sb.append("GOTO NODE").append(Integer.toString(node.getNodeNumber()));
        if (isFunctionSink) {
            sb.append("_FUNCTIONSINK");
        }
        sb.append(";\n");
    }

    private static void handlePossibleOutOfLoopSuccessor(Appendable sb, ARGState intoLoopState, CFANode loopHead, CFANode successor) throws IOException {
        if (successor.equals(loopHead)) {
            ARGUtils.handleGotoArg(sb, intoLoopState);
        } else {
            ARGUtils.handleGotoNode(sb, successor, false);
        }
    }

    private static void addAssumption(Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, ARGState pState, CFAEdge pEdge, Appendable sb) throws IOException {
        Iterable assumptions = pValueMap.get((Object)pState);
        if (Iterables.isEmpty((Iterable)(assumptions = Iterables.filter((Iterable)assumptions, a -> a.getCFAEdge().equals(pEdge))))) {
            return;
        }
        ARGUtils.addAssumption((CFAEdgeWithAssumptions)Iterables.getOnlyElement((Iterable)assumptions), sb);
    }

    private static void addAssumption(CFAEdgeWithAssumptions pCFAEdgeWithAssignments, Appendable sb) throws IOException {
        String code;
        if (pCFAEdgeWithAssignments != null && !(code = pCFAEdgeWithAssignments.getAsCode()).isEmpty()) {
            sb.append("ASSUME {" + code + "} ");
        }
    }

    private static void escape(String s, Appendable appendTo) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    appendTo.append("\\n");
                    continue block6;
                }
                case '\r': {
                    appendTo.append("\\r");
                    continue block6;
                }
                case '\"': {
                    appendTo.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    appendTo.append("\\\\");
                    continue block6;
                }
                default: {
                    appendTo.append(c);
                }
            }
        }
    }

    public static Optional<CounterexampleInfo> tryGetOrCreateCounterexampleInformation(ARGState pTargetState, ConfigurableProgramAnalysis pCPA, AssumptionToEdgeAllocator pAssumptionToEdgeAllocator) {
        CFAPathWithAssumptions assignments;
        Optional<CounterexampleInfo> cex = pTargetState.getCounterexampleInformation();
        Objects.requireNonNull(pCPA);
        Objects.requireNonNull(pAssumptionToEdgeAllocator);
        if (cex.isPresent()) {
            return cex;
        }
        ARGPath path = ARGUtils.getOnePathTo(pTargetState);
        if (path.getFullPath().isEmpty()) {
            return Optional.empty();
        }
        CFAPathWithAdditionalInfo additionalInfo = CFAPathWithAdditionalInfo.of(path, pCPA);
        ImmutableSet<ARGState> states = path.getStateSet();
        if (states.stream().allMatch(s -> states.containsAll(s.getParents())) && !(assignments = CFAPathWithAssumptions.of(path, pCPA, pAssumptionToEdgeAllocator)).isEmpty()) {
            return Optional.of(CounterexampleInfo.feasiblePrecise(path, assignments, additionalInfo));
        }
        return Optional.of(CounterexampleInfo.feasibleImprecise(path, additionalInfo));
    }

    public static FluentIterable<ARGState> getNonCoveredStatesInSubgraph(ARGState pRoot) {
        return pRoot.getSubgraph().filter(s -> !s.isCovered());
    }

    public static Set<ARGPath> getAllPaths(ReachedSet pReachedSet, ARGState pStart) {
        ARGState root = AbstractStates.extractStateByType(pReachedSet.getFirstState(), ARGState.class);
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        ImmutableSet.Builder results = ImmutableSet.builder();
        ArrayList<ArrayList<ARGState>> paths = new ArrayList<ArrayList<ARGState>>();
        states.add(pStart);
        paths.add(states);
        while (!paths.isEmpty()) {
            List curPath = (List)paths.remove(paths.size() - 1);
            Preconditions.checkNotNull((Object)curPath);
            if (curPath.get(curPath.size() - 1) == root) {
                results.add((Object)new ARGPath(Lists.reverse((List)curPath)));
                continue;
            }
            for (ARGState parentElement : ((ARGState)curPath.get(curPath.size() - 1)).getParents()) {
                ImmutableList.Builder tmp = ImmutableList.builderWithExpectedSize((int)(curPath.size() + 1));
                tmp.addAll((Iterable)curPath);
                tmp.add((Object)parentElement);
                paths.add((ArrayList<ARGState>)tmp.build());
            }
        }
        return results.build();
    }
}

