/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.CPAs;

public class AbstractARGBasedRefiner
implements Refiner,
StatisticsProvider {
    private int refinementNumber;
    private final ARGBasedRefiner refiner;
    protected final ARGCPA argCpa;
    private final LogManager logger;

    protected AbstractARGBasedRefiner(AbstractARGBasedRefiner pAbstractARGBasedRefiner) {
        this.refiner = pAbstractARGBasedRefiner.refiner;
        this.argCpa = pAbstractARGBasedRefiner.argCpa;
        this.logger = pAbstractARGBasedRefiner.logger;
    }

    protected AbstractARGBasedRefiner(ARGBasedRefiner pRefiner, ARGCPA pCpa, LogManager pLogger) {
        this.refiner = pRefiner;
        this.argCpa = pCpa;
        this.logger = pLogger;
    }

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        return AbstractARGBasedRefiner.forARGBasedRefiner((rs, path) -> CounterexampleInfo.feasibleImprecise(path), pCpa);
    }

    public static Refiner forARGBasedRefiner(ARGBasedRefiner pRefiner, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        Preconditions.checkArgument((!(pRefiner instanceof Refiner) ? 1 : 0) != 0, (Object)"ARGBasedRefiners may not implement Refiner, choose between these two!");
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, Refiner.class);
        return new AbstractARGBasedRefiner(pRefiner, argCpa, argCpa.getLogger());
    }

    @Override
    public final boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        CounterexampleInfo counterexample;
        this.logger.log(Level.FINEST, new Object[]{"Starting ARG based refinement"});
        assert (ARGUtils.checkARG(pReached)) : "ARG and reached set do not match before refinement";
        ARGState lastElement = (ARGState)pReached.getLastState();
        assert (lastElement.isTarget()) : "Last element in reached is not a target state before refinement";
        ARGReachedSet reached = new ARGReachedSet(pReached, this.argCpa, this.refinementNumber++);
        @Nullable ARGPath path = this.computePath(lastElement, reached);
        if (this.logger.wouldBeLogged(Level.ALL) && path != null) {
            this.logger.log(Level.ALL, new Object[]{"Error path:\n", path});
            this.logger.log(Level.ALL, new Object[]{"Function calls on Error path:\n", Joiner.on((String)"\n ").join(Iterables.filter(path.getFullPath(), CFunctionCallEdge.class))});
        }
        try {
            counterexample = this.performRefinementForPath(reached, path);
        }
        catch (RefinementFailedException e) {
            if (e.getErrorPath() == null) {
                e.setErrorPath(path);
            }
            lastElement.addCounterexampleInformation(CounterexampleInfo.feasibleImprecise(e.getErrorPath()));
            throw e;
        }
        assert (ARGUtils.checkARG(pReached)) : "ARG and reached set do not match after refinement";
        if (!counterexample.isSpurious()) {
            ARGPath targetPath = counterexample.getTargetPath();
            assert (path != null) : "Counterexample should come from a correct path.";
            assert (Objects.equals(targetPath.getFirstState(), path.getFirstState())) : "Target path from refiner does not contain root node";
            assert (Objects.equals(targetPath.getLastState(), path.getLastState())) : "Target path from refiner does not contain target state";
            lastElement.addCounterexampleInformation(counterexample);
            this.logger.log(Level.FINEST, new Object[]{"Counterexample", counterexample.getUniqueId(), "has been found."});
            this.argCpa.getARGExporter().exportCounterexampleOnTheFly(lastElement, counterexample);
        }
        this.logger.log(Level.FINEST, new Object[]{"ARG based refinement finished, result is", counterexample.isSpurious()});
        return counterexample.isSpurious();
    }

    protected CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath pPath) throws CPAException, InterruptedException {
        this.argCpa.getARGExporter().exportCounterexampleOnTheFly(pReached.asReachedSet());
        return this.refiner.performRefinementForPath(pReached, pPath);
    }

    @ForOverride
    protected @Nullable ARGPath computePath(ARGState pLastElement, ARGReachedSet pReached) throws InterruptedException, CPATransferException {
        return ARGUtils.getOnePathTo(pLastElement);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.refiner instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.refiner)).collectStatistics(pStatsCollection);
        }
    }

    public String toString() {
        return this.refiner.toString();
    }
}

