/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.util.Pair;

public final class ErrorPathShrinker {
    private Deque<Pair<CFAEdgeWithAssumptions, Boolean>> shortPath;
    private Set<String> importantVars;
    private CFAEdge currentCFAEdge;
    private CFAEdgeWithAssumptions currentCFAEdgeWithAssumptions;
    private ImmutableSet.Builder<AExpressionStatement> assumptions;

    public ImmutableList<Pair<CFAEdgeWithAssumptions, Boolean>> shrinkErrorPath(ARGPath pTargetPath, CFAPathWithAssumptions pAssumePath) {
        List<CFAEdge> targetPath = pTargetPath.getFullPath();
        List assumePath = null;
        if (pAssumePath != null) {
            assumePath = pAssumePath.subList(0, targetPath.size());
        }
        Iterator revIterator = Lists.reverse(targetPath).iterator();
        Iterator<CFAEdgeWithAssumptions> revAssumIterator = null;
        if (assumePath != null) {
            revAssumIterator = Lists.reverse((List)assumePath).iterator();
        }
        this.importantVars = new HashSet<String>();
        this.assumptions = ImmutableSet.builder();
        ArrayDeque<Pair<CFAEdgeWithAssumptions, Boolean>> shortErrorPath = new ArrayDeque<Pair<CFAEdgeWithAssumptions, Boolean>>();
        while (revIterator.hasNext()) {
            this.handleEdge((CFAEdge)revIterator.next(), shortErrorPath, revAssumIterator);
        }
        return ImmutableList.copyOf(shortErrorPath);
    }

    private void handleEdge(CFAEdge cfaEdge, Deque<Pair<CFAEdgeWithAssumptions, Boolean>> shortErrorPath, @Nullable Iterator<CFAEdgeWithAssumptions> revAssumIterator) {
        this.currentCFAEdge = cfaEdge;
        this.shortPath = shortErrorPath;
        this.currentCFAEdgeWithAssumptions = new CFAEdgeWithAssumptions(this.currentCFAEdge, (ImmutableCollection<AExpressionStatement>)this.assumptions.build(), "");
        if (revAssumIterator != null && revAssumIterator.hasNext()) {
            CFAEdgeWithAssumptions nextRevAssumEdge = revAssumIterator.next();
            this.assumptions.addAll(nextRevAssumEdge.getExpStmts());
            this.currentCFAEdgeWithAssumptions = new CFAEdgeWithAssumptions(this.currentCFAEdge, (ImmutableCollection<AExpressionStatement>)nextRevAssumEdge.getExpStmts(), "");
        }
        if (this.currentCFAEdgeWithAssumptions != null) {
            Pair<CFAEdgeWithAssumptions, Boolean> normalPair = Pair.of(this.currentCFAEdgeWithAssumptions, Boolean.FALSE);
            this.shortPath.addFirst(normalPair);
        }
        switch (cfaEdge.getEdgeType()) {
            case AssumeEdge: {
                this.handleAssumption(((AssumeEdge)cfaEdge).getExpression());
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge fnkCall = (FunctionCallEdge)cfaEdge;
                FunctionEntryNode succ = fnkCall.getSuccessor();
                this.handleFunctionCallEdge(fnkCall.getArguments(), succ.getFunctionParameters());
                break;
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge fnkReturnEdge = (FunctionReturnEdge)cfaEdge;
                FunctionSummaryEdge summaryEdge = fnkReturnEdge.getSummaryEdge();
                this.handleFunctionReturnEdge(fnkReturnEdge, summaryEdge.getExpression());
                break;
            }
            default: {
                this.handleSimpleEdge(cfaEdge);
            }
        }
    }

    private void handleSimpleEdge(CFAEdge cfaEdge) {
        switch (cfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                this.handleDeclarationEdge(((ADeclarationEdge)cfaEdge).getDeclaration());
                break;
            }
            case StatementEdge: {
                this.handleStatementEdge(((AStatementEdge)cfaEdge).getStatement());
                break;
            }
            case ReturnStatementEdge: {
                this.handleReturnStatementEdge((AReturnStatementEdge)cfaEdge);
                break;
            }
            case BlankEdge: {
                this.handleBlankEdge((BlankEdge)cfaEdge);
                break;
            }
            case CallToReturnEdge: {
                throw new AssertionError((Object)"function summaries not supported");
            }
            default: {
                throw new AssertionError((Object)"unknown edge type");
            }
        }
    }

    private void handleBlankEdge(BlankEdge cfaEdge) {
        assert (cfaEdge == this.currentCFAEdge);
        if (this.currentCFAEdge.getSuccessor().isLoopStart()) {
            this.addCurrentCFAEdgeToShortPath();
        }
    }

    private void handleReturnStatementEdge(AReturnStatementEdge returnEdge) {
        if (returnEdge.asAssignment().isPresent()) {
            AAssignment assignment = returnEdge.asAssignment().get();
            this.handleAssignmentToVariable(assignment.getLeftHandSide(), assignment.getRightHandSide());
        }
    }

    private void handleFunctionReturnEdge(FunctionReturnEdge fnkReturnEdge, AFunctionCall expression) {
        Optional<? extends AVariableDeclaration> returnVar;
        if (expression instanceof AFunctionCallAssignmentStatement && (returnVar = fnkReturnEdge.getFunctionEntry().getReturnVariable()).isPresent() && this.isImportant(returnVar.get())) {
            this.remove(returnVar.get());
            this.track(returnVar.get().getQualifiedName());
        }
    }

    private void handleFunctionCallEdge(List<? extends AExpression> arguments, List<? extends AParameterDeclaration> functionParameters) {
        this.addCurrentCFAEdgeToShortPath();
        for (int i = 0; i < functionParameters.size(); ++i) {
            AExpression arg = arguments.get(i);
            String paramName = functionParameters.get(i).getQualifiedName();
            if (!this.isImportant(paramName)) continue;
            this.remove(paramName);
            this.addAllVarsInExpToSet(arg);
        }
    }

    private void handleStatementEdge(AStatement statementExp) {
        if (statementExp instanceof AAssignment) {
            this.handleAssignmentToVariable(((AAssignment)((Object)statementExp)).getLeftHandSide(), ((AAssignment)((Object)statementExp)).getRightHandSide());
        } else if (statementExp instanceof AFunctionCall) {
            this.addCurrentCFAEdgeToShortPath();
        }
    }

    private void handleAssignmentToVariable(ALeftHandSide lParam, ARightHandSide rightExp) {
        if (this.isImportant(lParam)) {
            this.addCurrentCFAEdgeToShortPath();
            this.remove(lParam);
            this.addAllVarsInExpToSet(rightExp);
        }
    }

    private void handleDeclarationEdge(ADeclaration declaration) {
        if (declaration.getName() != null && this.isImportant(declaration)) {
            AInitializer init;
            this.addCurrentCFAEdgeToShortPath();
            if (declaration instanceof AVariableDeclaration && (init = ((AVariableDeclaration)declaration).getInitializer()) != null) {
                ArrayDeque<AInitializer> inits = new ArrayDeque<AInitializer>();
                inits.add(init);
                while (!inits.isEmpty()) {
                    init = (AInitializer)inits.pop();
                    if (init instanceof CInitializerExpression) {
                        this.addAllVarsInExpToSet(((CInitializerExpression)init).getExpression());
                        continue;
                    }
                    if (!(init instanceof CInitializerList)) continue;
                    inits.addAll(((CInitializerList)init).getInitializers());
                }
            }
            this.remove(declaration);
        }
    }

    private void handleAssumption(AExpression assumeExp) {
        if (!this.isSwitchStatement(assumeExp)) {
            this.addAllVarsInExpToSet(assumeExp);
            this.addCurrentCFAEdgeToShortPath();
        }
    }

    private boolean isSwitchStatement(AExpression assumeExp) {
        if (!this.shortPath.isEmpty() && this.shortPath.iterator().next().getSecond().booleanValue()) {
            AssumeEdge lastAss;
            AExpression lastExp;
            CFAEdge lastEdge = this.shortPath.getFirst().getFirst().getCFAEdge();
            if (assumeExp instanceof ABinaryExpression && lastEdge instanceof AssumeEdge && (lastExp = (lastAss = (AssumeEdge)lastEdge).getExpression()) instanceof ABinaryExpression) {
                CBinaryExpression.BinaryOperator op;
                AExpression currentBinExpOp1 = ((ABinaryExpression)assumeExp).getOperand1();
                AExpression lastBinExpOp1 = ((ABinaryExpression)lastExp).getOperand1();
                boolean isEqualVarName = currentBinExpOp1.toASTString().equals(lastBinExpOp1.toASTString());
                ABinaryExpression aLastExp = (ABinaryExpression)lastExp;
                boolean isEqualOp = aLastExp instanceof CBinaryExpression ? (op = (CBinaryExpression.BinaryOperator)aLastExp.getOperator()) == CBinaryExpression.BinaryOperator.EQUALS && lastAss.getTruthAssumption() || op == CBinaryExpression.BinaryOperator.NOT_EQUALS && !lastAss.getTruthAssumption() : (op = (JBinaryExpression.BinaryOperator)aLastExp.getOperator()) == JBinaryExpression.BinaryOperator.EQUALS && lastAss.getTruthAssumption() || op == JBinaryExpression.BinaryOperator.NOT_EQUALS && !lastAss.getTruthAssumption();
                return isEqualVarName && isEqualOp;
            }
        }
        return false;
    }

    private void addAllVarsInExpToSet(ARightHandSide exp) {
        if (!(exp instanceof ALiteralExpression) && !(exp instanceof AFunctionCallExpression) && exp != null) {
            if (exp instanceof AIdExpression) {
                this.track((AIdExpression)exp);
            } else if (exp instanceof CCastExpression) {
                this.addAllVarsInExpToSet(((CCastExpression)exp).getOperand());
            } else if (exp instanceof AUnaryExpression) {
                this.addAllVarsInExpToSet(((AUnaryExpression)exp).getOperand());
            } else if (exp instanceof ABinaryExpression) {
                ABinaryExpression binExp = (ABinaryExpression)exp;
                this.addAllVarsInExpToSet(binExp.getOperand1());
                this.addAllVarsInExpToSet(binExp.getOperand2());
            } else if (exp instanceof CFieldReference) {
                this.track((CFieldReference)exp);
            }
        }
    }

    private boolean isImportant(AExpression exp) {
        return this.isImportant(this.str(exp));
    }

    private boolean isImportant(ASimpleDeclaration exp) {
        return this.isImportant(exp.getQualifiedName());
    }

    private boolean isImportant(String var) {
        return this.importantVars.contains(var);
    }

    private void track(AExpression exp) {
        this.track(this.str(exp));
    }

    private void track(String var) {
        this.importantVars.add(var);
    }

    private void remove(AExpression exp) {
        this.remove(this.str(exp));
    }

    private void remove(ASimpleDeclaration exp) {
        this.remove(exp.getQualifiedName());
    }

    private void remove(String var) {
        this.importantVars.remove(var);
    }

    private String str(AExpression exp) {
        if (exp instanceof AIdExpression) {
            return ((AIdExpression)exp).getDeclaration().getQualifiedName();
        }
        return exp.toASTString();
    }

    private void addCurrentCFAEdgeToShortPath() {
        if (this.shortPath.getFirst().getFirst() == this.currentCFAEdgeWithAssumptions) {
            this.shortPath.removeFirst();
        }
        this.assumptions.addAll(this.currentCFAEdgeWithAssumptions.getExpStmts());
        Pair<CFAEdgeWithAssumptions, Boolean> importantPair = Pair.of(new CFAEdgeWithAssumptions(this.currentCFAEdgeWithAssumptions.getCFAEdge(), (ImmutableCollection<AExpressionStatement>)this.assumptions.build(), this.currentCFAEdgeWithAssumptions.getComment()), Boolean.TRUE);
        this.assumptions = ImmutableSet.builder();
        this.shortPath.addFirst(importantPair);
    }
}

