/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class StronglyConnectedComponent {
    private final ARGState rootNode;
    private final Deque<ARGState> nodes = new ArrayDeque<ARGState>();

    public StronglyConnectedComponent(ARGState pRootnode) {
        this.rootNode = pRootnode;
    }

    public ARGState getRootNode() {
        return this.rootNode;
    }

    public ImmutableList<ARGState> getNodes() {
        return ImmutableList.copyOf(this.nodes);
    }

    public void addNode(ARGState pState) {
        if (this.nodes.contains(pState)) {
            throw new UnsupportedOperationException("nodes must not be added twice");
        }
        this.nodes.push(pState);
    }

    public boolean hasTargetStates() {
        return this.nodes.stream().anyMatch(ARGState::isTarget);
    }

    public String toString() {
        return String.format("[%s]", this.nodes.stream().map(x -> x.getStateId() + ":" + AbstractStates.extractLocation(x)).collect(Collectors.joining(", ")));
    }
}

