/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.counterexamples;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CounterexampleFilter;

public abstract class AbstractSetBasedCounterexampleFilter<T>
implements CounterexampleFilter {
    private final Set<T> foundCounterexamples = new HashSet<T>();

    protected AbstractSetBasedCounterexampleFilter(Configuration config, LogManager logger, ConfigurableProgramAnalysis cpa) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)cpa);
    }

    @Override
    public boolean isRelevant(CounterexampleInfo counterexample) throws InterruptedException {
        Optional<T> representation = this.getCounterexampleRepresentation((CounterexampleInfo)((Object)Preconditions.checkNotNull((Object)((Object)counterexample))));
        if (!representation.isPresent()) {
            return true;
        }
        boolean setChanged = this.foundCounterexamples.add(representation.orElseThrow());
        return setChanged;
    }

    @ForOverride
    protected abstract Optional<T> getCounterexampleRepresentation(CounterexampleInfo var1) throws InterruptedException;
}

