/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.counterexamples;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;

@Options(prefix="counterexample.export", deprecatedPrefix="cpa.arg.errorPath")
public final class CEXExportOptions {
    @Option(secure=true, name="enabled", deprecatedName="export", description="export counterexample to file, if one is found")
    private boolean exportErrorPath = true;
    @Option(secure=true, name="file", description="export counterexample as text file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathFile = PathTemplate.ofFormatString((String)"Counterexample.%d.txt");
    @Option(secure=true, name="core", description="export counterexample core as text file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathCoreFile = PathTemplate.ofFormatString((String)"Counterexample.%d.core.txt");
    @Option(secure=true, name="source", description="export counterexample as source file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathSourceFile = PathTemplate.ofFormatString((String)"Counterexample.%d.c");
    @Option(secure=true, name="exportAsSource", description="export counterexample as source file")
    private boolean exportSource = true;
    @Option(secure=true, name="graph", description="export counterexample as Dot/Graphviz visualization")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathDotFile = PathTemplate.ofFormatString((String)"Counterexample.%d.dot");
    @Option(secure=true, name="automaton", description="export counterexample as automaton")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathAutomatonFile = PathTemplate.ofFormatString((String)"Counterexample.%d.spc");
    @Option(secure=true, name="prefixCoverageFile", description="export counterexample coverage information, considering only spec prefix as covered (up until reaching __FALSE state in Assumption Automaton).")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    PathTemplate coveragePrefixTemplate = PathTemplate.ofFormatString((String)"Counterexample.%d.aa-prefix.coverage-info");
    @Option(secure=true, name="exportCounterexampleCoverage", description="export coverage information for every witness: requires using an Assumption Automaton as part of the specification. Lines are considered to be covered only when the path reaching the statement does not reach the __FALSE state in the Assumption Automaton.")
    private boolean exportCounterexampleCoverage = false;
    @Option(secure=true, name="exportWitness", description="export counterexample as witness/graphml file")
    private boolean exportWitness = true;
    @Option(secure=true, name="graphml", description="export counterexample witness as GraphML automaton")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathWitnessFile = PathTemplate.ofFormatString((String)"Counterexample.%d.graphml");
    @Option(secure=true, name="witnessGraph", description="export counterexample witness as Dot/Graphviz visualization")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate errorPathWitnessDotFile = PathTemplate.ofFormatString((String)"Counterexample.%d.witness.dot");
    @Option(secure=true, description="Export extended witness in addition to regular witness")
    private boolean exportExtendedWitness = false;
    @Option(secure=true, description="Extended witness with specific analysis information file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate extendedWitnessFile = PathTemplate.ofFormatString((String)"extendedWitness.%d.graphml");
    @Option(secure=true, name="exportHarness", description="export test harness")
    private boolean exportHarness = false;
    @Option(secure=true, name="harness", description="export test harness to file as code")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate testHarnessFile = PathTemplate.ofFormatString((String)"Counterexample.%d.harness.c");
    @Option(secure=true, name="exportTestCase", description="export test case that represents the counterexample. Further options can be set with options 'testcase.*'")
    private boolean exportTest = false;
    @Option(secure=true, name="exportAllFoundErrorPaths", description="export error paths to files immediately after they were found, including spurious error-paths before executing a refinement. Note that we do not track already exported error-paths and export them at every refinement as long as they are not removed from the reached-set. Most helpful for debugging refinements.")
    private boolean dumpAllFoundErrorPaths = false;
    @Option(secure=true, name="exportImmediately", description="export error paths to files immediately after they were found")
    private boolean dumpErrorPathImmediately = false;

    public CEXExportOptions(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
    }

    public boolean disabledCompletely() {
        return this.getAutomatonFile() == null && this.getCoreFile() == null && this.getCoveragePrefix() == null && this.getErrorPathFile() == null && this.getDotFile() == null && this.getSourceFile() == null && this.getTestHarnessFile() == null && this.getWitnessFile() == null && this.getExtendedWitnessFile() == null && !this.exportTest;
    }

    @Nullable PathTemplate getAutomatonFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.errorPathAutomatonFile;
    }

    @Nullable PathTemplate getCoreFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.errorPathCoreFile;
    }

    @Nullable PathTemplate getCoveragePrefix() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.exportCounterexampleCoverage ? this.coveragePrefixTemplate : null;
    }

    @Nullable PathTemplate getErrorPathFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.errorPathFile;
    }

    @Nullable PathTemplate getDotFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.errorPathDotFile;
    }

    @Nullable PathTemplate getSourceFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.exportSource ? this.errorPathSourceFile : null;
    }

    @Nullable PathTemplate getTestHarnessFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.exportHarness ? this.testHarnessFile : null;
    }

    @Nullable PathTemplate getWitnessFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.exportWitness ? this.errorPathWitnessFile : null;
    }

    @Nullable PathTemplate getWitnessDotFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.exportWitness ? this.errorPathWitnessDotFile : null;
    }

    @Nullable PathTemplate getExtendedWitnessFile() {
        if (!this.exportErrorPath) {
            return null;
        }
        return this.exportExtendedWitness ? this.extendedWitnessFile : null;
    }

    boolean exportToTest() {
        return this.exportTest;
    }

    public boolean dumpAllFoundErrorPaths() {
        return this.dumpAllFoundErrorPaths;
    }

    public boolean dumpErrorPathImmediately() {
        return this.dumpErrorPathImmediately;
    }
}

