/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.counterexamples;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGToDotWriter;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.ErrorPathShrinker;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CEXExportOptions;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.CounterexampleFilter;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.PathEqualityCounterexampleFilter;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.ExtendedWitnessExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessExporter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessToOutputFormatsUtils;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.coverage.CoverageCollector;
import org.sosy_lab.cpachecker.util.coverage.CoverageReportGcov;
import org.sosy_lab.cpachecker.util.cwriter.PathToCTranslator;
import org.sosy_lab.cpachecker.util.cwriter.PathToConcreteProgramTranslator;
import org.sosy_lab.cpachecker.util.harness.HarnessExporter;
import org.sosy_lab.cpachecker.util.testcase.TestCaseExporter;

@Options(prefix="counterexample.export", deprecatedPrefix="cpa.arg.errorPath")
public class CEXExporter {
    @Option(secure=true, name="compressWitness", description="compress the produced error-witness automata using GZIP compression.")
    private boolean compressWitness = true;
    @Option(secure=true, name="codeStyle", description="exports either CMBC format or a concrete path program")
    private CounterexampleExportType codeStyle = CounterexampleExportType.CBMC;
    @Option(secure=true, name="filters", description="Filter for irrelevant counterexamples to reduce the number of similar counterexamples reported. Only relevant with analysis.stopAfterError=false and counterexample.export.exportImmediately=true. Put the weakest and cheapest filter first, e.g., PathEqualityCounterexampleFilter.")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker.cpa.arg.counterexamples"})
    private List<CounterexampleFilter.Factory> cexFilterClasses = ImmutableList.of(PathEqualityCounterexampleFilter::new);
    private final CounterexampleFilter cexFilter;
    private final CEXExportOptions options;
    private final LogManager logger;
    private final WitnessExporter witnessExporter;
    private final ExtendedWitnessExporter extendedWitnessExporter;
    private final HarnessExporter harnessExporter;
    private TestCaseExporter testExporter;

    public CEXExporter(Configuration config, CEXExportOptions pOptions, LogManager pLogger, CFA cfa, ConfigurableProgramAnalysis cpa, WitnessExporter pWitnessExporter, ExtendedWitnessExporter pExtendedWitnessExporter) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.options = pOptions;
        this.logger = pLogger;
        this.witnessExporter = (WitnessExporter)Preconditions.checkNotNull((Object)pWitnessExporter);
        this.extendedWitnessExporter = (ExtendedWitnessExporter)Preconditions.checkNotNull((Object)pExtendedWitnessExporter);
        if (!this.options.disabledCompletely()) {
            this.cexFilter = CounterexampleFilter.createCounterexampleFilter(config, pLogger, cpa, this.cexFilterClasses);
            this.harnessExporter = new HarnessExporter(config, pLogger, cfa);
            this.testExporter = new TestCaseExporter(cfa, this.logger, config);
        } else {
            this.cexFilter = null;
            this.harnessExporter = null;
            this.testExporter = null;
        }
    }

    public void exportCounterexampleIfRelevant(ARGState pTargetState, CounterexampleInfo pCounterexampleInfo) throws InterruptedException {
        if (this.options.disabledCompletely()) {
            return;
        }
        if (this.cexFilter.isRelevant(pCounterexampleInfo)) {
            this.exportCounterexample(pTargetState, pCounterexampleInfo);
        } else {
            this.logger.log(Level.FINEST, new Object[]{"Skipping counterexample printing because it is similar to one of already printed."});
        }
    }

    public void exportCounterexample(ARGState targetState, CounterexampleInfo counterexample) {
        ImmutableSet<ARGState> pathElements;
        Appender pathProgram;
        int uniqueId;
        ARGState rootState;
        BiPredicate<ARGState, ARGState> isTargetPathEdge;
        block33: {
            ARGPath targetPath;
            block32: {
                Preconditions.checkNotNull((Object)targetState);
                Preconditions.checkNotNull((Object)((Object)counterexample));
                if (this.options.disabledCompletely()) {
                    return;
                }
                targetPath = counterexample.getTargetPath();
                isTargetPathEdge = BiPredicates.pairIn(ImmutableSet.copyOf(targetPath.getStatePairs()));
                rootState = targetPath.getFirstState();
                uniqueId = counterexample.getUniqueId();
                if (this.options.getCoveragePrefix() != null) {
                    Path outputPath = this.options.getCoveragePrefix().getPath(new Object[]{counterexample.getUniqueId()});
                    try (Writer gcovFile = IO.openOutputFile((Path)outputPath, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                        CoverageReportGcov.write(CoverageCollector.fromCounterexample(targetPath), gcovFile);
                    }
                    catch (IOException e) {
                        this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write coverage information for counterexample to file");
                    }
                }
                this.writeErrorPathFile(this.options.getErrorPathFile(), uniqueId, (Object)counterexample);
                if (this.options.getCoreFile() != null) {
                    ErrorPathShrinker pathShrinker = new ErrorPathShrinker();
                    CFAPathWithAssumptions targetPAssum = null;
                    if (counterexample.isPreciseCounterExample()) {
                        targetPAssum = counterexample.getCFAPathWithAssignments();
                    }
                    ImmutableList<Pair<CFAEdgeWithAssumptions, Boolean>> shrinkedErrorPath = pathShrinker.shrinkErrorPath(targetPath, targetPAssum);
                    ArrayList<CFAEdgeWithAssumptions> arrayList = new ArrayList<CFAEdgeWithAssumptions>();
                    Iterator iterator = shrinkedErrorPath.iterator();
                    while (iterator.hasNext()) {
                        Pair pair = (Pair)iterator.next();
                        if (!((Boolean)pair.getSecond()).booleanValue()) continue;
                        arrayList.add((CFAEdgeWithAssumptions)pair.getFirst());
                    }
                    this.writeErrorPathFile(this.options.getCoreFile(), uniqueId, Appenders.forIterable((Joiner)Joiner.on((char)'\n'), arrayList));
                }
                pathProgram = null;
                if (!counterexample.isPreciseCounterExample()) break block32;
                pathElements = targetPath.getStateSet();
                if (this.options.getSourceFile() == null) break block33;
                switch (this.codeStyle) {
                    case CONCRETE_EXECUTION: {
                        pathProgram = PathToConcreteProgramTranslator.translateSinglePath(targetPath, counterexample.getCFAPathWithAssignments());
                        break block33;
                    }
                    case CBMC: {
                        pathProgram = PathToCTranslator.translateSinglePath(targetPath);
                        break block33;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled case statement: " + this.codeStyle));
                    }
                }
            }
            pathElements = ARGUtils.getAllStatesOnPathsTo(targetState);
            if (this.options.getSourceFile() != null) {
                switch (this.codeStyle) {
                    case CONCRETE_EXECUTION: {
                        this.logger.log(Level.WARNING, new Object[]{"Cannot export imprecise counterexample to C code for concrete execution."});
                        break;
                    }
                    case CBMC: {
                        if (ARGUtils.hasAmbiguousBranching(rootState, pathElements)) {
                            pathProgram = PathToCTranslator.translateSinglePath(targetPath);
                            break;
                        }
                        pathProgram = PathToCTranslator.translatePaths(rootState, pathElements);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled case statement: " + this.codeStyle));
                    }
                }
            }
        }
        if (pathProgram != null) {
            this.writeErrorPathFile(this.options.getSourceFile(), uniqueId, pathProgram);
        }
        this.writeErrorPathFile(this.options.getDotFile(), uniqueId, pAppendable -> ARGToDotWriter.write(pAppendable, rootState, ARGState::getChildren, (Predicate<? super ARGState>)Predicates.in((Collection)pathElements), isTargetPathEdge));
        this.writeErrorPathFile(this.options.getAutomatonFile(), uniqueId, pAppendable -> ARGUtils.producePathAutomaton(pAppendable, rootState, pathElements, "ErrorPath" + uniqueId, counterexample));
        for (Pair pair : counterexample.getAllFurtherInformation()) {
            if (pair.getSecond() == null) continue;
            this.writeErrorPathFile((PathTemplate)pair.getSecond(), uniqueId, pair.getFirst());
        }
        try {
            Witness witness = this.witnessExporter.generateErrorWitness(rootState, (Predicate<? super ARGState>)Predicates.in(pathElements), isTargetPathEdge, counterexample);
            this.writeErrorPathFile(this.options.getWitnessFile(), uniqueId, pApp -> WitnessToOutputFormatsUtils.writeToGraphMl(witness, pApp), this.compressWitness);
            this.writeErrorPathFile(this.options.getWitnessDotFile(), uniqueId, pApp -> WitnessToOutputFormatsUtils.writeToDot(witness, pApp), this.compressWitness);
        }
        catch (InterruptedException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not export witness due to interruption");
        }
        if (this.options.getExtendedWitnessFile() != null) {
            try {
                Witness extWitness = this.extendedWitnessExporter.generateErrorWitness(rootState, (Predicate<? super ARGState>)Predicates.in(pathElements), isTargetPathEdge, counterexample);
                this.writeErrorPathFile(this.options.getExtendedWitnessFile(), uniqueId, pAppendable -> WitnessToOutputFormatsUtils.writeToGraphMl(extWitness, pAppendable), this.compressWitness);
            }
            catch (InterruptedException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not export witness due to interruption");
            }
        }
        this.writeErrorPathFile(this.options.getTestHarnessFile(), uniqueId, pAppendable -> this.harnessExporter.writeHarness(pAppendable, rootState, (Predicate<? super ARGState>)Predicates.in((Collection)pathElements), isTargetPathEdge, counterexample));
        if (this.options.exportToTest() && this.testExporter != null) {
            this.testExporter.writeTestCaseFiles(counterexample, Optional.empty());
        }
    }

    public void addVisitedLine(Map<Integer, Integer> visitedLines, int pLine) {
        Preconditions.checkArgument((pLine > 0 ? 1 : 0) != 0);
        if (visitedLines.containsKey(pLine)) {
            visitedLines.put(pLine, visitedLines.get(pLine) + 1);
        } else {
            visitedLines.put(pLine, 1);
        }
    }

    private void writeErrorPathFile(@Nullable PathTemplate template, int uniqueId, Object content) {
        this.writeErrorPathFile(template, uniqueId, content, false);
    }

    private void writeErrorPathFile(@Nullable PathTemplate template, int uniqueId, Object content, boolean pCompress) {
        if (template != null) {
            Path file = template.getPath(new Object[]{uniqueId});
            try {
                if (!pCompress) {
                    IO.writeFile((Path)file, (Charset)Charset.defaultCharset(), (Object)content);
                } else {
                    file = file.resolveSibling(file.getFileName() + ".gz");
                    IO.writeGZIPFile((Path)file, (Charset)Charset.defaultCharset(), (Object)content);
                }
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write information about the error path to file");
            }
        }
    }

    static enum CounterexampleExportType {
        CBMC,
        CONCRETE_EXECUTION;

    }
}

