/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.counterexamples;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.counterexamples.AbstractSetBasedCounterexampleFilter;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class StacktraceCounterexampleFilter
extends AbstractSetBasedCounterexampleFilter<ImmutableList<CFANode>> {
    public StacktraceCounterexampleFilter(Configuration pConfig, LogManager pLogger, ConfigurableProgramAnalysis pCpa) {
        super(pConfig, pLogger, pCpa);
    }

    @Override
    protected Optional<ImmutableList<CFANode>> getCounterexampleRepresentation(CounterexampleInfo counterexample) {
        ARGState lastState = counterexample.getTargetPath().getLastState();
        ImmutableList.Builder stacktrace = ImmutableList.builder();
        stacktrace.add((Object)AbstractStates.extractLocation(lastState));
        CallstackState callstack = AbstractStates.extractStateByType(lastState, CallstackState.class);
        do {
            stacktrace.add((Object)callstack.getCallNode());
        } while ((callstack = callstack.getPreviousState()) != null);
        return Optional.of(stacktrace.build());
    }
}

