/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.cpa.arg.path.DefaultFullPathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.DefaultPathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.ReverseFullPathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.ReversePathIterator;
import org.sosy_lab.cpachecker.util.Pair;

@Immutable
public class ARGPath
extends Appenders.AbstractAppender {
    private final ImmutableList<ARGState> states;
    private final List<CFAEdge> edges;
    @SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"}, justification="This variable is only used for caching the full path for later use without having to compute it again.")
    private List<CFAEdge> fullPath = null;

    protected ARGPath(ARGPath pArgPath) {
        this.states = pArgPath.states;
        this.edges = pArgPath.edges;
    }

    public ARGPath(List<ARGState> pStates) {
        Preconditions.checkArgument((!pStates.isEmpty() ? 1 : 0) != 0, (Object)"ARGPaths may not be empty");
        this.states = ImmutableList.copyOf(pStates);
        ArrayList<CFAEdge> edgesBuilder = new ArrayList<CFAEdge>(this.states.size() - 1);
        for (int i = 0; i < this.states.size() - 1; ++i) {
            ARGState parent = (ARGState)this.states.get(i);
            ARGState child = (ARGState)this.states.get(i + 1);
            edgesBuilder.add(parent.getEdgeToChild(child));
        }
        this.edges = Collections.unmodifiableList(edgesBuilder);
        assert (this.states.size() - 1 == this.edges.size());
    }

    public ARGPath(List<ARGState> pStates, List<CFAEdge> pEdges) {
        Preconditions.checkArgument((!pStates.isEmpty() ? 1 : 0) != 0, (Object)"ARGPaths may not be empty");
        Preconditions.checkArgument((pStates.size() - 1 == pEdges.size() ? 1 : 0) != 0, (Object)"ARGPaths must have one state more than edges");
        this.states = ImmutableList.copyOf(pStates);
        this.edges = Collections.unmodifiableList(new ArrayList<CFAEdge>(pEdges));
    }

    public ImmutableList<ARGState> asStatesList() {
        return this.states;
    }

    public List<CFAEdge> getInnerEdges() {
        return this.edges;
    }

    public List<CFAEdge> getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.buildFullPath();
        }
        return this.fullPath;
    }

    @ForOverride
    protected List<CFAEdge> buildFullPath() {
        ImmutableList.Builder newFullPath = ImmutableList.builder();
        PathIterator it = this.pathIterator();
        while (it.hasNext()) {
            ARGState prev = it.getAbstractState();
            CFAEdge curOutgoingEdge = it.getOutgoingEdge();
            it.advance();
            ARGState succ = it.getAbstractState();
            if (curOutgoingEdge == null) {
                List<CFAEdge> intermediateEdges = prev.getEdgesToChild(succ);
                if (intermediateEdges.isEmpty()) {
                    return ImmutableList.of();
                }
                newFullPath.addAll(intermediateEdges);
                continue;
            }
            newFullPath.add((Object)curOutgoingEdge);
        }
        return newFullPath.build();
    }

    public ImmutableSet<ARGState> getStateSet() {
        return ImmutableSet.copyOf(this.states);
    }

    public List<Pair<ARGState, ARGState>> getStatePairs() {
        return new AbstractList<Pair<ARGState, ARGState>>(){

            @Override
            public Pair<ARGState, ARGState> get(int pIndex) {
                return Pair.of((ARGState)ARGPath.this.states.get(pIndex), (ARGState)ARGPath.this.states.get(pIndex + 1));
            }

            @Override
            public int size() {
                return ARGPath.this.states.size() - 1;
            }
        };
    }

    public PathIterator pathIterator() {
        return new DefaultPathIterator(this);
    }

    public PathIterator reversePathIterator() {
        return new ReversePathIterator(this);
    }

    public PathIterator fullPathIterator() {
        return new DefaultFullPathIterator(this);
    }

    public PathIterator reverseFullPathIterator() {
        return new ReverseFullPathIterator(this);
    }

    public static ARGPathBuilder builder() {
        return new ARGPathBuilder.DefaultARGPathBuilder();
    }

    public static ARGPathBuilder reverseBuilder() {
        return new ARGPathBuilder.ReverseARGPathBuilder();
    }

    public int size() {
        return this.states.size();
    }

    public ARGState getFirstState() {
        return (ARGState)this.states.get(0);
    }

    public ARGState getLastState() {
        return (ARGState)Iterables.getLast(this.states);
    }

    public int hashCode() {
        return Objects.hash(this.edges);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof ARGPath)) {
            return false;
        }
        return Objects.equals(this.edges, ((ARGPath)((Object)pOther)).edges);
    }

    public void appendTo(Appendable appendable) throws IOException {
        Joiner.on((String)System.lineSeparator()).skipNulls().appendTo(appendable, this.getFullPath());
        appendable.append(System.lineSeparator());
    }
}

