/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;

public abstract class ARGPathBuilder {
    final List<ARGState> states = new ArrayList<ARGState>();
    final List<CFAEdge> edges = new ArrayList<CFAEdge>();

    private ARGPathBuilder() {
    }

    public int size() {
        return this.states.size();
    }

    @CanIgnoreReturnValue
    public ARGPathBuilder add(ARGState state, CFAEdge outgoingEdge) {
        this.states.add(state);
        this.edges.add(outgoingEdge);
        return this;
    }

    @CanIgnoreReturnValue
    public ARGPathBuilder removeLast() {
        assert (!this.states.isEmpty() && !this.edges.isEmpty());
        this.states.remove(this.states.size() - 1);
        this.edges.remove(this.edges.size() - 1);
        return this;
    }

    public abstract ARGPath build(ARGState var1);

    static class ReverseARGPathBuilder
    extends ARGPathBuilder {
        ReverseARGPathBuilder() {
        }

        @Override
        public ARGPath build(ARGState pState) {
            this.states.add(pState);
            ARGPath path = new ARGPath(Lists.reverse((List)this.states), Lists.reverse((List)this.edges));
            this.states.remove(this.states.size() - 1);
            return path;
        }
    }

    static class DefaultARGPathBuilder
    extends ARGPathBuilder {
        DefaultARGPathBuilder() {
        }

        @Override
        public ARGPath build(ARGState pState) {
            this.states.add(pState);
            ARGPath path = new ARGPath(this.states, this.edges);
            this.states.remove(this.states.size() - 1);
            return path;
        }
    }
}

