/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPathBuilder;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ARGPathTest {
    private CFAEdge edge;
    private ARGState state;
    private List<CFAEdge> edges;
    private List<CFAEdge> innerEdges;
    private static final int STATE_POS_1 = 0;
    private static final int STATE_POS_2 = 1;
    private static final int STATE_POS_3 = 4;
    private ARGState firstARGState;
    private ARGState secondARGState;
    private ARGState thirdARGState;
    private ARGState lastARGState;
    private ARGPath path;

    @Before
    public void setup() {
        this.edge = new BlankEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode("test"), CFANode.newDummyCFANode("test"), "test");
        this.edge.getSuccessor().addEnteringEdge(this.edge);
        this.edge.getPredecessor().addLeavingEdge(this.edge);
        LocationState tmp = (LocationState)Mockito.mock(LocationState.class);
        Mockito.when((Object)tmp.getLocationNode()).thenReturn((Object)this.edge.getPredecessor());
        Mockito.when(tmp.getLocationNodes()).thenReturn(Collections.singleton(this.edge.getPredecessor()));
        this.state = new ARGState(tmp, null);
        this.edges = new ArrayList<CFAEdge>();
        CFANode firstNode = CFANode.newDummyCFANode("test");
        for (int i = 0; i < 10; ++i) {
            CFANode secondNode = CFANode.newDummyCFANode("test");
            BlankEdge dummyEdge = new BlankEdge("", FileLocation.DUMMY, firstNode, secondNode, "test");
            this.edges.add(dummyEdge);
            firstNode.addLeavingEdge(dummyEdge);
            secondNode.addEnteringEdge(dummyEdge);
            firstNode = secondNode;
        }
        LocationState firstState = (LocationState)Mockito.mock(LocationState.class);
        Mockito.when((Object)firstState.getLocationNode()).thenReturn((Object)this.edges.get(0).getPredecessor());
        Mockito.when(firstState.getLocationNodes()).thenReturn(Collections.singleton(this.edges.get(0).getPredecessor()));
        LocationState secondState = (LocationState)Mockito.mock(LocationState.class);
        Mockito.when((Object)secondState.getLocationNode()).thenReturn((Object)this.edges.get(1).getPredecessor());
        Mockito.when(secondState.getLocationNodes()).thenReturn(Collections.singleton(this.edges.get(1).getPredecessor()));
        LocationState thirdState = (LocationState)Mockito.mock(LocationState.class);
        Mockito.when((Object)thirdState.getLocationNode()).thenReturn((Object)this.edges.get(4).getPredecessor());
        Mockito.when(thirdState.getLocationNodes()).thenReturn(Collections.singleton(this.edges.get(4).getPredecessor()));
        LocationState lastState = (LocationState)Mockito.mock(LocationState.class);
        Mockito.when((Object)lastState.getLocationNode()).thenReturn((Object)this.edges.get(this.edges.size() - 1).getSuccessor());
        Mockito.when(lastState.getLocationNodes()).thenReturn(Collections.singleton(this.edges.get(this.edges.size() - 1).getSuccessor()));
        ARGPathBuilder builder = ARGPath.builder();
        this.innerEdges = new ArrayList<CFAEdge>();
        this.firstARGState = new ARGState(firstState, null);
        builder.add(this.firstARGState, this.edges.get(0));
        this.innerEdges.add(this.edges.get(0));
        this.secondARGState = new ARGState(secondState, null);
        this.innerEdges.add(null);
        builder.add(this.secondARGState, null);
        this.thirdARGState = new ARGState(thirdState, null);
        this.innerEdges.add(null);
        builder.add(this.thirdARGState, null);
        this.lastARGState = new ARGState(lastState, null);
        this.path = builder.build(this.lastARGState);
    }

    @Test
    public void testBuilderAdd() {
        ARGPathBuilder builder = ARGPath.builder();
        builder.add(this.state, this.edge);
        Truth.assertThat(builder.edges).containsExactly(new Object[]{this.edge});
        Truth.assertThat(builder.states).containsExactly(new Object[]{this.state});
    }

    @Test
    public void testBuilderRemove() {
        ARGPathBuilder builder = ARGPath.builder();
        builder.add(this.state, this.edge);
        builder.removeLast();
        Truth.assertThat(builder.edges).isEmpty();
        Truth.assertThat(builder.states).isEmpty();
    }

    @Test
    public void testDefaultBuilderBuild() {
        ARGPathBuilder builder = ARGPath.builder();
        builder.add(this.state, this.edge);
        LocationState tmp = (LocationState)Mockito.mock(LocationState.class);
        Mockito.when((Object)tmp.getLocationNode()).thenReturn((Object)this.edge.getSuccessor());
        Mockito.when(tmp.getLocationNodes()).thenReturn(Collections.singleton(this.edge.getSuccessor()));
        ARGState secondState = new ARGState(tmp, null);
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        states.add(this.state);
        states.add(secondState);
        ArrayList<CFAEdge> newEdges = new ArrayList<CFAEdge>();
        newEdges.add(this.edge);
        ARGPath newPath = new ARGPath(states, newEdges);
        Truth.assertThat((Object)((Object)builder.build(secondState))).isEqualTo((Object)newPath);
        Truth.assertThat(builder.edges).containsExactly(new Object[]{this.edge});
        Truth.assertThat(builder.states).containsExactly(new Object[]{this.state});
    }

    @Test
    public void testReverseBuilderBuild() {
        ARGPathBuilder builder = ARGPath.reverseBuilder();
        LocationState tmp = (LocationState)Mockito.mock(LocationState.class);
        Mockito.when((Object)tmp.getLocationNode()).thenReturn((Object)this.edge.getSuccessor());
        Mockito.when(tmp.getLocationNodes()).thenReturn(Collections.singleton(this.edge.getSuccessor()));
        ARGState secondState = new ARGState(tmp, null);
        builder.add(secondState, this.edge);
        ArrayList<ARGState> states = new ArrayList<ARGState>();
        states.add(this.state);
        states.add(secondState);
        ArrayList<CFAEdge> newEdges = new ArrayList<CFAEdge>();
        newEdges.add(this.edge);
        ARGPath newPath = new ARGPath(states, newEdges);
        Truth.assertThat((Object)((Object)builder.build(this.state))).isEqualTo((Object)newPath);
        Truth.assertThat(builder.edges).containsExactly(new Object[]{this.edge});
        Truth.assertThat(builder.states).containsExactly(new Object[]{secondState});
    }

    @Test
    public void testBuilderSize() {
        ARGPathBuilder builder = ARGPath.builder();
        Truth.assertThat((Integer)builder.size()).isEqualTo((Object)0);
        builder.add(this.state, this.edge);
        Truth.assertThat((Integer)builder.size()).isEqualTo((Object)1);
        builder.add(this.state, this.edge);
        Truth.assertThat((Integer)builder.size()).isEqualTo((Object)2);
    }

    @Test
    public void testGetFullPath() {
        List<CFAEdge> fullPath = this.path.getFullPath();
        Truth.assertThat(fullPath).isEqualTo(this.edges);
    }

    @Test
    public void testGetInnerEdges() {
        Truth.assertThat(this.path.getInnerEdges()).isEqualTo(this.innerEdges);
    }

    @Test
    public void testGetPrefixInclusive() {
        Truth.assertThat((Object)((Object)this.path.pathIterator().getPrefixInclusive())).isEqualTo((Object)ARGPath.builder().build(this.firstARGState));
        Truth.assertThat((Object)((Object)this.path.reversePathIterator().getPrefixInclusive())).isEqualTo((Object)this.path);
        PathIterator it = this.path.pathIterator();
        it.advance();
        Truth.assertThat((Object)((Object)it.getPrefixInclusive())).isEqualTo((Object)ARGPath.builder().add(this.firstARGState, this.edges.get(0)).build(this.secondARGState));
    }

    @Test
    public void testGetPrefixExclusive() {
        PathIterator it = this.path.pathIterator();
        it.advance();
        Truth.assertThat((Object)((Object)it.getPrefixExclusive())).isEqualTo((Object)ARGPath.builder().build(this.firstARGState));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetPrefixExclusiveFails() {
        this.path.pathIterator().getPrefixExclusive();
    }

    @Test
    public void testGetSuffixInclusive() {
        Truth.assertThat((Object)((Object)this.path.reversePathIterator().getSuffixInclusive())).isEqualTo((Object)ARGPath.builder().build(this.lastARGState));
        Truth.assertThat((Object)((Object)this.path.pathIterator().getSuffixInclusive())).isEqualTo((Object)this.path);
        PathIterator it = this.path.reversePathIterator();
        it.advance();
        Truth.assertThat((Object)((Object)it.getSuffixInclusive())).isEqualTo((Object)ARGPath.builder().add(this.thirdARGState, null).build(this.lastARGState));
    }

    @Test
    public void testGetSuffixExclusive() {
        PathIterator it = this.path.reversePathIterator();
        it.advance();
        Truth.assertThat((Object)((Object)it.getSuffixExclusive())).isEqualTo((Object)ARGPath.builder().build(this.lastARGState));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetSuffixExclusiveFails() {
        this.path.reversePathIterator().getSuffixExclusive();
    }

    @Test
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="We want the the excpetions to be thrown in the unit test, and we are sure that we can continue afterwards.")
    public void testFullPathIterator() {
        PathIterator pathIt = this.path.fullPathIterator();
        for (int i = 0; i < this.edges.size(); ++i) {
            Truth.assertThat((Object)pathIt.getOutgoingEdge()).isEqualTo((Object)this.edges.get(i));
            switch (i) {
                case 0: {
                    Assert.assertThrows((String)"getPreviousAbstractState should throw while not having advanced the iterator by one position", IllegalStateException.class, pathIt::getPreviousAbstractState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState});
                    Assert.assertThrows((String)"getPrefixExclusive should throw while not having advanced the iterator by one position", IllegalStateException.class, pathIt::getPrefixExclusive);
                    break;
                }
                case 1: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState});
                    Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState});
                    break;
                }
                case 4: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState});
                    Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState});
                    break;
                }
                default: {
                    Assert.assertThrows((String)"getAbstractState should throw while in the middle of a hole in the path", IllegalStateException.class, pathIt::getAbstractState);
                    if (i < 4) {
                        Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                        Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                        Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState});
                        Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState});
                        break;
                    }
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState, this.lastARGState});
                    Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState});
                }
            }
            pathIt.advance();
        }
        Assert.assertThrows((String)"getNextAbstractState should throw if the iterator is on its last element", IllegalStateException.class, pathIt::getNextAbstractState);
    }

    @Test
    public void testReverseFullPathIterator() {
        PathIterator pathIt = this.path.reverseFullPathIterator();
        Assert.assertThrows((String)"getNextAbstractState should throw if the iterator is on its last element", IllegalStateException.class, pathIt::getNextAbstractState);
        pathIt.advance();
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            Truth.assertThat((Object)pathIt.getOutgoingEdge()).isEqualTo((Object)this.edges.get(i));
            switch (i) {
                case 0: {
                    Assert.assertThrows((String)"getPreviousAbstractState should throw while not having advanced the iterator by one position", IllegalStateException.class, pathIt::getPreviousAbstractState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.secondARGState);
                    break;
                }
                case 1: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                    break;
                }
                case 4: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                    break;
                }
                default: {
                    Assert.assertThrows((String)"getAbstractState should throw while in the middle of a whole in the path", IllegalStateException.class, pathIt::getAbstractState);
                    if (i < 4) {
                        Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                        Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                        break;
                    }
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                }
            }
            if (i <= 0) continue;
            pathIt.advance();
        }
    }

    @Test
    public void testFullPathIterator2() {
        PathIterator pathIt = this.path.fullPathIterator();
        while (pathIt.hasNext()) {
            pathIt.advance();
        }
        Assert.assertThrows((String)"getNextAbstractState should throw if the iterator is on its last element", IllegalStateException.class, pathIt::getNextAbstractState);
        pathIt.rewind();
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            Truth.assertThat((Object)pathIt.getOutgoingEdge()).isEqualTo((Object)this.edges.get(i));
            switch (i) {
                case 0: {
                    Assert.assertThrows((String)"getPreviousAbstractState should throwwhile not having advanced the iterator by one position", IllegalStateException.class, pathIt::getPreviousAbstractState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.secondARGState);
                    break;
                }
                case 1: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                    break;
                }
                case 4: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                    break;
                }
                default: {
                    Assert.assertThrows((String)"getAbstractState should throw while in the middle of a whole in the path", IllegalStateException.class, pathIt::getAbstractState);
                    if (i < 4) {
                        Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                        Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                        break;
                    }
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                }
            }
            if (i <= 0) continue;
            pathIt.rewind();
        }
    }

    @Test
    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="We want the the excpetions to be thrown in the unit test, and we are sure that we can continue afterwards.")
    public void testReverseFullPathIterator2() {
        PathIterator pathIt = this.path.reverseFullPathIterator();
        while (pathIt.hasNext()) {
            pathIt.advance();
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            Truth.assertThat((Object)pathIt.getOutgoingEdge()).isEqualTo((Object)this.edges.get(i));
            switch (i) {
                case 0: {
                    Assert.assertThrows((String)"getPreviousAbstractState should throw while not having advanced the iterator by one position", IllegalStateException.class, pathIt::getPreviousAbstractState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState});
                    Assert.assertThrows((String)"getPrefixExclusive should throw while not having advanced  the iterator by one position", IllegalStateException.class, pathIt::getPrefixExclusive);
                    break;
                }
                case 1: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.firstARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState});
                    Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState});
                    break;
                }
                case 4: {
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                    Truth.assertThat((Comparable)pathIt.getAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState});
                    Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState});
                    break;
                }
                default: {
                    Assert.assertThrows((String)"getAbstractState should throw while in the middle of a hole in the path", IllegalStateException.class, pathIt::getAbstractState);
                    if (i < 4) {
                        Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.secondARGState);
                        Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.thirdARGState);
                        Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState});
                        Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState});
                        break;
                    }
                    Truth.assertThat((Comparable)pathIt.getPreviousAbstractState()).isEqualTo((Object)this.thirdARGState);
                    Truth.assertThat((Comparable)pathIt.getNextAbstractState()).isEqualTo((Object)this.lastARGState);
                    Truth.assertThat(pathIt.getPrefixInclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState, this.lastARGState});
                    Truth.assertThat(pathIt.getPrefixExclusive().asStatesList()).containsExactly(new Object[]{this.firstARGState, this.secondARGState, this.thirdARGState});
                }
            }
            pathIt.rewind();
        }
        Assert.assertThrows((String)"getNextAbstractState should throw if the iterator is on its last element", IllegalStateException.class, pathIt::getNextAbstractState);
    }

    @Test
    public void testPathPositionDefault() {
        PathIterator it = this.path.pathIterator();
        it.advance();
        Truth.assertThat((Object)it.getIncomingEdge()).isEqualTo((Object)it.getPosition().fullPathIterator().getIncomingEdge());
        it.advance();
        Truth.assertThat((Comparable)it.getPosition().fullPathIterator().getIncomingEdge().getPredecessor()).isNotEqualTo((Object)AbstractStates.extractLocation(this.firstARGState));
        it = this.path.fullPathIterator();
        it.advance();
        PathIterator it2 = it.getPosition().iterator();
        Truth.assertThat((Object)it.getIncomingEdge()).isEqualTo((Object)it2.getIncomingEdge());
        it.advance();
        Truth.assertThat((Object)it2.getIncomingEdge()).isEqualTo((Object)it.getPosition().iterator().getIncomingEdge());
        Truth.assertThat((Object)it.getPosition().fullPathIterator().getOutgoingEdge()).isEqualTo((Object)it.getOutgoingEdge());
    }

    @Test
    public void testPathPositionReverse() {
        PathIterator it = this.path.reversePathIterator();
        while (it.advanceIfPossible()) {
        }
        it.rewind();
        Truth.assertThat((Object)it.getIncomingEdge()).isEqualTo((Object)it.getPosition().reverseFullPathIterator().getIncomingEdge());
        it.rewind();
        Truth.assertThat((Comparable)it.getPosition().fullPathIterator().getIncomingEdge().getPredecessor()).isNotEqualTo((Object)AbstractStates.extractLocation(this.firstARGState));
        it = this.path.reverseFullPathIterator();
        while (it.advanceIfPossible()) {
        }
        it.rewind();
        PathIterator it2 = it.getPosition().reverseIterator();
        Truth.assertThat((Object)it.getIncomingEdge()).isEqualTo((Object)it2.getIncomingEdge());
        it.rewind();
        Truth.assertThat((Object)it2.getIncomingEdge()).isEqualTo((Object)it.getPosition().reverseIterator().getIncomingEdge());
        Truth.assertThat((Object)it.getPosition().reverseFullPathIterator().getOutgoingEdge()).isEqualTo((Object)it.getOutgoingEdge());
    }
}

